/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.hive.resource.HiveUIBundle;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.ui.TitledSeparator;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class HiveStoragePanel
extends BaseEditorPanel<Table> {
    private final MultiMap<PropertySet, String> m_propMap = new MultiMap();
    private final JRadioButton m_btnNative = new JRadioButton();
    private final JRadioButton m_btnNonNative = new JRadioButton();
    private final JPanel m_nativePanel = new JPanel();
    private final JPanel m_nonNativePanel = new JPanel();
    private final JPanel m_delimPanel = new JPanel();
    private final JPanel m_serdePanel = new JPanel();
    private final JPanel m_storageFormatPanel = new JPanel();
    private final JRadioButton m_btnDelim = new JRadioButton();
    private final JRadioButton m_btnSerde = new JRadioButton();
    private Component m_serdePropsTab;
    private GridBagConstraints m_gbcSerde;
    private GridBagConstraints m_gbcNonNative;
    private final Component m_glue = Box.createVerticalGlue();

    public HiveStoragePanel() {
        super("HiveStoragePanel");
        this.getComponentFactory().setAllowRecreate(false);
    }

    @Override
    protected void initialiseComponents() {
        ActionListener list = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HiveStoragePanel.this.isEntered()) {
                    HiveStoragePanel.this.checkPanels(false);
                }
            }
        };
        DBUIResourceHelper reshelp = this.getComponentFactory().getResourceHelper();
        reshelp.resButton(this.m_btnNative, HiveUIBundle.get("NATIVE"), "nativeRadio");
        reshelp.resButton(this.m_btnNonNative, HiveUIBundle.get("NON_NATIVE"), "nonNativeRadio");
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.m_btnNative);
        bg1.add(this.m_btnNonNative);
        this.m_btnNative.setSelected(true);
        this.m_btnNative.addActionListener(list);
        this.m_btnNonNative.addActionListener(list);
        reshelp.resButton(this.m_btnDelim, HiveUIBundle.get("DELIMITED"), "delimRadio");
        reshelp.resButton(this.m_btnSerde, HiveUIBundle.get("SERDE"), "serDeRadio");
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.m_btnDelim);
        bg2.add(this.m_btnSerde);
        this.m_btnDelim.setSelected(true);
        this.m_btnDelim.addActionListener(list);
        this.m_btnSerde.addActionListener(list);
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        JLabel nativeLabel = new JLabel(HiveUIBundle.get("STORAGE_TYPE"));
        layout.add(nativeLabel);
        layout.add(this.m_btnNative);
        layout.add(this.m_btnNonNative);
        layout.nextRow();
        this.layoutNativePanel();
        layout.add(this.m_nativePanel, 3, 1, true, true);
        layout.indent(this.m_nativePanel);
        layout.nextRow();
        this.layoutNonNativePanel();
        layout.add(this.m_nonNativePanel, 3, 1, true, true);
        layout.indent(this.m_nonNativePanel);
        this.m_nonNativePanel.setVisible(false);
        layout.nextRowWithGap();
        ComponentWrapper wrap = this.getHiveWrapper("hdfsLocation", null);
        layout.add(wrap.getLabel());
        layout.add(wrap.getComponent(), 2, 1);
        layout.nextRow();
        layout.layout();
        if (this.disableRadios()) {
            nativeLabel.setEnabled(false);
            this.m_btnNative.setEnabled(false);
            this.m_btnNonNative.setEnabled(false);
        }
    }

    private boolean disableRadios() {
        return !this.isEditable() || this.isEditInDatabase();
    }

    private boolean isEditInDatabase() {
        return this.isEditing() && this.getProvider() instanceof Database;
    }

    private void layoutNativePanel() {
        String rowForm = HiveUIBundle.get("ROW_FORMAT");
        DBUILayoutHelper layout = new DBUILayoutHelper(this.m_nativePanel);
        layout.add((Component)new TitledSeparator(rowForm), 3, 1);
        layout.nextRow();
        if (!this.isEditInDatabase()) {
            JLabel rowFormLabel = new JLabel(HiveUIBundle.get("ROW_FORMAT_TYPE"));
            layout.add(rowFormLabel);
            layout.add(this.m_btnDelim);
            layout.add(this.m_btnSerde);
            layout.nextRow();
            this.layoutDelimPanel();
            layout.add(this.m_delimPanel, 3, 1, true, false);
            layout.indent(this.m_delimPanel);
            layout.nextRow();
        }
        this.layoutSerdePanel();
        layout.add(this.m_serdePanel, 3, 1, true, true);
        layout.indent(this.m_serdePanel);
        this.m_serdePanel.setVisible(false);
        layout.nextRowWithGap();
        this.layoutStorageFormatPanel();
        layout.add(this.m_storageFormatPanel, 3, 1, true, false);
        layout.nextRow();
        layout.add(this.m_glue, 1, 1, false, true);
        layout.layout();
    }

    private void layoutNonNativePanel() {
        DBUILayoutHelper layout = new DBUILayoutHelper(this.m_nonNativePanel);
        this.addToLayout(layout, "storageHandlerClass", PropertySet.SERDE, true);
        Component serdePropsTab = this.getSerdePropsTable();
        layout.add(serdePropsTab, 2, 1);
        this.m_gbcNonNative = layout.getConstraints(serdePropsTab);
        layout.layout();
    }

    private void layoutSerdePanel() {
        DBUILayoutHelper layout = new DBUILayoutHelper(this.m_serdePanel);
        this.addToLayout(layout, "serDeClass", PropertySet.SERDE, true);
        Component serdePropsTab = this.getSerdePropsTable();
        layout.add(serdePropsTab, 2, 1);
        this.m_gbcSerde = layout.getConstraints(serdePropsTab);
        layout.layout();
    }

    private void layoutDelimPanel() {
        DBUILayoutHelper layout = new DBUILayoutHelper(this.m_delimPanel);
        this.addToLayout(layout, "fieldDelim", PropertySet.DELIM, false);
        this.addToLayout(layout, "fieldEscape", PropertySet.DELIM, true);
        this.addToLayout(layout, "collectionItemDelim", PropertySet.DELIM, false);
        this.addToLayout(layout, "mapKeyDelim", PropertySet.DELIM, true);
        this.addToLayout(layout, "lineDelim", PropertySet.DELIM, false);
        this.addToLayout(layout, "nullFormat", PropertySet.DELIM, true);
        layout.layout();
    }

    private void layoutStorageFormatPanel() {
        DBUILayoutHelper layout = new DBUILayoutHelper(this.m_storageFormatPanel);
        layout.add((Component)new TitledSeparator(HiveUIBundle.get("STORAGE_FORMAT")), 2, 1);
        layout.nextRow();
        ComponentWrapper pffcw = this.getHiveWrapper("predefinedFileFormat", PropertySet.FILEFORMAT);
        layout.add(pffcw);
        layout.nextRow();
        pffcw.addListener(evt -> this.processPredefinedFormatChange(evt.getNewValue() != null));
        this.addToLayout(layout, "inputFormatClass", PropertySet.FILEFORMAT, true);
        this.addToLayout(layout, "outputFormatClass", PropertySet.FILEFORMAT, true);
        layout.layout();
    }

    private void processPredefinedFormatChange(boolean predef) {
        if (this.isEntered()) {
            ComponentWrapper incw = this.getHiveWrapper("inputFormatClass", null);
            ComponentWrapper outcw = this.getHiveWrapper("outputFormatClass", null);
            HiveStoragePanel.processPredefinedFormatChange(predef, this.getOriginalObject(), this.getPropertyHelper(), incw, outcw);
        }
    }

    private void addToLayout(DBUILayoutHelper layout, String storageProp, PropertySet set, boolean row) {
        layout.add(this.getHiveWrapper(storageProp, set));
        if (row) {
            layout.nextRow();
        } else {
            layout.nextColumn();
        }
    }

    private ComponentWrapper getHiveWrapper(String storageProp, PropertySet set) {
        if (set != null) {
            this.m_propMap.add((Object)set, (Object)storageProp);
        }
        return this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", storageProp}));
    }

    private Component getSerdePropsTable() {
        if (this.m_serdePropsTab == null) {
            this.m_serdePropsTab = this.getHiveWrapper("serDeProperties", PropertySet.NON_NATIVE).getComponent();
        }
        return this.m_serdePropsTab;
    }

    @Override
    protected void initialisePanel() {
        HiveStorageProperties htp = (HiveStorageProperties)((Table)this.getUpdatedObject()).getProperty("HiveStorageProperties");
        if (htp != null && ModelUtil.hasLength((String)htp.getStorageHandlerClass())) {
            this.m_btnNonNative.setSelected(true);
        } else {
            this.m_btnNative.setSelected(true);
            if (htp != null && ModelUtil.hasLength((String)htp.getSerDeClass())) {
                this.m_btnSerde.setSelected(true);
            } else {
                this.m_btnDelim.setSelected(true);
            }
        }
        this.checkPanels(true);
    }

    private void checkPanels(boolean onEntry) {
        boolean changeModel = !onEntry && !this.isEditInDatabase();
        boolean nativeLayout = this.m_btnNative.isSelected();
        this.m_nativePanel.setVisible(nativeLayout);
        this.m_nonNativePanel.setVisible(!nativeLayout);
        if (nativeLayout) {
            boolean serde = this.m_btnSerde.isSelected();
            this.m_serdePanel.setVisible(serde);
            this.m_delimPanel.setVisible(!serde);
            this.m_glue.setVisible(!serde);
            if (serde && this.m_serdePropsTab.getParent() != this.m_serdePanel) {
                this.m_serdePanel.add(this.m_serdePropsTab, this.m_gbcSerde);
            }
            if (changeModel) {
                this.nullProperties(PropertySet.NON_NATIVE);
                this.nullProperties(serde ? PropertySet.DELIM : PropertySet.SERDE);
            }
        } else {
            if (this.m_serdePropsTab.getParent() != this.m_nonNativePanel) {
                this.m_nonNativePanel.add(this.m_serdePropsTab, this.m_gbcNonNative);
            }
            if (changeModel) {
                this.nullProperties(PropertySet.DELIM);
                this.nullProperties(PropertySet.FILEFORMAT);
                this.nullProperties(PropertySet.SERDE);
            }
        }
    }

    private void nullProperties(PropertySet set) {
        for (String prop : this.m_propMap.get((Object)set)) {
            this.getHiveWrapper(prop, null).resetPropertyValue(null);
        }
        if (set == PropertySet.FILEFORMAT) {
            this.processPredefinedFormatChange(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.getProvider() instanceof Database) {
            HiveStorageProperties htp = (HiveStorageProperties)((Table)this.getUpdatedObject()).getProperty("HiveStorageProperties");
            if (this.m_btnNonNative.isSelected()) {
                if (htp == null || !ModelUtil.hasLength((String)htp.getStorageHandlerClass())) {
                    throw new TraversalException(HiveUIBundle.get("ERR_MISSING_STORAGE_HANDLER"));
                }
            } else if (this.m_btnSerde.isSelected() && (htp == null || !ModelUtil.hasLength((String)htp.getSerDeClass()))) {
                throw new TraversalException(HiveUIBundle.get("ERR_MISSING_SERDE"));
            }
        }
    }

    static void processPredefinedFormatChange(boolean predef, DBObject orig, PropertyHelper helper, ComponentWrapper incw, ComponentWrapper outcw) {
        incw.setEnabled(!predef);
        outcw.setEnabled(!predef);
        String in = null;
        String out = null;
        if (!predef && orig != null) {
            in = (String)helper.getPropertyValue((Object)orig, Property.createPath((String[])new String[]{"HiveStorageProperties", "inputFormatClass"}));
            out = (String)helper.getPropertyValue((Object)orig, Property.createPath((String[])new String[]{"HiveStorageProperties", "outputFormatClass"}));
        }
        incw.resetPropertyValue(in);
        outcw.resetPropertyValue(out);
    }

    private static enum PropertySet {
        NON_NATIVE,
        DELIM,
        SERDE,
        FILEFORMAT;

    }
}

