/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.dialogs.CascadeConfirmDialog;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class BaseChildrenEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseEditorPanel<P> {
    private static final String NAME_SETTINGS_KEY = "db-current-child-name";
    private Holder<ChildObjectEditorPanel> m_childPanel;
    private C m_currentChild;
    private DocumentListener m_childDocListener;
    private Namespace m_childDataContext;
    private String m_childProperty;

    public BaseChildrenEditorPanel(String panelName) {
        super(panelName);
    }

    protected abstract ChildObjectEditorPanel<C, P> createChildPanel();

    protected final ChildObjectEditorPanel getChildPanel() {
        if (this.m_childPanel == null) {
            this.m_childPanel = new Holder(this.createChildPanel());
        }
        return (ChildObjectEditorPanel)this.m_childPanel.get();
    }

    public final C getCurrentChild() {
        return this.m_currentChild;
    }

    protected final void setCurrentChild(C child) {
        this.m_currentChild = child;
    }

    protected abstract void selectChild(C var1);

    protected String getChildProperty() {
        if (this.m_childProperty == null) {
            throw new IllegalStateException("getChildProperty() must be overridden (unless used exclusively via a ComponentWrapper).");
        }
        return this.m_childProperty;
    }

    @Override
    protected void initialiseWrappedPanel(ComponentContext context) {
        super.initialiseWrappedPanel(context);
        this.m_childProperty = context.getPropertyName();
    }

    protected abstract Class<C> getChildClass();

    protected String getChildType() {
        return Metadata.getType(this.getChildClass());
    }

    protected boolean isHorizontalSplit() {
        return true;
    }

    protected C newChild() {
        String base;
        ChildDBObject newChild = (ChildDBObject)this.getProvider().getObjectFactory().newObject(this.getChildClass(), this.getParentUpdatedObject());
        String initName = newChild.getName();
        String string = base = initName != null ? initName : this.getNewChildBaseName();
        if (base != null) {
            newChild.setName(DBUtil.getUniqueName(this.getChildNames(), (String)base));
        }
        TemporaryObjectID.setID((DBObject)newChild, (boolean)true);
        return (C)newChild;
    }

    protected void removeFromParent(C child) {
        DBObject parFromContext = this.getParentUpdatedObject();
        DBObject par = child.getParent();
        boolean inHeirachy = false;
        for (DBObject test = par; test != null; test = test.getParent()) {
            if (test != parFromContext) continue;
            inHeirachy = true;
            break;
        }
        if (inHeirachy) {
            par.removeOwnedObject(child);
        }
    }

    protected boolean confirmCascadeDelete(C child) {
        Object parent = this.getUpdatedObject();
        return this.confirmCascadeDelete((ChildDBObject)child, (DBObject)parent);
    }

    protected boolean confirmCascadeDelete(ChildDBObject child, DBObject parent) {
        boolean canDelete = true;
        if (!this.isInFlatEditor() && child != null) {
            CascadeRequiredException cre;
            ArrayList<DBObject> toDelete = new ArrayList<DBObject>();
            ArrayList<DBObjectID> deleteIds = new ArrayList<DBObjectID>();
            this.addCascadeItems((DBObject)child, parent, toDelete, deleteIds);
            if (deleteIds != null && deleteIds.size() > 0 && (canDelete = CascadeConfirmDialog.confirmCascade((Component)((Object)this), cre = new CascadeRequiredException((DBObject)child, deleteIds), null, null))) {
                try {
                    this.cascadeChildDelete((DBObject)child, parent, toDelete);
                }
                catch (DBException dbe) {
                    DBExceptionDialog.showErrorDialog((Component)((Object)this), ProviderOperator.getErrorTitle(this.getEditorConfig()), dbe);
                }
            }
        }
        return canDelete;
    }

    protected void cascadeChildDelete(DBObject child, DBObject parent, Collection<DBObject> toDelete) throws DBException {
        Map validators = this.getProvider().getDescriptor().getValidators(this.getProvider());
        DBObjectValidator validator = (DBObjectValidator)validators.get(parent.getType());
        for (DBObject dep : toDelete) {
            validator.cascadeDelete(dep, parent);
        }
        validator.cascadeDelete(child, parent);
    }

    private void addCascadeItems(DBObject removeObj, DBObject parent, Collection<DBObject> toDelete, Collection<DBObjectID> deleteIds) {
        Collection<DBObject> usages = this.findUsagesIn(removeObj, parent);
        for (DBObject usage : usages) {
            DBObjectID depId = usage.getID();
            if (depId == null || deleteIds.contains(depId)) continue;
            deleteIds.add(depId);
            toDelete.add(usage);
            this.addCascadeItems(usage, parent, toDelete, deleteIds);
        }
    }

    protected Collection<DBObject> findUsagesIn(DBObject removeObj, DBObject parent) {
        return DBUtil.findUsagesIn((DBObject)removeObj, (DBObject)parent);
    }

    protected DBObject getParentUpdatedObject() {
        Namespace parent;
        Namespace dataContext;
        DBObject retval = null;
        if (ModelUtil.hasLength((String)this.getComponentFactory().getBasePath()) && (dataContext = this.getDataContext()) != (parent = dataContext.getParent())) {
            retval = (DBObject)parent.find("NewChildObject");
        }
        if (retval == null) {
            retval = (DBObject)this.getUpdatedObject();
        }
        return retval;
    }

    protected final Collection<String> getChildNames() {
        ArrayList<String> retval = new ArrayList<String>();
        for (ChildDBObject child : this.getChildren()) {
            retval.add(child.getName());
        }
        return retval;
    }

    protected String getNewChildBaseName() {
        String candidate;
        String base = this.getChildType();
        if (this.getProvider().getDescriptor().getCasePolicy() == 1) {
            base = base.toLowerCase();
        }
        if (!(candidate = base + "1").equals(this.getProvider().getExternalName(candidate))) {
            candidate = candidate.replace(' ', '_');
        }
        return candidate;
    }

    protected boolean canChangeChildProperty() {
        boolean retval = true;
        Object obj = this.getUpdatedObject();
        if (obj instanceof SystemObject) {
            String basePath = this.getComponentFactory().getBasePath();
            String childProp = this.getChildProperty();
            String propPath = ModelUtil.hasLength((String)basePath) ? Property.createPath((String[])new String[]{basePath, childProp}) : childProp;
            PropertyAction action = this.getProvider().getPropertyManager().canChangeProperty((SystemObject)this.getOriginalObject(), (SystemObject)obj, propPath);
            retval = action != null;
        }
        return retval;
    }

    protected boolean preserveListOrder() {
        return true;
    }

    protected Comparator<? super C> getChildComparator() {
        return DBUtil.getNameComparator();
    }

    protected List<C> getChildList() {
        Comparator<C> comparator;
        ArrayList<ChildDBObject> retval;
        block5: {
            retval = new ArrayList<ChildDBObject>();
            DBObject parObj = this.getParentUpdatedObject();
            String propPath = this.getChildProperty();
            try {
                Object obj = this.getPropertyHelper().getPropertyValueOrFail((Object)parObj, propPath);
                if (obj == null) break block5;
                if (obj instanceof DBObject[]) {
                    DBObject[] childList = (DBObject[])obj;
                    for (int i = 0; i < childList.length; ++i) {
                        retval.add((ChildDBObject)childList[i]);
                    }
                    break block5;
                }
                throw new IllegalStateException("property must be a list of child objects");
            }
            catch (MissingPropertyException mpe) {
                throw new IllegalStateException("no such property: " + propPath);
            }
        }
        if (!this.preserveListOrder() && (comparator = this.getChildComparator()) != null) {
            Collections.sort(retval, comparator);
        }
        return retval;
    }

    protected Namespace getChildDataContext() {
        if (this.m_childDataContext == null) {
            this.m_childDataContext = new Namespace(this.getDataContext());
        }
        this.m_childDataContext.put("NewChildObject", this.m_currentChild);
        return this.m_childDataContext;
    }

    private DocumentListener getChildDocListener() {
        if (this.m_childDocListener == null) {
            this.m_childDocListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    BaseChildrenEditorPanel.this.currentChildNameChangedImpl();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    BaseChildrenEditorPanel.this.currentChildNameChangedImpl();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    BaseChildrenEditorPanel.this.currentChildNameChangedImpl();
                }
            };
        }
        return this.m_childDocListener;
    }

    private void currentChildNameChangedImpl() {
        if (this.isEntered()) {
            this.currentChildNameChanged();
        }
    }

    protected void currentChildNameChanged() {
    }

    protected void enterChildPanel(C child) {
        this.m_currentChild = child;
        ChildObjectEditorPanel childPanel = this.getChildPanel();
        if (childPanel != null) {
            childPanel.onEntry(this.getChildDataContext());
            if (this.m_currentChild != null) {
                this.setChildPanelNameListenerEnabled(true);
            }
        }
    }

    private void setChildPanelNameListenerEnabled(boolean on) {
        JTextComponent nameField;
        ChildObjectEditorPanel childPanel = this.getChildPanel();
        if (childPanel != null && (nameField = childPanel.getNameField()) != null) {
            DocumentListener docL = this.getChildDocListener();
            nameField.getDocument().removeDocumentListener(docL);
            if (on) {
                nameField.getDocument().addDocumentListener(docL);
            }
        }
    }

    protected boolean exitChildPanel() {
        boolean retval = true;
        ChildObjectEditorPanel childPanel = this.getChildPanel();
        if (childPanel != null && this.getCurrentChild() != null) {
            try {
                childPanel.onExit(this.getChildDataContext());
                this.setChildPanelNameListenerEnabled(false);
            }
            catch (TraversalException te) {
                retval = false;
                te.showMessageDialog((Component)((Object)this));
            }
        }
        return retval;
    }

    protected void commitChildProperty() {
        this.getPropertyHelper().setPropertyValue((Object)this.getParentUpdatedObject(), this.getChildProperty(), (Object)this.getChildren());
    }

    protected abstract C[] getChildren();

    protected final C getInitialChild(C wasSelected) {
        ChildDBObject retval = null;
        ChildDBObject[] children = this.getChildren();
        if (children.length > 0) {
            ChildDBObject childFromConfig = (ChildDBObject)this.getInitialSelection(this.getChildClass());
            if (childFromConfig != null) {
                retval = this.findChild(childFromConfig, children);
            }
            if (retval == null && wasSelected != null) {
                retval = this.findChild((ChildDBObject)wasSelected, children);
            }
            if (retval == null) {
                retval = children[0];
            }
        }
        return (C)retval;
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        ChildObjectEditorPanel childPanel;
        boolean retval = false;
        DBEditorConfig config = this.getEditorConfig();
        if (this.isInitialSelectionProcessed() && config.getProperty() != null && (childPanel = this.getChildPanel()) != null) {
            retval = childPanel.requestFocusForEditorConfig();
        }
        if (!retval) {
            retval = super.requestFocusForEditorConfig();
        }
        return retval;
    }

    protected C findChild(C child, C[] children) {
        C exactMatch = null;
        C fuzzyMatch = null;
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == child) {
                exactMatch = children[i];
                break;
            }
            if (fuzzyMatch != null || !DBUtil.areNamesAndTypesEqual(children[i], child)) continue;
            fuzzyMatch = children[i];
        }
        return exactMatch != null ? exactMatch : fuzzyMatch;
    }

    @Override
    public void saveSettings(PropertyAccess props) {
        super.saveSettings(props);
        C child = this.getCurrentChild();
        if (child != null) {
            props.setProperty(NAME_SETTINGS_KEY, child.getName());
        }
    }

    @Override
    protected void loadSettings(PropertyAccess props) {
        ChildDBObject[] kids;
        super.loadSettings(props);
        String childName = props.getProperty(NAME_SETTINGS_KEY, null);
        if (childName != null && (kids = this.getChildren()) != null) {
            for (ChildDBObject kid : kids) {
                if (kid == null || !kid.getName().equals(childName)) continue;
                this.selectChild(kid);
                break;
            }
        }
    }
}

