/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.lang.reflect.Array;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;

public abstract class ChildListEditorPanel<C extends ChildDBObject, P extends DBObject>
extends ChildSelectableComponentEditorPanel<C, P> {
    public ChildListEditorPanel() {
        this(null);
    }

    public ChildListEditorPanel(String panelName) {
        super(panelName);
    }

    @Override
    protected SelectableComponent createSelectableComponent() {
        final DefaultListModel model = new DefaultListModel();
        final JList list = new JList(model);
        list.setSelectionMode(2);
        list.setCellRenderer(DBValidationManager.wrapListCellRenderer(this.createItemRenderer(), this.getDataContext()));
        model.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.listContentsChangedImpl();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.listContentsChangedImpl();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.listContentsChangedImpl();
            }

            private void listContentsChangedImpl() {
                if (ChildListEditorPanel.this.isEntered()) {
                    list.setFocusable(model.getSize() > 0);
                }
            }
        });
        return SelectableComponent.createSelectableComponent(list);
    }

    @Override
    protected void populateComponent() {
        List childList = this.getChildList();
        for (ChildDBObject child : childList) {
            this.getSelectableComponent().add(child);
        }
    }

    @Override
    protected C[] getChildren() {
        ChildDBObject[] retval = (ChildDBObject[])Array.newInstance(this.getChildClass(), this.getSelectableComponent().size());
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (ChildDBObject)this.getSelectableComponent().get(i);
        }
        return retval;
    }

    @Override
    protected ListButtons createListButtons() {
        return new ListButtons(this.getSelectableComponent(), this.createButtonsHelper());
    }

    @Deprecated
    protected final DefaultListModel getChildModel() {
        return (DefaultListModel)((JList)this.getSelectableComponent().getComponent()).getModel();
    }

    @Deprecated
    protected void commitChildList() {
        this.commitChildProperty();
    }

    protected ListCellRenderer createItemRenderer() {
        return new DBObjectRenderer();
    }
}

