/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.swing.text.JTextComponent;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class ChildObjectEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseEditorPanel<P> {
    private boolean m_childComponentsExist;
    private C m_currentChild;
    private boolean m_singleChild;
    private String m_extraPropPath;

    protected ChildObjectEditorPanel(String basePath) {
        this(null, basePath);
    }

    protected ChildObjectEditorPanel(String panelName, String basePath) {
        this(panelName, basePath, false);
    }

    protected ChildObjectEditorPanel(String panelName, String basePath, boolean singleChild) {
        super(panelName);
        this.getComponentFactory().setBasePath(basePath);
        this.m_singleChild = singleChild;
    }

    protected final C getChildObject() {
        ChildDBObject retval = null;
        if (this.m_singleChild) {
            DBObject parent = this.getComponentFactoryUpdatedObject();
            if (parent != null) {
                retval = (ChildDBObject)this.getPropertyHelper().getPropertyValue((Object)parent, this.getPropertyPath());
            }
        } else {
            retval = (ChildDBObject)this.getChildObjectFromDataContext();
        }
        return (C)retval;
    }

    private C getChildObjectFromDataContext() {
        return (C)((ChildDBObject)this.getDataContext().get("NewChildObject"));
    }

    protected C getOriginalChildObject() {
        return (C)((ChildDBObject)TemporaryObjectID.findOriginalObject(this.getChildObject()));
    }

    @Override
    protected DBObject getComponentFactoryUpdatedObject() {
        Object retval;
        if (this.m_singleChild) {
            Namespace dataContext;
            String propPath = this.getPropertyPath();
            if (propPath == null) {
                throw new IllegalStateException("Expecting a single child edit but we have no property path");
            }
            Namespace current = dataContext = this.getDataContext();
            Holder childHolder = null;
            while (true) {
                if (current.contains("NewChildObject")) {
                    DBObject child = (DBObject)current.get("NewChildObject");
                    childHolder = new Holder((Object)child);
                    break;
                }
                Namespace next = current.getParent();
                if (next == null || current == next) break;
                current = next;
            }
            String basePath = this.getComponentFactory().getBasePath();
            if (childHolder == null) {
                retval = this.getUpdatedObject();
                if (ModelUtil.hasLength((String)basePath)) {
                    throw new IllegalStateException("Not expecting a base path if we're editing directly on the top object.");
                }
            } else {
                retval = (DBObject)childHolder.get();
            }
        } else {
            retval = this.getChildObjectFromDataContext();
        }
        return retval;
    }

    @Override
    protected DBObject getComponentFactoryOriginalObject() {
        return TemporaryObjectID.findOriginalObject((DBObject)this.getComponentFactoryUpdatedObject());
    }

    protected JTextComponent getNameField() {
        JTextComponent retval = null;
        ComponentWrapper wrapper = this.getComponentFactory().findComponentWrapper("name");
        if (wrapper != null) {
            retval = (JTextComponent)wrapper.getActiveComponent();
        }
        return retval;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getNameField();
    }

    @Override
    protected String getComponentPath(String propName) {
        String retval = this.m_singleChild ? Property.createPath((String[])new String[]{this.getPropertyPath(), propName}) : propName;
        return retval;
    }

    private void initialiseChildWrappers() {
        if (this.usesComponentWrappers()) {
            Boolean visible = null;
            C child = this.getChildObject();
            if (child != this.m_currentChild) {
                this.m_currentChild = child;
                visible = child != null;
            } else if (this.m_singleChild && !this.m_childComponentsExist) {
                visible = true;
            }
            if (visible != null) {
                if (!this.m_singleChild) {
                    if (visible.booleanValue()) {
                        this.setVisible(true);
                    } else {
                        this.setVisible(false);
                    }
                }
                if (!this.m_childComponentsExist && visible.booleanValue()) {
                    this.initialiseChildComponents();
                    this.getComponentFactory().processComponents();
                    this.m_childComponentsExist = true;
                }
                this.validate();
                this.repaint();
            }
        }
    }

    @Override
    protected final void canCommit() throws TraversalException {
        if (!this.m_singleChild) {
            super.canCommit();
        }
    }

    protected void initialiseChildComponents() {
    }

    @Override
    protected void initialisePanel() {
        this.initialiseChildWrappers();
    }

    private boolean usesComponentWrappers() {
        boolean retval = false;
        for (Class<?> clz = this.getClass(); clz != null && !ChildObjectEditorPanel.class.equals(clz); clz = clz.getSuperclass()) {
            try {
                Method m = clz.getDeclaredMethod("initialiseChildComponents", new Class[0]);
                retval = true;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return retval;
    }

    protected final void setChildOnParent(C val) {
        String propPath = this.getPropertyPath();
        if (propPath == null) {
            throw new IllegalStateException("setChildOnParent only valid if getPropertyPath() returns a path.");
        }
        DBObject parent = this.getComponentFactoryUpdatedObject();
        if (parent != null) {
            try {
                this.getPropertyHelper().setPropertyValueOrFail((Object)parent, propPath, val);
            }
            catch (MissingPropertyException e) {
                DBLog.getLogger((Object)this).log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    protected String getPropertyPath() {
        return this.m_extraPropPath;
    }

    @Override
    protected boolean shouldValidateOnExit() {
        boolean shouldValidate = false;
        C child = this.getChildObject();
        if (child != null && child.getParent() != null) {
            shouldValidate = super.shouldValidateOnExit();
        }
        return shouldValidate;
    }

    @Override
    protected void refreshComponents() {
        String path = this.getComponentFactory().getBasePath();
        for (ComponentWrapper wrapper : this.getComponentFactory().getComponentWrappers()) {
            wrapper.getComponentContext().setBasePath(path);
        }
        super.refreshComponents();
    }

    @Override
    protected void initialiseWrappedPanel(ComponentContext cc) {
        super.initialiseWrappedPanel(cc);
        this.getComponentFactory().setBasePath(cc.getBasePath());
        this.m_extraPropPath = cc.getPropertyName();
    }
}

