/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.mview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.property.PropertyHelper;

public class MViewRefreshOptionsPanel
extends BaseEditorPanel<MaterializedView> {
    private final PropertyEnablingHandler m_peh = new PropertyEnablingHandler();

    public MViewRefreshOptionsPanel() {
        this.m_peh.register("firstRefresh", null);
        this.m_peh.register("interval", null);
        this.m_peh.register("refreshMethod", null);
        this.m_peh.register("keyType", null);
        this.m_peh.register("rollbackSegmentType", null);
        this.m_peh.register("rollbackSegmentName", null);
        this.m_peh.register("usingConstraints", MaterializedView.UsingConstraints.ENFORCED);
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper cwWhen = this.getOrCreateWrapper("refreshMode");
        layout.add(cwWhen);
        layout.nextRow();
        ComponentWrapper cwStartOn = this.getOrCreateWrapper("firstRefresh");
        layout.add(cwStartOn.getLabel());
        layout.indent(cwStartOn.getLabel());
        layout.add(cwStartOn.getComponent(), 1, 1, true, false);
        layout.nextRow();
        ComponentWrapper cwNext = this.getOrCreateWrapper("interval");
        layout.add(cwNext.getLabel());
        layout.indent(cwNext.getLabel());
        layout.add(cwNext.getComponent(), 1, 1, true, false);
        layout.nextRow();
        ComponentWrapper cwMethod = this.getOrCreateWrapper("refreshMethod");
        layout.add(cwMethod);
        layout.nextRow();
        ComponentWrapper cwType = this.getOrCreateWrapper("keyType");
        layout.add(cwType);
        layout.nextRow();
        ComponentWrapper cwRollback = this.getOrCreateWrapper("rollbackSegmentType");
        layout.add(cwRollback);
        layout.nextRow();
        ComponentWrapper cwRollbackName = this.getOrCreateWrapper("rollbackSegmentName");
        layout.add(cwRollbackName.getLabel());
        layout.add((Component)cwRollbackName.getActiveComponent(), 1, 1, true, false);
        layout.indent(cwRollbackName.getLabel());
        layout.nextRow();
        ComponentWrapper cwUsing = this.getOrCreateWrapper("usingConstraints");
        layout.add(cwUsing);
        layout.nextRowWithGap();
        if (this.getProvider() instanceof Database && this.isEditing()) {
            ComponentWrapper cwLastRefreshDate = this.getOrCreateWrapper("lastRefreshDate");
            ComponentWrapper cwNextRefreshDate = this.getOrCreateWrapper("nextRefreshDate");
            ComponentWrapper cwStaleness = this.getOrCreateWrapper("staleness");
            DBUILayoutHelper child = layout.newTitledHelper(UIBundle.get("MVIEW_REFRESH_STATE_TITLE"), 2, 1, true, false);
            child.add(cwLastRefreshDate);
            child.nextRow();
            child.add(cwNextRefreshDate);
            child.nextRow();
            child.add(cwStaleness);
            cwLastRefreshDate.setReadOnly(true);
            cwNextRefreshDate.setReadOnly(true);
            cwStaleness.setReadOnly(true);
        } else {
            Object cwLastRefreshDate = null;
            Object cwNextRefreshDate = null;
            Object cwStaleness = null;
        }
        layout.pushUp();
        layout.layout();
    }

    @Override
    protected void initialisePanel() {
        this.enableComponents(false);
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"refreshMode", "rollbackSegmentType"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                if (pce.getOldValue() != pce.getNewValue()) {
                    MViewRefreshOptionsPanel.this.enableComponents(true);
                }
            }
        };
    }

    private void enableComponents(boolean update) {
        MaterializedView mv = (MaterializedView)this.getUpdatedObject();
        MaterializedView.RefreshMode mode = mv.getRefreshMode();
        this.enable(mode != MaterializedView.RefreshMode.NEVER, update, "refreshMethod", "keyType", "rollbackSegmentType", "usingConstraints");
        this.enable(mode == MaterializedView.RefreshMode.SPECIFY, update, "firstRefresh", "interval");
        MaterializedView.RollbackSegmentType rsType = mv.getRollbackSegmentType();
        this.enable(mode != MaterializedView.RefreshMode.NEVER && rsType != null, update, "rollbackSegmentName");
    }

    private void enable(boolean enable, boolean update, String ... props) {
        for (String prop : props) {
            this.m_peh.setPropertyEnabled(prop, enable, update);
        }
    }

    private final class PropertyEnablingHandler {
        private final List<String> m_props = new ArrayList<String>();
        private final List<Object> m_default = new ArrayList<Object>();
        private final List<Object> m_cached = new ArrayList<Object>();

        private PropertyEnablingHandler() {
        }

        public void register(String property, Object defaultValue) {
            if (this.m_props.contains(property)) {
                throw new IllegalArgumentException("Property " + property + " already registered.");
            }
            this.m_props.add(property);
            this.m_default.add(defaultValue);
            this.m_cached.add(defaultValue);
        }

        public void setPropertyEnabled(String prop, boolean enable, boolean update) {
            if (!this.m_props.contains(prop)) {
                throw new IllegalArgumentException("Property " + prop + " not registered.");
            }
            ComponentWrapper cw = MViewRefreshOptionsPanel.this.getComponentFactory().findComponentWrapper(prop);
            if (cw != null && ((Component)cw.getActiveComponent()).isEnabled() != enable) {
                cw.setEnabled(enable);
                if (update) {
                    PropertyHelper helper = MViewRefreshOptionsPanel.this.getPropertyHelper();
                    DBObject obj = MViewRefreshOptionsPanel.this.getUpdatedObject();
                    if (enable) {
                        Object value = this.m_cached.get(this.m_props.indexOf(prop));
                        helper.setPropertyValue((Object)obj, prop, value);
                        cw.setPropertyValue(value);
                    } else {
                        Object value = helper.getPropertyValue((Object)obj, prop);
                        int index = this.m_props.indexOf(prop);
                        this.m_cached.set(index, value);
                        helper.setPropertyValue((Object)obj, prop, this.m_default.get(index));
                        cw.setPropertyValue(this.m_default.get(index));
                    }
                }
            }
        }
    }
}

