/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.partition.GlobalIndexPartitionPanel;
import oracle.ideimpl.db.panels.partition.LocalIndexPartitionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

public class IndexPartitionPanel
extends ChildObjectEditorPanel<OracleIndexPartitions, Index> {
    private final GlobalIndexPartitionPanel m_globalPanel;
    private final LocalIndexPartitionPanel m_localPanel;
    private final JPanel m_emptyPanel;
    private final JPanel m_container;
    private final JCheckBox m_definePartitions = new JCheckBox();
    private final Component m_glue = Box.createHorizontalGlue();
    private String m_currPanel = "Empty";
    private static final String GLOBAL_PANEL = "Global";
    private static final String LOCAL_PANEL = "Local";
    private static final String EMPTY_PANEL = "Empty";
    private TraversableContext m_context;

    public IndexPartitionPanel() {
        super("IndexPartitionPanel", null, true);
        this.m_globalPanel = new GlobalIndexPartitionPanel();
        this.m_localPanel = new LocalIndexPartitionPanel();
        this.m_emptyPanel = new JPanel();
        this.m_container = new JPanel(new CardLayout());
        this.m_container.add((Component)this.m_emptyPanel, EMPTY_PANEL);
        this.m_container.add((Component)((Object)this.m_globalPanel), GLOBAL_PANEL);
        this.m_container.add((Component)((Object)this.m_localPanel), LOCAL_PANEL);
    }

    @Override
    public void initialiseChildComponents() {
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        ComponentWrapper cwType = this.getOrCreateWrapper("partitionType");
        layout.add(cwType.getLabel(), 1, 1, false, false);
        layout.add(cwType.getComponent(), 1, 1, false, false);
        layout.nextRow();
        layout.add(this.m_definePartitions, 2, 1);
        layout.nextRow();
        this.getComponentFactory().getResourceHelper().resButton(this.m_definePartitions, UIBundle.get("PART_DEFINE_LOCAL_PARTITIONS"), "CheckDefinePartitions");
        layout.add(this.m_container, 4, 1, true, true);
        layout.add(this.m_glue, 1, 1, true, false);
        layout.layout();
        cwType.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IndexPartitionPanel.this.switchPanels();
            }
        });
    }

    private void switchPanels() {
        OracleIndexPartitions oip = (OracleIndexPartitions)this.getChildObject();
        Index index = (Index)this.getUpdatedObject();
        CardLayout cl = (CardLayout)this.m_container.getLayout();
        OracleTablePartitions otp = null;
        if (index != null) {
            otp = (OracleTablePartitions)index.getParent().getProperty("OracleTablePartitions");
        }
        OracleIndexPartitions.PartitionType type = null;
        if (oip != null) {
            type = oip.getPartitionType();
        }
        if (type == null) {
            this.m_definePartitions.setVisible(false);
            this.m_glue.setVisible(true);
            cl.show(this.m_container, EMPTY_PANEL);
            this.m_currPanel = EMPTY_PANEL;
        } else {
            switch (type) {
                case GLOBAL_RANGE: 
                case GLOBAL_HASH: {
                    this.m_definePartitions.setVisible(false);
                    cl.show(this.m_container, GLOBAL_PANEL);
                    this.m_currPanel = GLOBAL_PANEL;
                    if (this.m_context != null) {
                        this.m_globalPanel.onEntry(this.m_context);
                    }
                    this.m_glue.setVisible(false);
                    break;
                }
                case LOCAL_COMP: 
                case LOCAL_HASH: 
                case LOCAL_OTHER: {
                    this.m_definePartitions.setVisible(false);
                    if (oip != null) {
                        cl.show(this.m_container, LOCAL_PANEL);
                        this.m_currPanel = LOCAL_PANEL;
                        if (this.m_context != null) {
                            this.m_localPanel.onEntry(this.m_context);
                            this.m_localPanel.setDefinePartitionsCheckbox(this.m_definePartitions);
                        }
                        this.m_glue.setVisible(false);
                        break;
                    }
                    this.m_glue.setVisible(true);
                    cl.show(this.m_container, EMPTY_PANEL);
                    this.m_currPanel = EMPTY_PANEL;
                }
            }
        }
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.m_context = new TraversableContext(this.getDataContext().getParent(), 0);
        this.switchPanels();
    }

    @Override
    public void commitPanel() throws TraversalException {
        super.commitPanel();
        if (!this.m_currPanel.equals(EMPTY_PANEL)) {
            if (this.m_currPanel.equals(LOCAL_PANEL)) {
                this.m_localPanel.onExit(this.m_context);
            } else {
                this.m_globalPanel.onExit(this.m_context);
            }
        }
    }
}

