/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

class PartitionRenderer
extends DBObjectRenderer {
    PartitionRenderer() {
        super(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel retval = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DBObject obj = (DBObject)((DefaultMutableTreeNode)value).getUserObject();
        boolean disable = false;
        if (obj instanceof TablePartition) {
            TablePartition tp = (TablePartition)obj;
            retval.setText(this.getText(tp));
            if (tp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE && tp.getParent() == null || tp.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                disable = true;
            }
        } else if (obj instanceof IndexPartition) {
            OracleIndexPartitions oip;
            IndexPartition ip = (IndexPartition)obj;
            DBObject partParent = ip.getParent();
            if (partParent == null) {
                disable = true;
            } else if (partParent instanceof OracleIndexPartitions && (oip = (OracleIndexPartitions)partParent).getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION && partParent.getParent().getParent() == null) {
                disable = true;
            }
            retval.setText(ip.getName());
        }
        if (disable) {
            retval.setForeground(UIManager.getColor("Button.disabled"));
            retval.setEnabled(false);
        }
        retval.setIcon(null);
        return retval;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel retval = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        TablePartition child = (TablePartition)value;
        retval.setText(this.getText(child));
        return retval;
    }

    private String getText(TablePartition tp) {
        StringBuilder sb = new StringBuilder(tp.getName());
        Object[] values = tp.getValues();
        String sep = ", ";
        if (values != null && values.length > 0) {
            sb.append(" (");
            for (Object thisValue : values) {
                sb.append(thisValue);
                sb.append(", ");
            }
            sb.delete(sb.length() - ", ".length(), sb.length());
            sb.append(")");
        }
        return sb.toString();
    }
}

