/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.AbstractPartitionTreeEditorPanel;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.panels.partition.PartitionRenderer;
import oracle.ideimpl.db.panels.partition.PartitionTreeDetailsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.ReferencePartitionHelper;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ButtonMenu;
import oracle.javatools.util.ModelUtil;

class PartitionTreeEditorPanel
extends AbstractPartitionTreeEditorPanel<TablePartition, Table> {
    private AbstractButton m_addButton;
    private Table m_parentTable;
    private Collection<TablePartition> m_parentPartitions;
    private ActionListener m_defPartitionsListener;
    private DBObjectListener m_parentTableListener;
    private DBObjectListener m_otpListener;
    private static final String[] PROPERTIES = new String[]{PartitionProperty.PARTITIONS, PartitionProperty.SUBPARTITIONS_FOR_PARTITION};

    PartitionTreeEditorPanel() {
        super("PartitionTreeEditorPanel");
    }

    public String getName() {
        return UIBundle.get("PARTITIONS_SUBTAB_DEF");
    }

    @Override
    public void setDefinePartitionsCheckbox(JCheckBox chkDefinePartitions) {
        OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        if (otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            int parentPartitionsCount = ReferencePartitionHelper.getReferencedTablePartitionsCount((OracleTablePartitions)otp);
            boolean canDefine = !(this.getProvider() instanceof Database) || this.getOriginalObject() == null;
            chkDefinePartitions.setVisible(canDefine);
            chkDefinePartitions.setEnabled(this.m_parentTable == null || parentPartitionsCount > 0);
            chkDefinePartitions.setSelected(otp.getPartitions().length > 0);
            this.addActionListenerToDefineCheckbox(chkDefinePartitions);
        }
        super.setDefinePartitionsCheckbox(chkDefinePartitions);
    }

    @Override
    protected void populateComponent() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
        root.setUserObject(this.getUpdatedObject());
        OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        TablePartition[] partitions = otp.getPartitions();
        if (otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE) {
            if (otp.getPartitions().length == 0) {
                partitions = this.getReferencePartitions(this.getReferencedTable(otp), true);
            } else {
                this.setReferencedTable(ReferencePartitionHelper.getReferencedTable((OracleTablePartitions)otp));
            }
        }
        if (partitions != null) {
            for (TablePartition partition : partitions) {
                this.addPartitionNode(partition);
            }
        }
    }

    private TablePartition[] getReferencePartitions(Table refTable, boolean refresh) {
        if (refresh || this.m_parentPartitions == null || this.m_parentPartitions.isEmpty()) {
            this.m_parentPartitions = ReferencePartitionHelper.getReferenceTablePartitions((Table)refTable, (boolean)true);
        }
        return this.m_parentPartitions.toArray(new TablePartition[this.m_parentPartitions.size()]);
    }

    private Table getReferencedTable(OracleTablePartitions otp) {
        if (this.m_parentTable == null) {
            this.setReferencedTable(ReferencePartitionHelper.getReferencedTable((OracleTablePartitions)otp));
        }
        return this.m_parentTable;
    }

    private void addObjectListenerToParentTable() {
        if (this.m_parentTable != null) {
            this.m_parentTable.removeObjectListener(this.m_parentTableListener);
            this.m_parentTable.addObjectListener(this.m_parentTableListener);
        }
    }

    private void addObjectListenerToOtp() {
        OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        if (otp != null) {
            otp.removeObjectListener(this.m_otpListener);
            otp.addObjectListener(this.m_otpListener);
        }
    }

    private void addActionListenerToDefineCheckbox(JCheckBox defChk) {
        if (defChk != null) {
            defChk.removeActionListener(this.m_defPartitionsListener);
            defChk.addActionListener(this.m_defPartitionsListener);
        }
    }

    private void setReferencedTable(Table refTable) {
        if (this.m_parentTable != null) {
            this.m_parentTable.removeObjectListener(this.m_parentTableListener);
        }
        this.m_parentTable = refTable;
        if (this.m_parentTable != null) {
            this.m_parentTable.addObjectListener(this.m_parentTableListener);
        }
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        final OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        this.m_otpListener = new SwingDBObjectPropertyListener(new String[]{"referenceConstraintID", "partitionType"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                Object newVal = pce.getNewValue();
                if ("referenceConstraintID".equals(propertyName) || "partitionType".equals(propertyName) && newVal != OracleTablePartitions.PartitionType.REFERENCE) {
                    PartitionTreeEditorPanel.this.m_parentPartitions = Collections.emptyList();
                    PartitionTreeEditorPanel.this.setReferencedTable(null);
                    otp.setPartitions(null);
                }
            }
        };
        this.m_parentTableListener = new SwingDBObjectPropertyListener(new String[]{PartitionProperty.PARTITIONS, PartitionProperty.PARTITION_TYPE, PartitionProperty.HASH_QUANTITY, PartitionProperty.SUBPARTITIONS_FOR_PARTITION, PartitionProperty.SUBPARTITIONS_FOR_TABLE, Property.createPath((String[])new String[]{PartitionProperty.PARTITIONS, "name"}), Property.createPath((String[])new String[]{PartitionProperty.SUBPARTITIONS_FOR_PARTITION, "name"}), Property.createPath((String[])new String[]{PartitionProperty.SUBPARTITIONS_FOR_TABLE, "name"}), "OracleTablePartitions"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                JCheckBox chkDefinePartitions = PartitionTreeEditorPanel.this.getDefinePartitionsCheckbox();
                if (propertyName.equals(PartitionProperty.PARTITIONS) || propertyName.equals(PartitionProperty.SUBPARTITIONING_FOR_TABLE) || propertyName.equals(PartitionProperty.SUBPARTITIONS_FOR_TABLE)) {
                    TablePartition[] oldParts = (TablePartition[])pce.getOldValue();
                    TablePartition[] newParts = (TablePartition[])pce.getNewValue();
                    if ((oldParts == null || oldParts.length == 0) && newParts.length > 0) {
                        PartitionTreeEditorPanel.this.initialisePanel();
                    }
                    if (!chkDefinePartitions.isSelected()) {
                        PartitionTreeEditorPanel.this.refreshReferencePartitionsTree(false);
                    }
                    chkDefinePartitions.setEnabled(newParts != null && newParts.length != 0);
                } else if (propertyName.equals(PartitionProperty.HASH_QUANTITY)) {
                    Integer oldQuant = (Integer)pce.getOldValue();
                    Integer newQuant = (Integer)pce.getNewValue();
                    if ((oldQuant == null || oldQuant == 0) && newQuant > 0) {
                        PartitionTreeEditorPanel.this.initialisePanel();
                    }
                    if (!chkDefinePartitions.isSelected()) {
                        PartitionTreeEditorPanel.this.refreshReferencePartitionsTree(false);
                    }
                    chkDefinePartitions.setEnabled(newQuant != null && newQuant != 0);
                } else if (propertyName.equals(PartitionProperty.PARTITION_TYPE)) {
                    OracleTablePartitions.PartitionType oldType = (OracleTablePartitions.PartitionType)pce.getOldValue();
                    OracleTablePartitions.PartitionType newType = (OracleTablePartitions.PartitionType)pce.getNewValue();
                    if (newType == null || oldType != newType) {
                        chkDefinePartitions.setSelected(false);
                        PartitionTreeEditorPanel.this.refreshReferencePartitionsTree(false);
                    }
                } else if (!chkDefinePartitions.isSelected()) {
                    chkDefinePartitions.setSelected(false);
                    PartitionTreeEditorPanel.this.refreshReferencePartitionsTree(false);
                }
            }
        };
        this.m_defPartitionsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox check = (JCheckBox)e.getSource();
                PartitionTreeEditorPanel.this.refreshReferencePartitionsTree(check.isSelected());
            }
        };
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.addObjectListenerToParentTable();
        this.addObjectListenerToOtp();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        this.getDefinePartitionsCheckbox().removeActionListener(this.m_defPartitionsListener);
        otp.removeObjectListener(this.m_otpListener);
        this.setReferencedTable(null);
    }

    @Override
    protected ListButtons createListButtons() {
        ListButtons lb = new ListButtons(this.getSelectableComponent(), this.createButtonsHelper());
        final AbstractAction newPartitionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionTreeEditorPanel.this.newMainPartitionNode();
            }
        };
        JMenuItem siblingItem = new JMenuItem(newPartitionAction);
        siblingItem.setText(UIBundle.get("PARTITION_ADD_PARTITION"));
        final AbstractAction newSubpartitionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionTreeEditorPanel.this.newSubpartitionNode();
            }
        };
        JMenuItem childItem = new JMenuItem(newSubpartitionAction);
        childItem.setText(UIBundle.get("PARTITION_ADD_SUBPARTITION"));
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        items.add(siblingItem);
        items.add(childItem);
        this.m_addButton = ButtonMenu.createButtonMenu((String)"", (Icon)OracleIcons.getIcon((String)"add.png"), items);
        this.m_addButton.setName("AddButtonMenu");
        lb.setAddButton(this.m_addButton);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SelectableComponent sc = PartitionTreeEditorPanel.this.getSelectableComponent();
                int sel = sc.getSelectedIndex();
                if (sel == -1) {
                    newPartitionAction.setEnabled(true);
                    newSubpartitionAction.setEnabled(false);
                } else {
                    DBObject parent = (DBObject)sc.getParent(sc.get(sel));
                    TablePartition tp = parent instanceof Table ? (TablePartition)sc.get(sel) : (TablePartition)parent;
                    OracleTablePartitions otp = (OracleTablePartitions)((Table)PartitionTreeEditorPanel.this.getUpdatedObject()).getProperty("OracleTablePartitions");
                    boolean canCreatePartitions = false;
                    if (otp.getPartitionType() != OracleTablePartitions.PartitionType.REFERENCE) {
                        canCreatePartitions = true;
                    } else if (!(PartitionTreeEditorPanel.this.getProvider() instanceof Database) && otp.getPartitions().length > 0) {
                        canCreatePartitions = true;
                    }
                    boolean canCreateSubPartitions = false;
                    OracleTablePartitions subsOtp = tp.getPartitionLevelSubpartitions();
                    if (subsOtp != null && subsOtp.getPartitions() != null && subsOtp.getPartitions().length > 0) {
                        canCreateSubPartitions = true;
                    } else {
                        OracleTablePartitions main = (OracleTablePartitions)tp.getParent();
                        OracleTablePartitions subs = main.getSubpartitionModel();
                        if (subs != null && !ModelUtil.hasNonNullElement((Object[])subs.getPartitions())) {
                            canCreateSubPartitions = true;
                        }
                    }
                    newPartitionAction.setEnabled(canCreatePartitions);
                    newSubpartitionAction.setEnabled(canCreateSubPartitions);
                }
            }
        });
        return lb;
    }

    @Override
    protected ListButtons.Controller createButtonsHelper() {
        ChildSelectableComponentEditorPanel.DefaultButtonsHelper controller = new ChildSelectableComponentEditorPanel.DefaultButtonsHelper(){

            @Override
            public final boolean canRemove(Object val) {
                if (val instanceof TablePartition) {
                    TablePartition tp = (TablePartition)val;
                    return tp.getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE && this.canAdd();
                }
                return false;
            }

            @Override
            public boolean canAdd() {
                boolean canAdd = false;
                OracleTablePartitions otp = (OracleTablePartitions)((Table)PartitionTreeEditorPanel.this.getUpdatedObject()).getProperty("OracleTablePartitions");
                if (otp.getPartitionType() != OracleTablePartitions.PartitionType.REFERENCE) {
                    canAdd = true;
                } else if (!(PartitionTreeEditorPanel.this.getProvider() instanceof Database) && (otp.getPartitions().length > 0 || PartitionTreeEditorPanel.this.m_parentTable == null && PartitionTreeEditorPanel.this.getDefinePartitionsCheckbox().isSelected())) {
                    canAdd = true;
                }
                return canAdd;
            }

            @Override
            public boolean canReorder() {
                boolean canReorder = false;
                OracleTablePartitions otp = (OracleTablePartitions)((Table)PartitionTreeEditorPanel.this.getUpdatedObject()).getProperty("OracleTablePartitions");
                if (otp.getPartitionType() != OracleTablePartitions.PartitionType.REFERENCE) {
                    canReorder = true;
                } else if (!(PartitionTreeEditorPanel.this.getProvider() instanceof Database) && PartitionTreeEditorPanel.this.m_parentTable == null && PartitionTreeEditorPanel.this.getDefinePartitionsCheckbox().isSelected()) {
                    canReorder = true;
                }
                return canReorder;
            }
        };
        return controller;
    }

    @Override
    protected final String getChildProperty() {
        int level = this.getLevel();
        return level == -1 ? null : PROPERTIES[level];
    }

    @Override
    protected ChildObjectEditorPanel<TablePartition, Table> createChildPanel() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePartition[] subs = (TablePartition[])PartitionTreeEditorPanel.this.getPropertyHelper().getPropertyValue((Object)PartitionTreeEditorPanel.this.getUpdatedObject(), PartitionProperty.SUBPARTITIONS_FOR_TABLE);
                JTree tree = PartitionTreeEditorPanel.this.getTree();
                if (subs != null) {
                    TablePartition tp = (TablePartition)PartitionTreeEditorPanel.this.getCurrentChild();
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)PartitionTreeEditorPanel.this.getTreeModel().getRoot();
                    DefaultMutableTreeNode parent = TreeNodeMaker.findNode(tp, root);
                    JCheckBox check = (JCheckBox)e.getSource();
                    if (!check.isSelected()) {
                        Object[] children;
                        SelectableComponent sc = PartitionTreeEditorPanel.this.getSelectableComponent();
                        for (Object child : children = sc.getChildren(tp)) {
                            DefaultMutableTreeNode removeMe = TreeNodeMaker.findNode(child, parent);
                            PartitionTreeEditorPanel.this.getTreeModel().removeNodeFromParent(removeMe);
                        }
                        OracleTablePartitions tpSubs = tp.getPartitionLevelSubpartitions();
                        if (tpSubs != null) {
                            tpSubs.setHashQuantity(null);
                            tpSubs.setHashQuantityTablespaceIds(null);
                        }
                        PartitionTreeEditorPanel.this.addSubpartitionNodes(parent, null);
                        PartitionTreeEditorPanel.this.getTreeModel().nodeStructureChanged(parent);
                        tree.expandPath(tree.getSelectionPath());
                        PartitionTreeEditorPanel.this.selectChild((ChildDBObject)tp);
                        PartitionTreeEditorPanel.this.commitChildPropertyImpl(false);
                    } else {
                        for (TablePartition sub : subs) {
                            tree.expandPath(tree.getSelectionPath());
                            TablePartition newSub = (TablePartition)sub.copyTo(null);
                            newSub.setName(tp.getName() + "_" + sub.getName());
                            newSub.setObjectType(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                            newSub.setParent(null);
                            DefaultMutableTreeNode node = TreeNodeMaker.findNode(sub, parent);
                            node.setUserObject(newSub);
                            PartitionTreeEditorPanel.this.getTreeModel().nodeChanged(node);
                        }
                        PartitionTreeEditorPanel.this.commitChildPropertyImpl(false);
                        Integer quantity = (Integer)PartitionTreeEditorPanel.this.getPropertyHelper().getPropertyValue((Object)PartitionTreeEditorPanel.this.getUpdatedObject(), PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY);
                        if (quantity != null) {
                            OracleTablePartitions tpSubs = tp.getPartitionLevelSubpartitions();
                            if (tpSubs == null) {
                                tpSubs = new OracleTablePartitions(OracleTablePartitions.PartitionType.HASH, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                                tp.setPartitionLevelSubpartitions(tpSubs);
                            }
                            DBObjectID[] ids = (DBObjectID[])PartitionTreeEditorPanel.this.getPropertyHelper().getPropertyValue((Object)PartitionTreeEditorPanel.this.getUpdatedObject(), PartitionProperty.SUBPARTITION_TEMPLATE_HASH_TABLESPACES);
                            tpSubs.setHashQuantity(quantity);
                            tpSubs.setHashQuantityTablespaceIds(ids);
                        }
                    }
                    PartitionTreeDetailsPanel panel = (PartitionTreeDetailsPanel)PartitionTreeEditorPanel.this.getChildPanel();
                    panel.initialisePanel();
                }
            }
        };
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DefaultMutableTreeNode current = TreeNodeMaker.findNode(PartitionTreeEditorPanel.this.getCurrentChild(), (DefaultMutableTreeNode)PartitionTreeEditorPanel.this.getTreeModel().getRoot());
                PartitionTreeEditorPanel.this.getTreeModel().nodeChanged(current);
            }
        };
        return new PartitionTreeDetailsPanel(al, pcl);
    }

    @Override
    protected Class<TablePartition> getChildClass() {
        return TablePartition.class;
    }

    @Override
    protected String getListLabel() {
        return UIBundle.get("PARTITIONS_LIST_TITLE");
    }

    protected TablePartition[] getChildren() {
        return this.getPartitions((DBObject)this.getUpdatedObject());
    }

    @Override
    protected DBObjectRenderer createItemRenderer() {
        return new PartitionRenderer();
    }

    @Override
    protected void commitChildPropertyImpl(boolean parentOfSelection) {
        SelectableComponent sc = this.getSelectableComponent();
        int sel = sc.getSelectedIndex();
        DBObject selectedObject = (DBObject)sc.get(sel);
        Object parent = sel < 0 ? this.getUpdatedObject() : (parentOfSelection ? (DBObject)sc.getParent(selectedObject) : selectedObject);
        OracleTablePartitions partitioning = null;
        if (parent instanceof TablePartition) {
            TablePartition tp = (TablePartition)parent;
            partitioning = tp.getPartitionLevelSubpartitions();
            if (partitioning == null) {
                Table table = OraclePartitionsHandler.getOwningTable((DBObject)tp);
                OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
                partitioning = new OracleTablePartitions(otp.getSubpartitionModel().getPartitionType(), OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                tp.setPartitionLevelSubpartitions(partitioning);
            }
            partitioning.setPartitions(this.getChildrenImpl(parentOfSelection));
        } else if (parent instanceof Table) {
            partitioning = (OracleTablePartitions)parent.getProperty("OracleTablePartitions");
            TablePartition[] partitions = this.getChildrenImpl(parentOfSelection);
            partitioning.setPartitions(partitions);
            for (TablePartition tp : partitions) {
                OracleTablePartitions subPartitioning = tp.getPartitionLevelSubpartitions();
                if (subPartitioning == null) continue;
                TablePartition[] subPartitions = this.getPartitions((DBObject)tp);
                subPartitioning.setPartitions(subPartitions);
                if (subPartitions.length != 0) continue;
                tp.setPartitionLevelSubpartitions(null);
            }
        } else {
            DBLog.logIllegalState((String)"Unrecognized type in partition tree control");
        }
    }

    private TablePartition[] getChildrenImpl(boolean parentOfSelection) {
        SelectableComponent sc = this.getSelectableComponent();
        int sel = sc.getSelectedIndex();
        DBObject selectedObject = (DBObject)sc.get(sel);
        Object parent = sel < 0 ? this.getUpdatedObject() : (parentOfSelection ? (DBObject)sc.getParent(selectedObject) : selectedObject);
        return this.getPartitions((DBObject)parent);
    }

    private TablePartition[] getPartitions(DBObject parent) {
        SelectableComponent sc = this.getSelectableComponent();
        Object[] children = sc.getChildren(parent);
        int len = children == null ? 0 : children.length;
        TablePartition[] partitions = new TablePartition[]{};
        if (len > 0 && children[0] instanceof TablePartition && ((TablePartition)children[0]).getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            partitions = new TablePartition[len];
            System.arraycopy(children, 0, partitions, 0, len);
        }
        return partitions;
    }

    private DefaultMutableTreeNode newMainPartitionNode() {
        DefaultMutableTreeNode node = null;
        if (this.exitChildPanel()) {
            Table parent = (Table)this.getUpdatedObject();
            OracleTablePartitions otp = (OracleTablePartitions)parent.getProperty("OracleTablePartitions");
            TablePartition tp = (TablePartition)this.newChild();
            if (this.getLevel() == 1) {
                TablePartition[] partitions = otp.getPartitions();
                tp.setName(DBUtil.getUniqueName(this.getPartitionNames(partitions), (String)this.getNewChildBaseName()));
            }
            tp.setParent((DBObject)otp);
            tp.setPartitionType(otp.getPartitionType());
            tp.setObjectType(OracleTablePartitions.ObjectType.PARTITION);
            node = this.addPartitionNode(tp);
            this.selectChild(tp);
            this.commitChildProperty();
            JTextComponent txt = this.getNameField();
            if (txt != null) {
                txt.requestFocusInWindow();
            }
        }
        return node;
    }

    private void newSubpartitionNode() {
        if (this.exitChildPanel()) {
            TablePartition tp = (TablePartition)this.newChild();
            SelectableComponent tree = this.getSelectableComponent();
            OracleTablePartitions subs = (OracleTablePartitions)this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITIONING_FOR_TABLE);
            tp.setPartitionType(subs.getPartitionType());
            tp.setObjectType(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
            tp.setParent(null);
            int level = this.getLevel();
            Collection<String> names = this.getPartitionNames(this.getChildrenImpl(level == 1));
            SelectableComponent sc = this.getSelectableComponent();
            int sel = sc.getSelectedIndex();
            TablePartition selectedPartition = (TablePartition)sc.get(sel);
            TablePartition parent = level == 0 ? selectedPartition : (TablePartition)sc.getParent(selectedPartition);
            StringBuilder builder = new StringBuilder(parent.getName());
            builder.append("_");
            builder.append("SUBPARTITION1");
            tp.setName(DBUtil.getUniqueName(names, (String)builder.toString()));
            if (level == 0) {
                tree.add(sel + 1, tp, SelectableComponent.Placement.Child);
            } else if (level == 1) {
                tree.add(sel + 1, tp, SelectableComponent.Placement.Sibling);
            }
            this.selectChild(tp);
            this.commitChildProperty();
            JTextComponent txt = this.getNameField();
            if (txt != null) {
                txt.requestFocusInWindow();
            }
        }
    }

    private Collection<String> getPartitionNames(TablePartition[] partitions) {
        ArrayList<String> names = new ArrayList<String>();
        for (TablePartition partition : partitions) {
            names.add(partition.getName());
        }
        return names;
    }

    private DefaultMutableTreeNode addPartitionNode(TablePartition partition) {
        DefaultTreeModel model = this.getTreeModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(partition);
        root.insert(parent, root.getChildCount());
        TablePartition[] subpartitions = (TablePartition[])this.getPropertyHelper().getPropertyValue((Object)partition, PartitionProperty.SUBPARTITIONS);
        this.addSubpartitionNodes(parent, subpartitions);
        int row = model.getIndexOfChild(root, parent);
        this.getTree().expandRow(row);
        model.nodesWereInserted(root, new int[]{row});
        return parent;
    }

    private void addSubpartitionNodes(DefaultMutableTreeNode parent, TablePartition[] subpartitions) {
        OracleTablePartitions subs;
        TablePartition tp = (TablePartition)parent.getUserObject();
        if (!(subpartitions != null && subpartitions.length != 0 || (subs = tp.getPartitionLevelSubpartitions()) != null && subs.getPartitionType() == OracleTablePartitions.PartitionType.HASH && subs.getHashQuantity() != null)) {
            subpartitions = (TablePartition[])this.getPropertyHelper().getPropertyValue(this.getUpdatedObject(), PartitionProperty.SUBPARTITIONS_FOR_TABLE);
        }
        if (subpartitions != null) {
            for (TablePartition subpartition : subpartitions) {
                parent.insert(new DefaultMutableTreeNode(subpartition), parent.getChildCount());
            }
        }
    }

    private void refreshReferencePartitionsTree(boolean define) {
        TablePartition[] partitions;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getTreeModel().getRoot();
        OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        int selIndx = this.getSelectableComponent().getSelectedIndex();
        if (define) {
            for (TablePartition partition : partitions = this.getReferencePartitions(this.getReferencedTable(otp), false)) {
                TablePartition newPartition = new TablePartition(partition.getName(), OracleTablePartitions.PartitionType.REFERENCE, OracleTablePartitions.ObjectType.PARTITION);
                otp.addPartition(newPartition);
                DefaultMutableTreeNode node = TreeNodeMaker.findNode(partition, root);
                node.setUserObject(newPartition);
                this.getTreeModel().nodeStructureChanged(node);
            }
            if (selIndx > -1) {
                this.selectChild(otp.getPartitions()[selIndx]);
                this.listSelectionChanged();
                this.getListButtons().enableButtons();
            }
        } else {
            root.removeAllChildren();
            this.getTreeModel().nodeStructureChanged(root);
            for (TablePartition partition : partitions = this.getReferencePartitions(this.getReferencedTable(otp), true)) {
                this.addPartitionNode(partition);
            }
            otp.setPartitions(null);
            if (partitions.length > 0 && selIndx > -1) {
                this.selectChild(partitions[selIndx]);
                this.listSelectionChanged();
            }
        }
        if (this.m_parentTable == null) {
            this.m_addButton.setEnabled(define);
        }
        PartitionTreeDetailsPanel panel = (PartitionTreeDetailsPanel)this.getChildPanel();
        panel.initialisePanel();
    }
}

