/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.CardLayout;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.Type;

public class OracleColumnPropertiesPanel
extends ChildObjectEditorPanel<OracleColumnProperties, Relation> {
    private static final String NONE = "NONE";
    private final CardLayout m_layout = new CardLayout();

    public OracleColumnPropertiesPanel() {
        super("OracleColumnPropertiesPanel", null, true);
    }

    @Override
    public void initialiseChildComponents() {
        this.setLayout(this.m_layout);
        JPanel none = new JPanel();
        this.add(none, NONE);
        if (this.isInFlatEditor()) {
            DBUILayoutHelper.makeTransparentForFlatEditor((JComponent)((Object)this));
        }
    }

    @Override
    public void initialisePanel() {
        super.initialisePanel();
        this.handleVisibility();
    }

    private void handleVisibility() {
        Column parentColumn = (Column)this.getComponentFactoryUpdatedObject();
        String key = null;
        boolean xml = OracleColumnPropertiesPanel.isXMLTypeColumn(parentColumn);
        key = this.changeKey(key, "XMLTypeColumnProperties", xml);
        boolean nested = OracleColumnPropertiesPanel.isNestedTableColumn(parentColumn);
        key = this.changeKey(key, "nestedTableProperties", nested);
        boolean lob = OracleColumnPropertiesPanel.isLobColumn(parentColumn);
        key = this.changeKey(key, "LOBProperties", lob);
        boolean varray = OracleColumnPropertiesPanel.isVarrayColumn(parentColumn);
        if ((key = this.changeKey(key, "VAProperties", varray)) == null) {
            key = NONE;
        }
        this.m_layout.show((Container)((Object)this), key);
    }

    private String changeKey(String key, String newProp, boolean change) {
        if (change) {
            if (key != null) {
                DBLog.getLogger((Object)this).severe(newProp + " but already have " + key);
            } else {
                key = newProp;
                if (this.getComponentFactory().findComponentWrapper(key) == null) {
                    this.createPanel(key);
                }
            }
        }
        return key;
    }

    private void createPanel(String property) {
        JPanel panel = new JPanel();
        this.add(panel, property);
        DBUILayoutHelper layout = new DBUILayoutHelper(panel, this.isInFlatEditor());
        layout.setMargins(0);
        layout.add(this.getOrCreateWrapper(property).getComponent());
        layout.layout();
    }

    private static boolean isLobColumn(Column column) {
        return LOBDescriptor.isLOBColumn((Column)column);
    }

    public static boolean isVarrayColumn(Column column) {
        return LOBDescriptor.isVARRAYColumn((Column)column);
    }

    public static boolean isXMLTypeColumn(Column column) {
        boolean isXml = false;
        if (column != null) {
            DataTypeUsage dtu = column.getDataTypeUsage();
            DataType datatype = null;
            Type typ = null;
            try {
                datatype = DataTypeHelper.getDataType((DataTypeUsage)dtu, (boolean)false);
            }
            catch (DBException e) {
                DBLog.getLogger(OracleColumnPropertiesPanel.class).warning(e.getMessage());
            }
            if (datatype instanceof Type && XMLTypeColumnProperties.isXMLType((DataType)(typ = (Type)datatype))) {
                isXml = true;
            }
        }
        return isXml;
    }

    public static boolean isNestedTableColumn(Column column) {
        boolean isNested = false;
        if (column != null) {
            PlSqlSearch tableTypeSearch;
            DataTypeUsage dtu = column.getDataTypeUsage();
            DataType datatype = null;
            Type typ = null;
            try {
                datatype = DataTypeHelper.getDataType((DataTypeUsage)dtu, (boolean)false);
            }
            catch (DBException e) {
                DBLog.getLogger(OracleColumnPropertiesPanel.class).warning(e.getMessage());
            }
            if (datatype instanceof Type && (tableTypeSearch = new PlSqlSearch("[create [ or replace] ] type ?. [oid ?] {is|as} table of")).matches((typ = (Type)datatype).getSource())) {
                isNested = true;
            }
        }
        return isNested;
    }

    public static boolean showColumnProperties(Column column) {
        boolean retval = false;
        if (column != null) {
            retval = OracleColumnPropertiesPanel.isLobColumn(column) || OracleColumnPropertiesPanel.isVarrayColumn(column) || OracleColumnPropertiesPanel.isXMLTypeColumn(column) || OracleColumnPropertiesPanel.isNestedTableColumn(column);
        }
        return retval;
    }
}

