/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNExternalsStore {
    private SVNHashMap newExternals;
    private SVNHashMap oldExternals;
    private SVNHashMap depths;

    public void addOldExternal(File path, String oldValue) {
        if (this.oldExternals == null) {
            this.oldExternals = new SVNHashMap();
        }
        this.oldExternals.put(path, oldValue);
    }

    public void addNewExternal(File path, String newValue) {
        if (this.newExternals == null) {
            this.newExternals = new SVNHashMap();
        }
        this.newExternals.put(path, newValue);
    }

    public void addExternal(File path, String oldValue, String newValue) {
        this.addNewExternal(path, newValue);
        this.addOldExternal(path, oldValue);
    }

    public void addDepth(File localAbsPath, SVNDepth depth) {
        if (this.depths == null) {
            this.depths = new SVNHashMap();
        }
        this.depths.put(localAbsPath, depth);
    }

    public void removeDepth(String path) {
        if (this.depths != null) {
            this.depths.remove(path);
        }
    }

    public void removeExternal(String path) {
        if (this.newExternals != null) {
            this.newExternals.remove(path);
        }
        if (this.oldExternals != null) {
            this.oldExternals.remove(path);
        }
    }

    public Map<File, String> getNewExternals() {
        return this.newExternals == null ? Collections.EMPTY_MAP : this.newExternals;
    }

    public Map<File, String> getOldExternals() {
        return this.oldExternals == null ? Collections.EMPTY_MAP : this.oldExternals;
    }

    public Map<File, SVNDepth> getDepths() {
        return this.depths == null ? Collections.EMPTY_MAP : this.depths;
    }
}

