/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.express.idl.util.XMLWriter;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataXMLFormat;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.version.Version;

public abstract class MetadataToXMLConverterSince10105
extends MetadataToXMLConverter {
    private HashMap m_AboutToSendMap = new HashMap(40);
    private ArrayList m_AboutToSendList = new ArrayList();
    static final Integer NOT_MODIFIED = new Integer(0);
    static final Integer CHILDREN_MODIFIED = new Integer(1);
    private MetadataXMLFormat m_XMLFormat = null;
    private HashSet m_ModifiedTreeNodes = new HashSet(40);

    protected MetadataToXMLConverterSince10105(DataProvider dataProvider) {
        this(dataProvider, dataProvider.getServerVersion());
    }

    protected MetadataToXMLConverterSince10105(DataProvider dataProvider, Version version) {
        this.initializeXMLFormat(dataProvider, version);
    }

    public final void generateXML(XMLWriter xMLWriter) {
        this.setWriter(xMLWriter);
        this.generateXMLHeader();
        if (!this.getXMLFormat().is10gMode()) {
            this.generateNestedObjectXML();
        } else {
            this.generate10gXML();
        }
        this.setWriter(null);
    }

    protected void generateXMLHeader() {
    }

    private void generate10gXML() {
        boolean bl = true;
        for (BaseMetadataObject baseMetadataObject : this.getAboutToSendList()) {
            Object object = this.getAboutToSendState(baseMetadataObject);
            if (object == NOT_MODIFIED || object == CHILDREN_MODIFIED) continue;
            if (bl) {
                this.beginElement(BaseMetadataXMLTags.METADATA_TAG);
                this.closeTag();
                bl = false;
            } else {
                this.newLine();
            }
            baseMetadataObject.appendXMLString(this, null);
        }
        if (!bl) {
            this.endElement(BaseMetadataXMLTags.METADATA_TAG);
        }
    }

    private void generateNestedObjectXML() {
        Object object;
        ArrayList<BaseMetadataObject> arrayList = new ArrayList<BaseMetadataObject>();
        ArrayList<BaseMetadataObject> arrayList2 = new ArrayList<BaseMetadataObject>();
        for (BaseMetadataObject baseMetadataObject : this.getAboutToSendList()) {
            object = this.getAboutToSendState(baseMetadataObject);
            if (object == NOT_MODIFIED || object == CHILDREN_MODIFIED) continue;
            this.m_ModifiedTreeNodes.add(baseMetadataObject);
            BaseMetadataObject baseMetadataObject2 = baseMetadataObject.getContainedByObject();
            while (null != baseMetadataObject2) {
                if (this.isModifiedObject(baseMetadataObject2) || this.m_ModifiedTreeNodes.contains(baseMetadataObject2)) {
                    baseMetadataObject = null;
                    break;
                }
                this.m_ModifiedTreeNodes.add(baseMetadataObject2);
                baseMetadataObject = baseMetadataObject2;
                baseMetadataObject2 = baseMetadataObject.getContainedByObject();
            }
            if (baseMetadataObject == null) continue;
            if (baseMetadataObject instanceof MdmDatabaseSchema) {
                arrayList2.add(baseMetadataObject);
                continue;
            }
            arrayList.add(baseMetadataObject);
        }
        arrayList.addAll(arrayList2);
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (BaseMetadataObject)arrayList.get(i);
            if (bl) {
                this.beginElement(BaseMetadataXMLTags.METADATA_TAG);
                this.appendAttribute(BaseMetadataXMLTags.METADATA_VERSION, this.getXMLFormat().getVersion());
                if (this.isMetadataXMLVersionSameOrLaterThan("1.0")) {
                    this.appendAttribute(BaseMetadataXMLTags.METADATA_DB_VERSION, this.getXMLFormat().getDatabaseVersion());
                }
                this.closeTag();
                bl = false;
            } else {
                this.newLine();
            }
            ((BaseMetadataObject)object).appendXMLString(this, null);
        }
        if (!bl) {
            this.endElement(BaseMetadataXMLTags.METADATA_TAG);
        }
    }

    public void resetState() {
        super.resetState();
        this.m_AboutToSendMap.clear();
        this.getAboutToSendList().clear();
        this.m_ModifiedTreeNodes.clear();
    }

    public void rollbackState() {
        this.m_AboutToSendMap.clear();
        this.getAboutToSendList().clear();
    }

    public MetadataXMLFormat getXMLFormat() {
        return this.m_XMLFormat;
    }

    private void setXMLFormat(MetadataXMLFormat metadataXMLFormat) {
        this.m_XMLFormat = metadataXMLFormat;
    }

    private void initializeXMLFormat(DataProvider dataProvider, Version version) {
        MetadataXMLFormat metadataXMLFormat = null;
        metadataXMLFormat = dataProvider.read11gMetadata() ? new MetadataXMLFormat(2, version.getMetadataXMLVersion()) : new MetadataXMLFormat(0, "0.1");
        this.setXMLFormat(metadataXMLFormat);
    }

    public String getXMLVersion() {
        return this.getXMLFormat().getVersion();
    }

    final boolean isModifiedObject(BaseMetadataObject baseMetadataObject) {
        Object object = this.getAboutToSendState(baseMetadataObject);
        return object != NOT_MODIFIED && object != CHILDREN_MODIFIED && object != null;
    }

    final boolean isObjectInModifiedTree(BaseMetadataObject baseMetadataObject) {
        return this.m_ModifiedTreeNodes.contains(baseMetadataObject);
    }

    final void addAboutToSendState(BaseMetadataObject baseMetadataObject, Object object) {
        if (!this.m_AboutToSendMap.containsKey(baseMetadataObject)) {
            this.m_AboutToSendList.add(baseMetadataObject);
        }
        this.m_AboutToSendMap.put(baseMetadataObject, object);
    }

    final Object getAboutToSendState(BaseMetadataObject baseMetadataObject) {
        return this.m_AboutToSendMap.get(baseMetadataObject);
    }

    final List getAboutToSendList() {
        return this.m_AboutToSendList;
    }
}

