/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.olapi.metadata.mdm.Mdm9iNamingConvention;
import oracle.olapi.metadata.mdm.MdmAWXMLNamingConvention;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.syntax.parser.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CubeUpgradeInfoSelector {
    private MdmAWXMLNamingConvention m_NamingConvention = null;
    private ArrayList<UpgradeInfoNode> m_Nodes = null;
    private static final String SQL_SELECT = "select awxml_id, new_name from cube_upgrade_info where owner = ?";
    private static CubeUpgradeInfoSelector m_Instance = null;

    public CubeUpgradeInfoSelector(MdmMetadataProvider mdmMetadataProvider) {
        this.m_NamingConvention = new MdmAWXMLNamingConvention(null, mdmMetadataProvider);
        this.m_Nodes = new ArrayList();
    }

    public static CubeUpgradeInfoSelector getInstance(MdmMetadataProvider mdmMetadataProvider) {
        if (null == m_Instance) {
            m_Instance = new CubeUpgradeInfoSelector(mdmMetadataProvider);
        }
        return m_Instance;
    }

    public String getNewName(String string, Identifier identifier) {
        return this.getNode(string).getNewName(identifier);
    }

    public String getOldName(String string, Identifier identifier) {
        return this.getNode(string).getOldName(identifier);
    }

    public String getOldName(MdmObject mdmObject) {
        if (mdmObject instanceof MdmSchema) {
            return null;
        }
        String string = Mdm9iNamingConvention.getOwnerName(this.getMdmMetadataProvider(), mdmObject);
        String string2 = this.getNamingConvention().generateID(mdmObject);
        if (null == string2) {
            return null;
        }
        return this.getOldName(string, Identifier.parseID(string2));
    }

    public String getOldCubeName(String string, String string2) {
        String string3 = this.getNamingConvention(string).generateCubeID(string2);
        if (null == string3) {
            return null;
        }
        return this.getOldName(string, Identifier.parseID(string3));
    }

    MdmAWXMLNamingConvention getNamingConvention() {
        return this.getNamingConvention(null);
    }

    MdmAWXMLNamingConvention getNamingConvention(String string) {
        if (null != string) {
            this.m_NamingConvention.setOwnerName(string);
        }
        return this.m_NamingConvention;
    }

    private MdmMetadataProvider getMdmMetadataProvider() {
        return this.getNamingConvention().getMdmMetadataProvider();
    }

    private List<UpgradeInfoNode> getNodes() {
        return this.m_Nodes;
    }

    private UpgradeInfoNode getNode(String string) {
        for (UpgradeInfoNode upgradeInfoNode : this.getNodes()) {
            if (!upgradeInfoNode.getOwnerName().equals(string)) continue;
            return upgradeInfoNode;
        }
        UpgradeInfoNode upgradeInfoNode = this.createNode(string);
        this.getNodes().add(upgradeInfoNode);
        return upgradeInfoNode;
    }

    private UpgradeInfoNode createNode(String string) {
        UpgradeInfoNode upgradeInfoNode = new UpgradeInfoNode(this, string);
        try {
            PreparedStatement preparedStatement = this.getMdmMetadataProvider().getDataProvider().getConnection().prepareStatement(SQL_SELECT);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                upgradeInfoNode.addNewName(Identifier.parseID(string2), string3);
            }
            resultSet.close();
            preparedStatement.close();
            upgradeInfoNode.populateNewID2OldNameHash();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return upgradeInfoNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UpgradeInfoNode {
        private HashMap<Identifier, String> m_OldAwxmlID2NewName = null;
        private HashMap<Identifier, String> m_NewAwxmlID2OldName = null;
        private String m_OwnerName = null;
        private CubeUpgradeInfoSelector m_Parent = null;

        UpgradeInfoNode(CubeUpgradeInfoSelector cubeUpgradeInfoSelector2, String string) {
            this.m_Parent = cubeUpgradeInfoSelector2;
            this.m_OwnerName = string;
        }

        String getOwnerName() {
            return this.m_OwnerName;
        }

        String getNewName(Identifier identifier) {
            return this.getOldID2NewNameHash().get(identifier);
        }

        String getOldName(Identifier identifier) {
            return this.getNewID2OldNameHash().get(identifier);
        }

        void addNewName(Identifier identifier, String string) {
            this.getOldID2NewNameHash().put(identifier, string);
        }

        void addOldName(Identifier identifier, String string) {
            this.getNewID2OldNameHash().put(identifier, string);
        }

        HashMap<Identifier, String> getOldID2NewNameHash() {
            if (null == this.m_OldAwxmlID2NewName) {
                this.m_OldAwxmlID2NewName = new HashMap();
            }
            return this.m_OldAwxmlID2NewName;
        }

        HashMap<Identifier, String> getNewID2OldNameHash() {
            if (null == this.m_NewAwxmlID2OldName) {
                this.m_NewAwxmlID2OldName = new HashMap();
            }
            return this.m_NewAwxmlID2OldName;
        }

        void populateNewID2OldNameHash() {
            for (Map.Entry<Identifier, String> entry : this.getOldID2NewNameHash().entrySet()) {
                Identifier identifier = entry.getKey();
                String string = entry.getValue();
                String string2 = identifier.getLastComponent();
                String string3 = null;
                boolean bl = true;
                int n = identifier.getNumComponents() - 2;
                if (n < 0) {
                    bl = false;
                } else {
                    string3 = identifier.getComponent(n);
                }
                Identifier identifier2 = new Identifier(identifier);
                identifier = new Identifier(identifier);
                while (null != string2 && bl) {
                    if (null == string) {
                        identifier.setName(string2);
                        string = this.getNewName(identifier);
                    }
                    if (null != string) {
                        n = identifier.getNumComponents() - 2;
                        if (n < 0) {
                            bl = false;
                            break;
                        }
                        identifier2.setComponent(n, string);
                        string = null;
                    }
                    string2 = this.getParent().getNamingConvention().getParentIDType(string2);
                    identifier.removeLastComponent();
                }
                if (!bl) continue;
                this.addOldName(identifier2, string3);
            }
        }

        private CubeUpgradeInfoSelector getParent() {
            return this.m_Parent;
        }
    }
}

