/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class HierarchicalCondition
extends Condition {
    public static final String PARENT = "PARENT";
    public static final String CHILD = "CHILD";
    public static final String ANCESTOR = "ANCESTOR";
    public static final String ROOT_ANCESTOR = "ROOT_ANCESTOR";
    public static final String DESCENDANT = "DESCENDANT";
    public static final String LEAF_DESCENDANT = "LEAF_DESCENDANT";
    public static final String RELATIVE = "RELATIVE";
    static final String[] ALL_RELATIONSHIPS = new String[]{"PARENT", "CHILD", "ANCESTOR", "ROOT_ANCESTOR", "DESCENDANT", "LEAF_DESCENDANT", "RELATIVE"};
    private TypedExpression m_BaseExpression;
    private TypedExpression m_ReferenceExpression;
    private MdmHierarchy m_Hierarchy;
    private String m_Relationship;
    private boolean m_Negated;
    private boolean m_IncludeSelf;

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getBaseExpression());
        syntaxPrintingContext.append(" IS ");
        if (this.isNegated()) {
            syntaxPrintingContext.append("NOT ");
        }
        syntaxPrintingContext.append(this.getRelationship());
        if (this.includeSelf()) {
            syntaxPrintingContext.append(" OR SELF");
        }
        syntaxPrintingContext.append(" OF ");
        syntaxPrintingContext.print(this.getReferenceExpression());
        syntaxPrintingContext.append(" WITHIN ");
        syntaxPrintingContext.appendIdentifier(this.getHierarchy().getInternalID());
    }

    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_BaseExpression = validationContext.validateExp(this.m_BaseExpression);
        this.m_ReferenceExpression = validationContext.validateExp(this.m_ReferenceExpression);
        validationContext.pop();
        return this;
    }

    protected boolean checkIfDefinitionIsComplete() {
        return this.getBaseExpression().isDefinitionComplete() && this.getReferenceExpression().isDefinitionComplete();
    }

    public HierarchicalCondition(TypedExpression typedExpression, String string, TypedExpression typedExpression2, MdmHierarchy mdmHierarchy, boolean bl, boolean bl2) {
        this.m_Relationship = HierarchicalCondition.validateEnum(string, ALL_RELATIONSHIPS);
        HierarchicalCondition.validateValue(typedExpression);
        HierarchicalCondition.validateValue(typedExpression2);
        HierarchicalCondition.validateValue(mdmHierarchy);
        this.m_BaseExpression = typedExpression;
        this.m_ReferenceExpression = typedExpression2;
        this.m_Hierarchy = mdmHierarchy;
        this.m_Negated = bl;
        this.m_IncludeSelf = bl2;
        this.initialize();
    }

    public HierarchicalCondition(TypedExpression typedExpression, String string, TypedExpression typedExpression2, MdmHierarchy mdmHierarchy, boolean bl) {
        this(typedExpression, string, typedExpression2, mdmHierarchy, bl, false);
    }

    public HierarchicalCondition(TypedExpression typedExpression, String string, TypedExpression typedExpression2, MdmHierarchy mdmHierarchy) {
        this(typedExpression, string, typedExpression2, mdmHierarchy, false, false);
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitHierarchicalCondition(this, object);
    }

    public TypedExpression getBaseExpression() {
        return this.m_BaseExpression;
    }

    public TypedExpression getReferenceExpression() {
        return this.m_ReferenceExpression;
    }

    public MdmHierarchy getHierarchy() {
        return this.m_Hierarchy;
    }

    public String getRelationship() {
        return this.m_Relationship;
    }

    public boolean isNegated() {
        return this.m_Negated;
    }

    public boolean includeSelf() {
        return this.m_IncludeSelf;
    }
}

