/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.SymmetricConditionElement;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymmetricCondition
extends SyntaxObject {
    private SymmetricConditionElement[] m_Elements;

    private SymmetricConditionElement[] getElementsInternal() {
        return this.m_Elements;
    }

    private SymmetricCondition(SymmetricConditionElement[] symmetricConditionElementArray, boolean bl) {
        SymmetricCondition.validateValues(symmetricConditionElementArray);
        for (int i = 0; i < symmetricConditionElementArray.length; ++i) {
            MdmPrimaryDimension mdmPrimaryDimension = symmetricConditionElementArray[i].getDimension();
            for (int j = i + 1; j < symmetricConditionElementArray.length; ++j) {
                if (symmetricConditionElementArray[j].getDimension() != mdmPrimaryDimension) continue;
                throw new SyntaxException("DuplicateDimension", mdmPrimaryDimension.getName());
            }
        }
        this.m_Elements = bl ? (SymmetricConditionElement[])symmetricConditionElementArray.clone() : symmetricConditionElementArray;
        this.initialize();
    }

    private SymmetricCondition(MdmPrimaryDimension[] mdmPrimaryDimensionArray, Condition[] conditionArray, boolean bl) {
        SymmetricCondition.validateValues(mdmPrimaryDimensionArray);
        SymmetricCondition.validateValues(conditionArray);
        if (mdmPrimaryDimensionArray.length != conditionArray.length) {
            throw new SyntaxException("ArraySizeMismatch");
        }
        this.m_Elements = new SymmetricConditionElement[mdmPrimaryDimensionArray.length];
        for (int i = 0; i < mdmPrimaryDimensionArray.length; ++i) {
            MdmPrimaryDimension mdmPrimaryDimension = mdmPrimaryDimensionArray[i];
            for (int j = i + 1; j < mdmPrimaryDimensionArray.length; ++j) {
                if (mdmPrimaryDimensionArray[j] != mdmPrimaryDimension) continue;
                throw new SyntaxException("DuplicateDimension", mdmPrimaryDimension.getName());
            }
            this.m_Elements[i] = new SymmetricConditionElement(mdmPrimaryDimension, conditionArray[i]);
        }
        this.initialize();
    }

    private static SymmetricConditionElement[] createSymmetricConditionElementArray(List<SymmetricConditionElement> list) {
        if (null == list) {
            return null;
        }
        SymmetricConditionElement[] symmetricConditionElementArray = new SymmetricConditionElement[list.size()];
        list.toArray(symmetricConditionElementArray);
        return symmetricConditionElementArray;
    }

    private static Condition[] createConditionArray(List<Condition> list) {
        if (null == list) {
            return null;
        }
        Condition[] conditionArray = new Condition[list.size()];
        list.toArray(conditionArray);
        return conditionArray;
    }

    private static MdmPrimaryDimension[] createMdmPrimaryDimensionArray(List<MdmPrimaryDimension> list) {
        if (null == list) {
            return null;
        }
        MdmPrimaryDimension[] mdmPrimaryDimensionArray = new MdmPrimaryDimension[list.size()];
        list.toArray(mdmPrimaryDimensionArray);
        return mdmPrimaryDimensionArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        validationContext.validateComponents(this, this.getElementsInternal());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getElementsInternal());
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        for (int i = 0; i < this.getElementsInternal().length; ++i) {
            if (0 != i) {
                syntaxPrintingContext.append(", ");
                syntaxPrintingContext.newLineAndIndent();
            }
            syntaxPrintingContext.print(this.getElementsInternal()[i]);
        }
    }

    public SymmetricCondition(MdmPrimaryDimension[] mdmPrimaryDimensionArray, Condition[] conditionArray) {
        this(mdmPrimaryDimensionArray, conditionArray, true);
    }

    public SymmetricCondition(List<MdmPrimaryDimension> list, List<Condition> list2) {
        this(SymmetricCondition.createMdmPrimaryDimensionArray(list), SymmetricCondition.createConditionArray(list2), false);
    }

    public SymmetricCondition(SymmetricConditionElement[] symmetricConditionElementArray) {
        this(symmetricConditionElementArray, true);
    }

    public SymmetricCondition(List<SymmetricConditionElement> list) {
        this(SymmetricCondition.createSymmetricConditionElementArray(list), false);
    }

    public MdmPrimaryDimension[] getDimensions() {
        MdmPrimaryDimension[] mdmPrimaryDimensionArray = new MdmPrimaryDimension[this.m_Elements.length];
        for (int i = 0; i < this.m_Elements.length; ++i) {
            mdmPrimaryDimensionArray[i] = this.m_Elements[i].getDimension();
        }
        return mdmPrimaryDimensionArray;
    }

    public Condition[] getConditions() {
        Condition[] conditionArray = new Condition[this.m_Elements.length];
        for (int i = 0; i < this.m_Elements.length; ++i) {
            conditionArray[i] = this.m_Elements[i].getCondition();
        }
        return conditionArray;
    }

    public SymmetricConditionElement[] getElements() {
        return (SymmetricConditionElement[])this.getElementsInternal().clone();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSymmetricCondition(this, object);
    }
}

