/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public abstract class AbstractDBObjectBuilder<T extends AbstractBuildableObject>
implements DBObjectBuilder<T> {
    static final Collection<String> s_specialProps = Arrays.asList("name", "ID", "parent", "properties", "schema", "type");
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator(DBObjectBuilder.class.getName());
    private final AbstractDBObjectProvider m_pro;
    private final String m_type;
    private Boolean m_supportsTimestamp;
    private Map<String, Method> m_propMap;
    private MultiMap<String, String> m_derivedProperties;
    private final Map<T, Boolean> m_cancelled = new IdentityHashMap<T, Boolean>();

    protected AbstractDBObjectBuilder(AbstractDBObjectProvider pro, String type) {
        this.m_type = type;
        this.m_pro = pro;
        if (this.m_pro == null) {
            this.m_supportsTimestamp = false;
        }
    }

    protected final String getObjectType() {
        return this.m_type;
    }

    protected final AbstractDBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    @Override
    public boolean canBuildEditableObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelCurrentBuild(T object) {
        boolean retval = false;
        Map<T, Boolean> map = this.m_cancelled;
        synchronized (map) {
            if (Boolean.FALSE.equals(this.m_cancelled.get(object))) {
                this.m_cancelled.put(object, Boolean.TRUE);
                retval = true;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCurrentBuildCancelled(T object) {
        Map<T, Boolean> map = this.m_cancelled;
        synchronized (map) {
            return Boolean.TRUE.equals(this.m_cancelled.get(object));
        }
    }

    protected void checkInterruptOrCancel(T object) throws CancelledException {
        if (Thread.currentThread().isInterrupted() || this.isCurrentBuildCancelled(object)) {
            throw new CancelledException();
        }
    }

    protected final Schema getSchema(String name) throws DBException {
        return this.m_pro.findSchema(name);
    }

    protected final SystemObject findObjectInProviderCache(String type, Schema schema, String name) {
        return this.m_pro == null ? null : this.m_pro.findObject(type, schema, name);
    }

    protected final SystemObject findObjectInProviderCache(DBObjectID id) {
        return this.m_pro == null ? null : this.m_pro.findObject(id);
    }

    protected final <D extends DBObject> D newObject(Class<? extends D> clz, String name) {
        return this.newObject(clz, null, name);
    }

    protected final <D extends DBObject> D newObject(Class<? extends D> clz, DBObject parent, String name) {
        DBObjectFactory fac = this.getProvider().getObjectFactory();
        return fac.newObject(clz, parent, name, false, false);
    }

    @Override
    public T createObject(String name, Schema schema, DBObjectID id) {
        String type = this.getObjectType();
        Class<? extends DBObject> clz = Metadata.getInstance().getObjectClass(type);
        AbstractBuildableObject retval = null;
        if (clz != null) {
            try {
                AbstractBuildableObject obj = (AbstractBuildableObject)this.newObject(clz, schema, name);
                obj.setID(id);
                retval = obj;
            }
            catch (Exception ex) {
                DBLog.getLogger(this).log(Level.SEVERE, "Error instantiating object", ex);
            }
        }
        return (T)retval;
    }

    protected Executor getPropertyExecutor(T object) {
        return null;
    }

    private void checkTimestamp(T obj) {
        if (!(this instanceof DerivedPropertyBuilder) && this.m_pro != null && this.m_pro.supportsTimestamps(obj.getType())) {
            AbstractBuildableObject exists = null;
            try {
                DBObjectID id = ((AbstractDBObject)obj).getID();
                exists = id == null ? (AbstractBuildableObject)DBUtil.getProviderDefinition(obj, (DBObjectProvider)this.m_pro) : (AbstractBuildableObject)id.resolveID();
            }
            catch (DBException dbe) {
                DBLog.getLogger(this).log(Level.WARNING, "Couldn't lookup existing object: " + dbe.getMessage());
            }
            if (exists == null) {
                DBLog.getLogger(this).log(Level.WARNING, "Building {0} {1} but it doesn't exist any more.", new String[]{obj.getType(), ((AbstractDBObject)obj).getName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String startBuild(T object) {
        String retval = null;
        Map<T, Boolean> map = this.m_cancelled;
        synchronized (map) {
            if (this.m_cancelled.get(object) == null) {
                retval = s_tsKeyGen.next();
                this.m_cancelled.put(object, Boolean.FALSE);
            }
        }
        if (retval != null) {
            DBUtil.suspendTimestampChecking(this.m_pro, retval);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishBuild(T object, String key) {
        Map<T, Boolean> map = this.m_cancelled;
        synchronized (map) {
            this.m_cancelled.remove(object);
        }
        DBUtil.resumeTimestampChecking(this.m_pro, key);
    }

    @Override
    public final void buildObject(T object) throws DBException {
        String tskey = this.startBuild(object);
        try {
            ((AbstractBuildableObject)object).getPropertySupport().setBuildingAll();
            this.checkTimestamp(object);
            this.fillInObject(object);
            ((AbstractBuildableObject)object).getPropertySupport().markAsBuilt();
            this.registerObject(object);
        }
        finally {
            if (tskey != null) {
                this.finishBuild(object, tskey);
            }
        }
    }

    protected void fillInObject(T object) throws DBException {
        if (this.canBuildComponents()) {
            for (String key : this.getPropertyMethodMap().keySet()) {
                this.ensureComponent(object, key);
            }
        }
        for (DBObject obj : ((AbstractDBObject)object).getOwnedObjects()) {
            if (!(obj instanceof AbstractBuildableObject)) continue;
            ((AbstractBuildableObject)obj).checkInit();
        }
    }

    protected void registerObject(T object) throws DBException {
        this.updateTimestamp(object);
        if (object instanceof SchemaObject) {
            CascadeManager m;
            CascadeManager cascadeManager = m = this.m_pro == null ? null : this.m_pro.getCascadeManager();
            if (m instanceof SchemaObjectManager) {
                ((SchemaObjectManager)m).registerObject((SystemObject)((SchemaObject)object), true);
            }
        }
    }

    @PropertyBuilder(value={"Timestamp"})
    public final void updateTimestamp(T object) throws DBException {
        this.updateTimestamp(object, false);
    }

    protected final void updateTimestamp(T object, boolean force) throws DBException {
        if (this.m_supportsTimestamp == null) {
            this.m_supportsTimestamp = this.m_pro.supportsTimestamps(this.getObjectType());
        }
        if (this.m_supportsTimestamp.booleanValue() && object instanceof SystemObject) {
            if (force) {
                this.m_pro.putCachedTimestampKey(((AbstractDBObject)object).getID(), null);
            }
            if (force || DBUtil.getFrozenProperties(object).get("Timestamp") == null) {
                ((AbstractDBObject)object).setProperty("Timestamp", this.m_pro.getExternalTimestamp((SystemObject)object));
            }
        }
    }

    protected final boolean needsBuilding(T obj, String key) {
        return this.needsBuilding(obj, key, false);
    }

    public final boolean needsBuilding(T obj, String key, boolean checkBuilder) {
        if (checkBuilder && !((AbstractBuildableObject)obj).needsInitialization()) {
            return false;
        }
        return !((AbstractBuildableObject)obj).isBuilt(key);
    }

    protected final void markAsBuilt(T obj) {
        ((AbstractBuildableObject)obj).getPropertySupport().markAsBuilt();
    }

    protected final void setBuilder(T obj) {
        ((AbstractBuildableObject)obj).getPropertySupport().setBuilder(this);
    }

    protected final void ensureComponent(T obj, String key) throws DBException {
        if (this.needsBuilding(obj, key)) {
            this.buildObjectComponent(obj, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void buildObjectComponent(T object, String prop) throws DBException {
        if (!this.isBuildableProperty(prop)) return;
        if (this.canBuildComponents()) {
            String tskey = this.startBuild(object);
            try {
                if (!this.fillInObjectComponent(object, prop)) return;
                this.registerObject(object);
                return;
            }
            finally {
                if (tskey != null) {
                    this.finishBuild(object, tskey);
                }
            }
        } else {
            this.buildObject(object);
        }
    }

    protected final boolean fillInObjectComponent(T object, String key) throws DBException {
        this.checkInterruptOrCancel(object);
        boolean retval = false;
        if (this.isBuildableProperty(key)) {
            if (!"Timestamp".equals(key)) {
                this.checkTimestamp(object);
            }
            String[] props = this.getBuiltProperties(key);
            try {
                ((AbstractBuildableObject)object).getPropertySupport().startBuilding(props);
                String[] depKeys = this.getPropertyDependencies(key);
                if (depKeys != null) {
                    for (String depKey : depKeys) {
                        this.ensureComponent(object, depKey);
                    }
                }
                retval = this.fillInObjectComponentImpl(object, key);
                this.markAsBuilt(object, props);
            }
            catch (DBException dbe) {
                if (dbe instanceof CancelledException || !this.isBuiltOnFailure(object, props, dbe)) {
                    ((AbstractBuildableObject)object).getPropertySupport().setUnbuilt(props);
                } else {
                    this.markAsBuilt(object, props);
                }
                throw dbe;
            }
            finally {
                ((AbstractBuildableObject)object).getPropertySupport().finishBuilding(props);
            }
        }
        return retval;
    }

    protected boolean isBuiltOnFailure(T object, String[] props, DBException dbe) {
        return true;
    }

    protected final void markAsBuilt(T object, String ... props) {
        ((AbstractBuildableObject)object).getPropertySupport().setBuilt(props);
    }

    protected boolean fillInObjectComponentImpl(T object, String prop) throws DBException {
        Method m = this.getPropertyMethodMap().get(prop);
        return this.invokeBuilderMethod(m, object, prop);
    }

    private boolean invokeBuilderMethod(Method m, T object, String key) throws DBException {
        boolean retval = true;
        try {
            Object got = m.invoke((Object)this, object);
            retval = !Boolean.FALSE.equals(got);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if (t instanceof DBException) {
                throw (DBException)t;
            }
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new CancelledException();
            }
            String msg = "Build of property " + key + " failed: " + t.getMessage();
            this.getLogger().log(DBLog.getExceptionLogLevel(), msg, t);
            throw new DBException((DBObject)object, msg, t);
        }
        return retval;
    }

    protected boolean canBuildComponents() {
        return false;
    }

    @Override
    public boolean isBuildableProperty(String key) {
        boolean retval;
        boolean bl = retval = !s_specialProps.contains(key);
        if (retval && this.canBuildComponents()) {
            retval = this.getPropertyMethodMap().containsKey(key);
        }
        return retval;
    }

    Collection<String> listBuildableProperties() {
        Collection<String> retval = this.canBuildComponents() ? Collections.unmodifiableCollection(this.getPropertyMethodMap().keySet()) : null;
        return retval;
    }

    private synchronized Map<String, Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<String, Method>();
            Class<?> c = this.getClass();
            ArrayList<Method> derived = new ArrayList<Method>();
            for (Method m : c.getMethods()) {
                PropertyBuilder v = m.getAnnotation(PropertyBuilder.class);
                if (v == null) continue;
                Class<?>[] params = m.getParameterTypes();
                if (params == null || params.length != 1 || !AbstractBuildableObject.class.isAssignableFrom(params[0])) {
                    this.logMethodError(m, "@PropertyBuilder methods must have a single AbstractBuildableObject parameter.");
                    continue;
                }
                if (v.derived()) {
                    derived.add(m);
                    continue;
                }
                for (String p : this.getBuiltProperties(v)) {
                    Method existing = this.m_propMap.get(p);
                    if (existing != null) {
                        Class<?> newParam;
                        if (ModelUtil.areDifferent((Object)existing.getName(), (Object)m.getName())) {
                            this.logMethodError(m, "Two different @PropertyBuilder methods cannot both build " + p);
                            continue;
                        }
                        Class<?> existingParam = existing.getParameterTypes()[0];
                        if (!existingParam.isAssignableFrom(newParam = params[0])) continue;
                        this.m_propMap.put(p, m);
                        continue;
                    }
                    this.m_propMap.put(p, m);
                }
            }
            for (Method m : derived) {
                PropertyBuilder v = m.getAnnotation(PropertyBuilder.class);
                for (String p : this.getBuiltProperties(v)) {
                    if (this.m_propMap.containsKey(p)) continue;
                    this.m_propMap.put(p, m);
                }
            }
        }
        return this.m_propMap;
    }

    private void logMethodError(Method m, String message) {
        this.getLogger().log(DBLog.getExceptionLogLevel(), m.getName(), new IllegalStateException(message));
    }

    protected String[] getBuiltProperties(String key) {
        HashSet<String> retval = new HashSet<String>();
        Map<String, Method> map = this.getPropertyMethodMap();
        Method m = map.get(key);
        if (m == null) {
            throw new IllegalStateException("Property " + key + " has no associated @PropertyBuilder.");
        }
        for (Map.Entry<String, Method> entry : map.entrySet()) {
            if (entry.getValue() != m) continue;
            retval.add(entry.getKey());
        }
        return retval.toArray(new String[retval.size()]);
    }

    private String[] getBuiltProperties(PropertyBuilder pb) {
        String[] retval;
        if (pb.derived()) {
            ArrayList<String> props = new ArrayList<String>();
            for (String prop : pb.value()) {
                Collection<String> derived = this.getDerivedProperties(prop);
                if (derived == null) continue;
                props.addAll(derived);
            }
            retval = props.toArray(new String[props.size()]);
        } else {
            retval = pb.value();
        }
        return retval;
    }

    String[] getPropertyDependencies(String property) {
        PropertyBuilder pb = this.getAnnotation(property);
        return pb == null ? null : pb.depends();
    }

    private PropertyBuilder getAnnotation(String key) {
        PropertyBuilder pb = null;
        Method m = this.getPropertyMethodMap().get(key);
        if (m != null) {
            pb = m.getAnnotation(PropertyBuilder.class);
        }
        return pb;
    }

    private synchronized Map<String, Collection<String>> getDerivedPropertyMap() {
        if (this.m_derivedProperties == null) {
            this.m_derivedProperties = new MultiMap();
            PropertyManager propMgr = this.getProvider().getPropertyManager();
            Class<? extends DBObject> objClz = Metadata.getInstance().getObjectClass(this.getObjectType());
            PropertyCriteria crit = new PropertyCriteria();
            crit.setInternal(null);
            crit.setDerived(true);
            for (PropertyInfo info : propMgr.getPropertyInfos(objClz, crit).values()) {
                this.m_derivedProperties.add((Object)info.getDerivedSourceProperty(), (Object)info.getPropertyName());
            }
        }
        return this.m_derivedProperties;
    }

    public Collection<String> getDerivedProperties(String property) {
        Collection<String> c = this.getDerivedPropertyMap().get(property);
        return c == null ? null : Collections.unmodifiableCollection(c);
    }

    protected String getDerivedPropertySource(String property) {
        String retval = null;
        for (Map.Entry<String, Collection<String>> entry : this.getDerivedPropertyMap().entrySet()) {
            if (!entry.getValue().contains(property)) continue;
            retval = entry.getKey();
            break;
        }
        return retval;
    }

    protected void replaceReferenceIDs(T object, Map<DBObjectID, DBObjectID> idMap) {
        ((AbstractDBObject)object).replaceReferenceIDsDirectly(idMap);
    }

    protected static Executor getPropertyExecutorForObject(AbstractBuildableObject object) {
        return object.getPropertyExecutor();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PropertyBuilder {
        public String[] value();

        public String[] depends() default {};

        public boolean derived() default false;
    }
}

