/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Map;
import java.util.logging.Logger;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBObjectID
implements DBObjectID {
    private DBObjectID m_parent;
    private String m_type;

    protected AbstractDBObjectID() {
    }

    protected AbstractDBObjectID(String type) {
        this.m_type = type;
    }

    protected AbstractDBObjectID(String type, DBObjectID parent) {
        this.m_type = type;
        this.m_parent = parent;
    }

    @Override
    public final String getType() {
        return this.m_type;
    }

    public final void setType(String type) {
        if (!ModelUtil.hasLength((String)type) || "null".equals(type)) {
            type = null;
        }
        if (ModelUtil.hasLength((String)this.m_type) && ModelUtil.areDifferent((Object)this.m_type, (Object)"UNSPECIFIED_TYPE") && ModelUtil.areDifferent((Object)this.m_type, (Object)type)) {
            throw new IllegalStateException("cannot change the type of a DBObjectID");
        }
        this.m_type = type;
    }

    @Override
    public final DBObjectID getParent() {
        return this.m_parent;
    }

    public void setParent(DBObjectID parent) {
        if (parent == this) {
            throw new IllegalArgumentException("A DBObjectID cannot parent itself");
        }
        this.m_parent = parent;
    }

    protected final DBObject resolveFromParent() throws DBException {
        DBObject parent;
        if (this.m_parent != null && (parent = this.m_parent.resolveID()) != null) {
            return this.resolveInParentObject(parent);
        }
        return null;
    }

    public DBObject resolveInParentObject(DBObject parent) throws DBException {
        return parent.findOwnedObject(this);
    }

    public final boolean equals(Object obj) {
        return obj instanceof DBObjectID && this.equals((DBObjectID)obj, true);
    }

    @Override
    public final boolean equals(DBObjectID id, boolean strict) {
        boolean retval = false;
        if (id != null) {
            retval = id instanceof TemporaryObjectID || id instanceof ReferenceID && !(this instanceof ReferenceID) ? id.equals(this, strict) : this.equalsImpl(id, strict) && this.hasSameParent(id, strict);
        }
        return retval;
    }

    protected boolean hasSameParent(DBObjectID other, boolean strict) {
        boolean retval;
        DBObjectID otherPar = other.getParent();
        if (this.m_parent == otherPar) {
            retval = true;
        } else if (this.m_parent == null || otherPar == null) {
            DBObjectID idWithPar = this.m_parent == null ? other : this;
            DBObjectID idWithoutPar = this.m_parent == null ? this : other;
            DBObjectID idPar = idWithPar.getParent();
            if (idWithoutPar instanceof BaseObjectID && idPar instanceof BaseObjectID && "UNSPECIFIED_TYPE".equals(idPar.getType())) {
                String schemaName1 = ((BaseObjectID)idPar).getName();
                String schemaName2 = ((BaseObjectID)idWithoutPar).getSchemaName();
                retval = schemaName1 != null && schemaName1.equals(schemaName2);
            } else {
                retval = idWithPar instanceof AbstractDBObjectID && ((AbstractDBObjectID)idWithPar).canEquateWithNullParent(idWithoutPar);
            }
        } else {
            retval = this.m_parent.equals(otherPar, strict);
        }
        return retval;
    }

    protected boolean canEquateWithNullParent(DBObjectID other) {
        return other instanceof IdentifierBasedID && Metadata.getInstance().isTypeOf(SystemObject.class, this.m_type) && ModelUtil.areEqual((Object)this.m_type, (Object)other.getType());
    }

    protected abstract boolean equalsImpl(DBObjectID var1, boolean var2);

    protected boolean equalsImpl(AbstractDBObjectID target) {
        return ModelUtil.areEqual((Object)this.m_type, (Object)target.m_type) || ModelUtil.areEqual((Object)"UNSPECIFIED_TYPE", (Object)target.m_type) || ModelUtil.areEqual((Object)this.m_type, (Object)"UNSPECIFIED_TYPE");
    }

    protected void copyToImpl(AbstractDBObjectID target) {
        target.m_type = this.m_type;
        target.m_parent = this.m_parent == null ? null : (DBObjectID)this.m_parent.copyTo(null);
    }

    public final int hashCode() {
        AbstractDBObjectID id = this;
        if (id.getType() == null) {
            id = (AbstractDBObjectID)id.copyTo(null);
            id.setType("UNSPECIFIED_TYPE");
        }
        return id.toString().hashCode();
    }

    public abstract String toString();

    public static <T extends AbstractDBObjectID> T copyWithNewType(T id, Map<String, String> typeMap) {
        AbstractDBObjectID retval;
        for (DBObjectID check = retval = (AbstractDBObjectID)id.copyTo(null); check != null; check = check.getParent()) {
            if (check instanceof AbstractDBObjectID) {
                String newType = typeMap.get(check.m_type);
                if (newType == null) continue;
                check.m_type = newType;
                continue;
            }
            retval = null;
            break;
        }
        return (T)retval;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }
}

