/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.References;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;

public abstract class ColumnConstraint
extends Constraint {
    ColumnConstraint() {
    }

    ColumnConstraint(String name, Relation relation) {
        super(name, relation);
    }

    @Internal
    public Column[] getColumns() throws IllegalStateException {
        ArrayList<Column> retval = new ArrayList<Column>();
        DBObjectID[] colIDs = this.getColumnIDs();
        if (colIDs.length > 0) {
            Relation parent = this.getRelation();
            if (parent == null) {
                throw new IllegalStateException(APIBundle.get("CONSTRAINT_ERROR_ORPHANED_CONSTRAINT"));
            }
            for (int i = 0; i < colIDs.length; ++i) {
                if (colIDs[i] == null) {
                    throw new IllegalStateException(APIBundle.format("CONSTRAINT_ERROR_MISSING_COLUMN_INDEX", i));
                }
                Column col = (Column)parent.findOwnedObject(colIDs[i]);
                if (col == null) {
                    throw new IllegalStateException(APIBundle.format("CONSTRAINT_ERROR_MISSING_COLUMN", DBUtil.getDBObjectName(colIDs[i])));
                }
                retval.add(col);
            }
        }
        return retval.toArray(new Column[retval.size()]);
    }

    public void setColumns(Column[] columns) {
        this.getChildSupport("columnIDs").clearChildren();
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                this.addColumn(columns[i]);
            }
        }
    }

    private Column checkColumn(Column col, Relation relForColumn) {
        String colName;
        if (relForColumn == null) {
            throw new IllegalArgumentException("need a relation set to add columns to constraint " + this.getName());
        }
        if (col.getRelation() != relForColumn && (col = relForColumn.getColumn(colName = col.getName())) == null) {
            throw new IllegalArgumentException("cannot add column " + colName + " to constraint " + this.getName() + " - column doesn't exist on this relation");
        }
        return col;
    }

    public void addColumn(Column col) {
        if (col != null) {
            this.addColumnImpl(col, this.getRelation());
        }
    }

    protected void addColumnImpl(Column col, Relation relForColumn) {
        DBObjectID id = (col = this.checkColumn(col, relForColumn)).getID();
        if (id == null) {
            id = TemporaryObjectID.createID(col);
            col.setID(id);
        }
        this.getChildSupport("columnIDs").addChild(id);
    }

    public boolean removeColumn(Column col) {
        DBObjectID id;
        boolean retval = false;
        if (col != null && (id = col.getID()) != null) {
            retval = this.getChildSupport("columnIDs").removeChild(id);
        }
        return retval;
    }

    @References(value=Column.class, internal=true, cascade=CascadeAction.DELETE)
    public DBObjectID[] getColumnIDs() {
        return this.getChildSupport("columnIDs").getChildArray(DBObjectID.class);
    }

    public void setColumnIDs(DBObjectID[] ids) {
        this.getChildSupport("columnIDs").setChildArray(ids);
    }

    public static boolean isConstrained(Column col, String ... constraintTypes) {
        if (constraintTypes != null) {
            DBObjectID id = col.getID();
            Relation rel = col.getRelation();
            if (rel != null && id != null) {
                for (Constraint con : ColumnConstraint.getConstraints(rel, constraintTypes)) {
                    if (!(con instanceof ColumnConstraint)) continue;
                    for (DBObjectID conColID : ((ColumnConstraint)con).getColumnIDs()) {
                        if (!id.equals(conColID, true)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

