/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.util.ModelUtil;

public class DBLog {
    private static final String BASE_LOG_NAME = "oracle.javatools.db";
    private static final String SQL_LOG_NAME = "oracle.javatools.db.statement";
    private static final String LOG_PROPERTY = "db.log";
    private static final String DEBUG_PROPERTY = "db.debug";
    private static Map<String, Logger> s_loggers = new HashMap<String, Logger>();

    @Deprecated
    public static final Logger getLogger() {
        return DBLog.getAndInitialiseLogger(BASE_LOG_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Logger getLogger(Object caller) {
        String loggerName = null;
        if (caller == null) {
            loggerName = null;
        } else if (caller instanceof String) {
            loggerName = (String)caller;
        } else {
            Class<?> clz = DBUtil.decodeArrayClass(caller instanceof Class ? (Class<?>)caller : caller.getClass());
            loggerName = clz.getName();
        }
        if (loggerName == null || !loggerName.startsWith("oracle.") || !loggerName.contains("db") && !loggerName.contains("report")) {
            loggerName = BASE_LOG_NAME;
            new IllegalArgumentException("Invalid log requested: " + loggerName).printStackTrace();
        }
        loggerName = loggerName.replace("$", ".");
        Logger retval = Logger.getLogger(loggerName);
        Map<String, Logger> map = s_loggers;
        synchronized (map) {
            if (!s_loggers.containsKey(loggerName)) {
                DBLog.initLogger(retval);
                s_loggers.put(loggerName, retval);
            }
        }
        return retval;
    }

    @Deprecated
    public static final synchronized Logger getAndInitialiseLogger(String name) {
        return DBLog.getLogger(name);
    }

    @Deprecated
    public static final Level getTimingLogLevel() {
        return Level.FINER;
    }

    @Deprecated
    public static final Level getTraceLogLevel() {
        return Level.FINER;
    }

    @Deprecated
    public static final Level getEventLogLevel() {
        return Level.FINE;
    }

    public static boolean isDebug() {
        boolean retval = false;
        if (!$assertionsDisabled) {
            retval = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!retval) {
            retval = Boolean.getBoolean(LOG_PROPERTY) || Boolean.getBoolean(DEBUG_PROPERTY);
        }
        return retval;
    }

    public static final Level getExceptionLogLevel() {
        return DBLog.isDebug() ? Level.SEVERE : Level.WARNING;
    }

    public static void logIllegalState(String msg) {
        IllegalStateException ex = new IllegalStateException(msg);
        StackTraceElement[] stack = ex.getStackTrace();
        int depth = DBLog.getStackDepth(stack);
        if (depth > 0) {
            StackTraceElement[] newStack = new StackTraceElement[stack.length - depth];
            System.arraycopy(stack, depth, newStack, 0, newStack.length);
            ex.setStackTrace(newStack);
        }
        DBLog.logStackTrace(ex);
    }

    private static int getStackDepth(StackTraceElement[] stack) {
        int retval = -1;
        for (int i = 1; i < stack.length; ++i) {
            String className;
            StackTraceElement elem = stack[i];
            if (elem == null || (className = elem.getClassName()) == null || className.equals(DBLog.class.getName())) continue;
            retval = i;
            break;
        }
        return retval;
    }

    public static final void logStackTrace(Throwable t) {
        DBLog.logStackTrace(t.getMessage(), t);
    }

    public static final void logStackTrace(String msg, Throwable t) {
        StackTraceElement[] stack = new Exception().getStackTrace();
        int callDepth = DBLog.getStackDepth(stack);
        if (callDepth >= 0) {
            StackTraceElement elem = stack[callDepth];
            DBLog.getLogger(elem.getClassName()).logp(DBLog.getExceptionLogLevel(), elem.getClassName(), elem.getMethodName(), msg, t);
        } else {
            DBLog.getLogger(BASE_LOG_NAME).log(DBLog.getExceptionLogLevel(), msg, t);
        }
    }

    @Deprecated
    public static final void log(String msg, Object ... params) {
        DBLog.getLogger().log(DBLog.getTraceLogLevel(), msg, params);
    }

    @Deprecated
    public static final void logDifferences(DBObject obj1, DBObject obj2, DBObjectProvider pro) {
    }

    public static final Logger getSQLLog() {
        return DBLog.getLogger(SQL_LOG_NAME);
    }

    private static void initLogger(Logger logger) {
        block7: {
            try {
                String prop = System.getProperty(LOG_PROPERTY);
                if (!ModelUtil.hasLength((String)prop)) break block7;
                Level level = null;
                if (Boolean.valueOf(prop).booleanValue()) {
                    level = Level.ALL;
                } else {
                    try {
                        level = Level.parse(prop.toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (level != null) {
                    logger.setLevel(level);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

