/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public class DBObjectCriteria<T extends SystemObject>
implements DBObjectFilter<T> {
    public static final char LIKE_WILDCARD_CHAR = '%';
    public static final String LIKE_WILDCARD = String.valueOf('%');
    public static final char LIKE_SINGLE_CHAR_WILDCARD_CHAR = '_';
    public static final String LIKE_SINGLE_CHAR_WILDCARD = String.valueOf('_');
    private Collection<DBObjectFilter<T>> m_filters;
    private final Class<? extends T> m_clz;
    private DatabaseDescriptor m_databaseDescriptor;
    private String m_nameLike;
    private String m_name;
    private String m_schemaName;
    private String m_dbName;
    private final Collection<String> m_types = new HashSet<String>();
    private boolean m_userOnly;
    private boolean m_skipTimestamps;
    private boolean m_fullLoad;

    private DBObjectCriteria(Class<? extends T> clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Criteria class cannot be null");
        }
        this.m_clz = clz;
    }

    public DBObjectCriteria(T obj) throws NullPointerException {
        this(obj.getClass(), obj.getType());
        DBObjectID id;
        this.setName(obj.getName());
        if (obj instanceof SchemaObject) {
            this.setSchema(((SchemaObject)obj).getSchema());
        }
        if ((id = obj.getID()) instanceof BaseObjectID) {
            this.setDatabaseName(((BaseObjectID)id).getDatabaseName());
        }
    }

    public DBObjectCriteria(Class<? extends T> clz, String ... types) {
        this(clz);
        if (ModelUtil.hasNonNullElement((Object[])types)) {
            Collection<String> allowedTypes = Metadata.getInstance().getAllTypes(this.m_clz);
            for (String type : types) {
                if (type == null) continue;
                if (allowedTypes.contains(type)) {
                    this.m_types.add(type);
                    continue;
                }
                throw new IllegalArgumentException(type + " is not a valid type for class " + this.m_clz.getSimpleName());
            }
        } else if (!this.m_clz.equals(SystemObject.class)) {
            String type = Metadata.getType(this.m_clz);
            if (type == null) {
                this.m_types.addAll(Metadata.getInstance().getAllTypes(this.m_clz));
            } else {
                this.m_types.add(type);
            }
        }
    }

    final Class<? extends T> getObjectClass() {
        return this.m_clz;
    }

    public final String getNameLike() {
        String retval = ModelUtil.hasLength((String)this.m_nameLike) ? this.m_nameLike : (ModelUtil.hasLength((String)this.m_name) ? this.m_name : LIKE_WILDCARD);
        return retval;
    }

    public final void setNameLike(String nameLike) {
        this.m_nameLike = nameLike;
        this.m_name = null;
    }

    public final String getName() {
        Object retval = this.m_name == null ? (this.m_nameLike == null || this.m_nameLike.contains(LIKE_WILDCARD) ? null : this.m_nameLike) : this.m_name;
        return retval;
    }

    public final void setName(String name) {
        this.m_name = name;
        this.m_nameLike = null;
    }

    public final void setDatabaseDescriptor(DatabaseDescriptor desc) {
        this.m_databaseDescriptor = desc;
    }

    public final boolean isNameWild() {
        return this.m_name == null && (this.m_nameLike == null || DBObjectCriteria.containsWildcard(this.m_nameLike));
    }

    public final boolean isAllowedName(String name) {
        boolean retval = false;
        if (ModelUtil.hasLength((String)this.m_name)) {
            retval = this.areNamesEqual(this.m_name, name);
        } else if (ModelUtil.hasLength((String)this.m_nameLike)) {
            if (ModelUtil.hasLength((String)name)) {
                if (DBObjectCriteria.containsWildcard(this.m_nameLike)) {
                    StringBuilder buff = new StringBuilder();
                    int lastChar = 32;
                    for (int i = 0; i < this.m_nameLike.length(); ++i) {
                        boolean escaped;
                        char c = this.m_nameLike.charAt(i);
                        boolean bl = escaped = lastChar == 92;
                        if (c == '%' && !escaped) {
                            buff.append(".*");
                        } else if (c == '_' && !escaped) {
                            buff.append(".");
                        } else {
                            buff.append(Pattern.quote(String.valueOf(c)));
                        }
                        lastChar = c;
                    }
                    try {
                        int casePolicy;
                        int flags = 0;
                        if (this.m_databaseDescriptor != null && (casePolicy = this.m_databaseDescriptor.getCasePolicy()) == 0) {
                            flags = 66;
                        }
                        Pattern p = Pattern.compile(buff.toString(), flags);
                        Matcher m = p.matcher(name);
                        retval = m.matches();
                    }
                    catch (PatternSyntaxException pse) {
                        retval = false;
                    }
                } else {
                    retval = this.areNamesEqual(this.m_nameLike, name);
                }
            }
        } else {
            retval = true;
        }
        return retval;
    }

    private boolean areNamesEqual(String name1, String name2) {
        boolean retval = this.m_databaseDescriptor == null ? name1.equals(name2) : this.m_databaseDescriptor.areNamesEqual(name1, name2, null, false);
        return retval;
    }

    public final Collection<String> getTypes() {
        return Collections.unmodifiableCollection(this.m_types);
    }

    public final String[] getTypeArray() {
        return this.m_types.toArray(new String[this.m_types.size()]);
    }

    public final boolean isAllowedType(String type) {
        return this.getTypes().isEmpty() || this.getTypes().contains(type);
    }

    @Deprecated
    public final void setTypes(Collection<String> types) {
    }

    @Deprecated
    public final void setTypes(String ... types) {
    }

    public final String getSchemaName() {
        return this.m_schemaName;
    }

    public final void setSchemaName(String name) {
        this.m_schemaName = name;
    }

    public final void setSchema(Schema schema) {
        this.m_schemaName = schema != null ? schema.getName() : null;
    }

    public final boolean isAllowedSchema(Schema schema) {
        return this.isAllowedSchemaName(schema == null ? null : schema.getName());
    }

    public final boolean isAllowedSchemaName(String schemaName) {
        boolean retval = ModelUtil.hasLength((String)this.m_schemaName) ? this.areNamesEqual(schemaName, this.m_schemaName) : true;
        return retval;
    }

    public final String getDatabaseName() {
        return this.m_dbName;
    }

    public final void setDatabaseName(String dbName) {
        this.m_dbName = dbName;
    }

    public final boolean isUserOnly() {
        return this.m_userOnly;
    }

    public final void setUserOnly(boolean userOnly) {
        this.m_userOnly = userOnly;
    }

    public boolean accept(String type, Schema schema, String name) {
        return this.isAllowedType(type) && this.isAllowedSchema(schema) && this.isAllowedName(name);
    }

    @Override
    public boolean accept(T obj) {
        boolean retval = false;
        if (obj != null) {
            boolean bl = retval = this.isAllowedName(obj.getName()) && this.isAllowedType(obj.getType());
            if (retval && obj instanceof SchemaObject) {
                retval = this.isAllowedSchema(((SchemaObject)obj).getSchema());
            }
        }
        if (retval && this.m_filters != null) {
            for (DBObjectFilter<T> filter : this.m_filters) {
                retval = retval && filter.accept(obj);
            }
        }
        return retval;
    }

    public final void addFilter(DBObjectFilter<T> filter) {
        if (filter != null) {
            if (this.m_filters == null) {
                this.m_filters = new ArrayList<DBObjectFilter<T>>();
            }
            this.m_filters.add(filter);
        }
    }

    public final boolean hasExtraCriteria() {
        return this.m_filters != null;
    }

    void setSkipTimestampCheck(boolean skip) {
        this.m_skipTimestamps = skip;
    }

    boolean getSkipTimestampCheck() {
        return this.m_skipTimestamps;
    }

    public void setFullyLoadObjects(boolean fullLoad) {
        this.m_fullLoad = fullLoad;
    }

    public boolean isFullyLoadObjects() {
        return this.m_fullLoad;
    }

    public int hashCode() {
        return this.m_clz.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof DBObjectCriteria && this.equalsImpl((DBObjectCriteria)other);
    }

    private boolean equalsImpl(DBObjectCriteria other) {
        return ModelUtil.areEqual((Object)this.m_dbName, (Object)other.m_dbName) && ModelUtil.areEqual((Object)this.m_name, (Object)other.m_name) && ModelUtil.areEqual((Object)this.m_nameLike, (Object)other.m_nameLike) && ModelUtil.areEqual((Object)this.m_schemaName, (Object)other.m_schemaName) && ModelUtil.areEqual((Object)this.m_skipTimestamps, (Object)other.m_skipTimestamps) && ModelUtil.areEqual((Object)this.m_fullLoad, (Object)other.m_fullLoad) && ModelUtil.areEqual((Object)this.m_userOnly, (Object)other.m_userOnly) && this.contentsSame(this.m_types, other.m_types) && this.contentsSame(this.m_filters, other.m_filters);
    }

    private boolean contentsSame(Collection a, Collection b) {
        boolean retval = true;
        if (a != b) {
            if (a == null || a.isEmpty()) {
                retval = b == null || b.isEmpty();
            } else if (b == null || b.isEmpty()) {
                retval = false;
            } else {
                ArrayList remainder = new ArrayList(b);
                for (Object o : a) {
                    if (remainder.remove(o)) continue;
                    retval = false;
                    break;
                }
                retval = retval && remainder.isEmpty();
            }
        }
        return retval;
    }

    public DBObjectCriteria<T> clone() {
        DBObjectCriteria<Class<? extends T>> clone = new DBObjectCriteria<Class<? extends T>>(this.m_clz);
        clone.m_dbName = this.m_dbName;
        clone.m_name = this.m_name;
        clone.m_nameLike = this.m_nameLike;
        clone.m_schemaName = this.m_schemaName;
        clone.m_skipTimestamps = this.m_skipTimestamps;
        clone.m_fullLoad = this.m_fullLoad;
        clone.m_types.addAll(this.m_types);
        clone.m_userOnly = this.m_userOnly;
        if (this.m_filters != null) {
            clone.m_filters = new ArrayList<DBObjectFilter<T>>(this.m_filters);
        }
        return clone;
    }

    public static DBObjectCriteria<SystemObject> createTypeCriteria(String ... types) {
        String type;
        Class clz = null;
        if (types != null && types.length == 1 && (type = types[0]) != null) {
            clz = Metadata.getInstance().getObjectClass(type);
        }
        if (clz == null) {
            clz = SystemObject.class;
        }
        return new DBObjectCriteria<SystemObject>(clz, types);
    }

    public static DBObjectCriteria<SystemObject> createTypeCriteria(Collection<String> types) {
        String[] typesA = types == null || types.isEmpty() ? null : types.toArray(new String[types.size()]);
        return DBObjectCriteria.createTypeCriteria(typesA);
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String type, Schema schema, String nameLike) {
        return DBObjectCriteria.createCriteria(type, null, schema == null ? null : schema.getName(), nameLike);
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String type, String schemaName, String nameLike) {
        return DBObjectCriteria.createCriteria(type, null, schemaName, nameLike);
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String type, String dbName, String schemaName, String nameLike) {
        DBObjectCriteria<SystemObject> c = DBObjectCriteria.createTypeCriteria(type);
        c.setNameLike(nameLike);
        c.setSchemaName(schemaName);
        c.setDatabaseName(dbName);
        return c;
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String[] types, Schema schema, String nameLike) {
        DBObjectCriteria<SystemObject> c = DBObjectCriteria.createTypeCriteria(types);
        c.setNameLike(nameLike);
        c.setSchema(schema);
        return c;
    }

    public static DBObjectCriteria<SystemObject> createSingleObjectCriteria(String type, Schema schema, String name) {
        return DBObjectCriteria.createSingleObjectCriteria(type, null, schema == null ? null : schema.getName(), name);
    }

    public static DBObjectCriteria<SystemObject> createSingleObjectCriteria(String type, String schemaName, String name) {
        return DBObjectCriteria.createSingleObjectCriteria(type, null, schemaName, name);
    }

    public static DBObjectCriteria<SystemObject> createSingleObjectCriteria(String type, String dbName, String schemaName, String name) {
        DBObjectCriteria<SystemObject> c = DBObjectCriteria.createTypeCriteria(type);
        c.setName(name);
        c.setSchemaName(schemaName);
        c.setDatabaseName(dbName);
        return c;
    }

    public static boolean containsWildcard(String string) {
        boolean retval = false;
        for (char c : string.toCharArray()) {
            if (c != '%' && c != '_') continue;
            retval = true;
            break;
        }
        return retval;
    }
}

