/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;

public abstract class DBObjectLister {
    private final DBObjectProvider m_pro;

    protected DBObjectLister(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public abstract Collection<ObjectInfo> listObjects(DBObjectCriteria var1) throws DBException;

    public boolean supportsTimestamps(String objectType) {
        return false;
    }

    public Long getExternalTimestamp(SystemObject obj) throws DBException {
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof DBObjectLister && this.getClass().equals(obj.getClass()) && this.m_pro == ((DBObjectLister)obj).m_pro;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class ObjectInfo {
        private final String m_type;
        private final Schema m_schema;
        private final String m_name;
        private final Object m_idVal;
        private final Long m_timestamp;

        public ObjectInfo(String type, String name) {
            this(type, null, name, null, null);
        }

        public ObjectInfo(String type, Schema schema, String name) {
            this(type, schema, name, null, null);
        }

        public ObjectInfo(String type, Schema schema, String name, Object idVal) {
            this(type, schema, name, null, null);
        }

        public ObjectInfo(String type, Schema schema, String name, Object idVal, Long timestamp) {
            this.m_type = type;
            this.m_schema = schema;
            this.m_name = name;
            this.m_idVal = idVal;
            this.m_timestamp = timestamp;
        }

        public String getType() {
            return this.m_type;
        }

        public Schema getSchema() {
            return this.m_schema;
        }

        public String getName() {
            return this.m_name;
        }

        public Object getIdentifier() {
            return this.m_idVal;
        }

        public Long getTimestamp() {
            return this.m_timestamp;
        }
    }
}

