/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.BuiltInObjectCache;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public abstract class DatabaseDescriptor {
    @Deprecated
    public static final String FEATURE_TABLE_PARTITIONING = "TABLE PARTITIONING";
    @Deprecated
    public static final String FEATURE_GLOBAL_HASH_INDEX_PARTITIONING = "GLOBAL HASH INDEX PARTITIONING";
    @Deprecated
    public static final String FEATURE_COLUMN_SEQUENCES = "COLUMN SEQUENCES";
    @Deprecated
    public static final String FEATURE_STORAGE_OPTIONS = "STORAGE OPTIONS";
    @Deprecated
    public static final String FEATURE_BITMAP_INDEXING = "BITMAP INDEXING";
    @Deprecated
    public static final String FEATURE_LOB_PARAMETERS = "LOB PARAMETERS";
    @Deprecated
    public static final String FEATURE_MAXTRANS = "MAXTRANS";
    @Deprecated
    public static final String FEATURE_XMLTYPE_COL_PROPS = "XMLTYPE COLUMN STORAGE PROPERTIES";
    public static final String BUILT_IN_OBJECT = "BUILT_IN_OBJECT";
    private DatabaseDescriptor m_base;
    private Charset m_ideCharset;
    private final Class<? extends Database> m_databaseClass;
    private DefaultSourceOptions m_defaultSourceOptions;
    private BuiltInObjectCache m_builtInObjs;
    private DataTypeCache m_dataTypes;

    protected DatabaseDescriptor(Class<? extends Database> clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Descriptor class cannot be null");
        }
        this.m_databaseClass = clz;
    }

    protected DatabaseDescriptor(DatabaseDescriptor base) {
        this(base.getDatabaseClass());
        this.m_base = base;
    }

    protected final Class<? extends Database> getDatabaseClass() {
        if (this.m_databaseClass == null) {
            return this.m_base.getDatabaseClass();
        }
        return this.m_databaseClass;
    }

    public final String getDatabaseName() {
        return DatabaseRegistry.getInstance().getDatabaseName(this.getDatabaseType(), this.getDatabaseVersion());
    }

    public abstract String getDatabaseType();

    public abstract int getDatabaseVersion();

    protected DatabaseDescriptor getBaseDescriptor() {
        return this.m_base;
    }

    public void setIdeCharset(Charset charSet) {
        this.m_ideCharset = charSet;
    }

    public Charset getIdeCharset() {
        return this.m_ideCharset;
    }

    public boolean isSameDatabase(DatabaseDescriptor other) {
        return other != null && ModelUtil.areEqual((Object)this.getDatabaseType(), (Object)other.getDatabaseType()) && this.getDatabaseVersion() == other.getDatabaseVersion();
    }

    public boolean isCompatibleWith(DatabaseDescriptor other) {
        boolean retval = false;
        retval = this.m_base != null ? this.m_base.isCompatibleWith(other) : (other.m_base != null ? this.isCompatibleWith(other.m_base) : ModelUtil.areEqual((Object)this.getDatabaseType(), (Object)other.getDatabaseType()) && this.getDatabaseVersion() <= other.getDatabaseVersion());
        return retval;
    }

    @Deprecated
    public final boolean isCompatibleUpgrade(Class<? extends Database> dbClz, Class<? extends Database> testClz) {
        DatabaseDescriptor desc1 = DatabaseFactory.getDatabaseDescriptor(dbClz);
        DatabaseDescriptor desc2 = DatabaseFactory.getDatabaseDescriptor(testClz);
        return desc1 != null && desc1.isCompatibleWith(desc2);
    }

    public List<DatabaseDescriptor> listCompatibleUpgrades() {
        ArrayList<DatabaseDescriptor> retval = new ArrayList<DatabaseDescriptor>();
        DatabaseRegistry reg = DatabaseRegistry.getInstance();
        String type = this.getDatabaseType();
        for (int v : reg.listDatabaseVersions(type)) {
            DatabaseDescriptor other;
            if (v == this.getDatabaseVersion() || !this.isCompatibleWith(other = reg.getDatabaseDescriptor(type, v))) continue;
            retval.add(other);
        }
        return retval;
    }

    public final boolean isValidName(String type, String externalName) {
        try {
            this.validateName(type, externalName);
        }
        catch (InvalidNameException ine) {
            return false;
        }
        return true;
    }

    public abstract void validateName(String var1, String var2) throws InvalidNameException;

    public abstract int getCasePolicy();

    @Deprecated
    public int getQuotedNameCasePolicy() {
        return this.getCasePolicy() == 0 ? 0 : 3;
    }

    public final boolean areNamesEqual(DBObject obj1, DBObject obj2) {
        String name1 = obj1 == null ? null : obj1.getName();
        String name2 = obj2 == null ? null : obj2.getName();
        boolean retval = true;
        if (name1 != null || name2 != null) {
            String type = obj1 == null ? obj2.getType() : obj1.getType();
            retval = this.areNamesEqual(name1, name2, type, false);
        }
        return retval;
    }

    public boolean areNamesEqual(String name1, String name2, String objectType, boolean external) {
        boolean retval;
        if (name1 == name2) {
            retval = true;
        } else if (name1 == null || name2 == null) {
            retval = false;
        } else {
            String internal1 = external ? this.getInternalName(name1, objectType) : name1;
            String internal2 = external ? this.getInternalName(name2, objectType) : name2;
            int casePolicy = this.getCasePolicy();
            retval = casePolicy == 0 ? internal1.equalsIgnoreCase(internal2) : internal1.equals(internal2);
        }
        return retval;
    }

    public abstract String getIdentifierQuoteString();

    public abstract int getMaxNameLength(String var1);

    @Deprecated
    public boolean supportsFeature(String feature) {
        if (this.m_base != null) {
            return this.m_base.supportsFeature(feature);
        }
        return false;
    }

    public void validateEncoding(String string, Object property) throws ValidationException {
    }

    protected boolean needsQuoting(String internalName) {
        boolean retval;
        if (this.m_base != null) {
            retval = this.m_base.needsQuoting(internalName);
        } else if (ModelUtil.hasLength((String)internalName) && internalName.length() == internalName.trim().length()) {
            if (this.isValidName(null, internalName)) {
                switch (this.getCasePolicy()) {
                    case 2: {
                        retval = ModelUtil.areDifferent((Object)internalName, (Object)internalName.toUpperCase());
                        break;
                    }
                    case 1: {
                        retval = ModelUtil.areDifferent((Object)internalName, (Object)internalName.toLowerCase());
                        break;
                    }
                    default: {
                        retval = false;
                        break;
                    }
                }
            } else {
                retval = true;
            }
        } else {
            retval = true;
        }
        return retval;
    }

    public String quoteIdentifier(String internalName, boolean force) throws InvalidNameException {
        String retval;
        if (this.m_base != null) {
            return this.m_base.quoteIdentifier(internalName, force);
        }
        String quote = this.getIdentifierQuoteString();
        String string = quote = quote != null ? quote.trim() : "";
        if (ModelUtil.hasLength((String)internalName)) {
            if (quote.length() == 0) {
                this.validateName(null, internalName);
                retval = internalName;
            } else if (force || this.needsQuoting(internalName)) {
                String escapedQuote = this.escapeQuoteCharacter(quote);
                String externalName = quote + internalName.replaceAll(Pattern.quote(quote), escapedQuote) + quote;
                this.validateName(null, externalName);
                retval = externalName;
            } else {
                retval = internalName;
            }
        } else {
            throw new InvalidNameException(null, APIBundle.get("INVALID_IDENTIFIER_NO_NAME"));
        }
        return retval;
    }

    protected String escapeQuoteCharacter(String quote) {
        String retval = this.m_base != null ? this.m_base.escapeQuoteCharacter(quote) : (quote.equals("\"") ? "\\" + quote : quote + quote);
        return retval;
    }

    public String getInternalName(String externalName, String objectType) {
        if (this.m_base != null) {
            return this.m_base.getInternalName(externalName, objectType);
        }
        String quote = this.getIdentifierQuoteString();
        int casePolicy = this.getCasePolicy();
        String internalName = externalName;
        if (ModelUtil.hasLength((String)externalName)) {
            externalName = externalName.trim();
            if (ModelUtil.hasLength((String)quote)) {
                int qLen = quote.length();
                int nLen = externalName.length();
                int idx1 = externalName.indexOf(quote);
                int idx2 = externalName.lastIndexOf(quote);
                if (nLen > qLen && idx1 == 0 && idx2 == nLen - qLen) {
                    internalName = externalName.substring(idx1 + qLen, idx2);
                    boolean canBePath = this.canIncludePath(objectType);
                    idx1 = internalName.indexOf(quote);
                    while (idx1 > -1 && idx1 < internalName.length()) {
                        idx2 = internalName.indexOf(quote, idx1 + qLen);
                        if (idx2 == idx1 + qLen) {
                            internalName = internalName.substring(0, idx1 + 1) + internalName.substring(idx2 + qLen);
                        } else if (canBePath && idx2 == idx1 + qLen + 1 && internalName.charAt(idx2 - 1) == '.') {
                            internalName = internalName.substring(0, idx1) + '.' + internalName.substring(idx2 + qLen);
                        }
                        idx1 = internalName.indexOf(quote, idx1 + qLen);
                    }
                }
            }
            if (ModelUtil.areEqual((Object)internalName, (Object)externalName)) {
                switch (casePolicy) {
                    case 2: {
                        internalName = externalName.toUpperCase();
                        break;
                    }
                    case 1: {
                        internalName = externalName.toLowerCase();
                        break;
                    }
                }
            }
        }
        return internalName;
    }

    private boolean canIncludePath(String type) {
        return "SQLFragment".equals(type);
    }

    public String getExternalName(String internalName, String objectType) {
        String retval;
        try {
            retval = this.quoteIdentifier(internalName, false);
        }
        catch (InvalidNameException ex) {
            retval = internalName;
        }
        return retval;
    }

    public final Collection<String> listSchemaNamespaceTypes(DBObjectProvider pro) {
        ArrayList<String> retval;
        if (this.m_base == null) {
            retval = new ArrayList();
            for (Map.Entry<String, DBObjectValidator> entry : this.getValidators(pro).entrySet()) {
                DBObjectValidator v = entry.getValue();
                if (v != null && v.getNamespaceType() != DBObjectValidator.NamespaceType.SCHEMA) continue;
                retval.add(entry.getKey());
            }
        } else {
            retval = this.m_base.listSchemaNamespaceTypes(pro);
        }
        return retval;
    }

    public abstract Map<String, DBObjectValidator> getValidators(DBObjectProvider var1);

    public DBObjectLister getTriggerLister(DBObjectProvider pro) {
        return null;
    }

    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider pro) {
        if (this.m_base != null) {
            return this.m_base.getPropertyInitializers(pro);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public List<PropertyInitializer> getExternalPropertyDefaulters(DBObjectProvider pro) {
        if (this.m_base != null) {
            return this.m_base.getExternalPropertyDefaulters(pro);
        }
        return Collections.emptyList();
    }

    public List<UpdateProcessor> getUpdateProcessors() {
        if (this.m_base != null) {
            return this.m_base.getUpdateProcessors();
        }
        return Collections.emptyList();
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        DDLGenerator retval = null;
        if (this.m_base != null) {
            retval = this.m_base.getDDLGenerator(pro);
        }
        return retval;
    }

    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        SQLQueryBuilderFactory f = null;
        if (this.m_base != null) {
            f = this.m_base.getSQLQueryBuilderFactory();
        }
        return f;
    }

    public PlSqlParserFactory getPlSqlParserFactory(DBObjectProvider pro) {
        PlSqlParserFactory f = null;
        if (this.m_base != null) {
            f = this.m_base.getPlSqlParserFactory(pro);
        }
        return f;
    }

    public DerivedPropertyBuilder getDerivedPropertyBuilder(Class<? extends AbstractBuildableObject> objClz, DBObjectProvider pro) {
        DerivedPropertyBuilder dpb = null;
        if (this.m_base != null) {
            dpb = this.m_base.getDerivedPropertyBuilder(objClz, pro);
        }
        return dpb;
    }

    public boolean supportsRowID(DBObjectProvider pro, String objectName) {
        boolean retval = false;
        if (this.m_base != null) {
            retval = this.m_base.supportsRowID(pro, objectName);
        }
        return retval;
    }

    public Collection<DataType> listSupportedDataTypes() {
        Collection<DataType> retval = null;
        if (this.m_base == null) {
            TreeMap<String, DataType> listed = null;
            Iterator<DataTypeCache> iter = this.getDataTypeCaches();
            while (iter.hasNext()) {
                DataTypeCache dtc = iter.next();
                if (dtc == null) continue;
                if (listed == null) {
                    listed = new TreeMap<String, DataType>();
                }
                for (DataType dt : dtc.listSupportedDataTypes()) {
                    String name = dt.getName();
                    if (listed.containsKey(name)) continue;
                    listed.put(name, dt);
                }
            }
            if (listed == null) {
                retval = new ArrayList<DataType>();
                DataTypeRegistry dtr = DataTypeRegistry.getInstance();
                Class<? extends Database> dbClz = this.getDatabaseClass();
                if (dbClz != null && dtr.isRegistered(dbClz)) {
                    for (DataType type : dtr.listDataTypes(dbClz)) {
                        retval.add(type);
                    }
                }
            } else {
                retval = new ArrayList(listed.values());
            }
        } else {
            retval = this.m_base.listSupportedDataTypes();
        }
        return retval;
    }

    public final Collection<DataType> listPreferredDataTypes() {
        ArrayList<DataType> retval = new ArrayList<DataType>();
        for (String name : this.listPreferredDataTypeNames()) {
            DataType dt = this.getDataType(name);
            if (dt == null) continue;
            retval.add(dt);
        }
        return retval;
    }

    public Collection<String> listPreferredDataTypeNames() {
        Collection<String> retval = this.m_base == null ? Collections.emptyList() : this.m_base.listPreferredDataTypeNames();
        return retval;
    }

    public DataTypeUsage createDefaultTypeUsage() {
        DataTypeUsage retval = null;
        if (this.m_base == null) {
            Collection<DataType> types = this.listPreferredDataTypes();
            if (types.size() > 0) {
                retval = types.iterator().next().createDefaultUsage();
            }
            if (retval == null) {
                retval = this.findDataType("VARCHAR2", "VARCHAR", "CHAR", "CHARACTER");
            }
        } else {
            retval = this.m_base.createDefaultTypeUsage();
        }
        return retval;
    }

    public DataTypeUsage createDefaultNumericTypeUsage() {
        DataTypeUsage retval = null;
        if (this.m_base == null) {
            Collection<DataType> types = this.listPreferredDataTypes();
            for (DataType type : types) {
                if (!ModelUtil.areEqual((Object)2, (Object)type.getSQLType())) continue;
                retval = type.createDefaultUsage();
                break;
            }
            if (retval == null) {
                retval = this.findDataType("NUMBER", "NUMERIC", "INTEGER", "INT");
            }
        } else {
            retval = this.m_base.createDefaultNumericTypeUsage();
        }
        return retval;
    }

    private DataTypeUsage findDataType(String ... names) {
        String name;
        DataType dt = null;
        String[] stringArray = names;
        int n = stringArray.length;
        for (int i = 0; i < n && (dt = this.getDataType(name = stringArray[i])) == null; ++i) {
        }
        return dt == null ? null : dt.createDefaultUsage();
    }

    public DataType getDataType(String typeName) {
        DataType type = null;
        if (this.m_base == null) {
            typeName = typeName.trim().toUpperCase();
            boolean foundCache = false;
            Iterator<DataTypeCache> iter = this.getDataTypeCaches();
            while (iter.hasNext()) {
                DataTypeCache dtc = iter.next();
                if (dtc == null) continue;
                foundCache = true;
                type = dtc.getDataType(typeName);
                if (type == null) continue;
                break;
            }
            if (!foundCache) {
                DataTypeRegistry dtr = DataTypeRegistry.getInstance();
                Class<? extends Database> dbClz = this.getDatabaseClass();
                if (dbClz != null && dtr.isRegistered(dbClz)) {
                    type = dtr.findDataType(typeName, dbClz);
                }
            }
        } else {
            type = this.m_base.getDataType(typeName);
        }
        return type;
    }

    protected final Iterator<DataTypeCache> getDataTypeCaches() {
        return new VersionIterator<DataTypeCache>(){

            @Override
            protected DataTypeCache getVersion(DatabaseDescriptor desc) {
                if (desc.m_dataTypes == null) {
                    desc.m_dataTypes = DatabaseRegistry.getInstance().getDataTypeCache(desc.getDatabaseType(), desc.getDatabaseVersion());
                }
                return desc.m_dataTypes;
            }
        };
    }

    protected void registerDataTypes(DataTypeCache cache) {
    }

    protected final Iterator<BuiltInObjectCache> getBuiltInObjectCaches() {
        return new VersionIterator<BuiltInObjectCache>(){

            @Override
            protected BuiltInObjectCache getVersion(DatabaseDescriptor desc) {
                if (desc.m_builtInObjs == null) {
                    desc.m_builtInObjs = DatabaseRegistry.getInstance().getBuiltInObjectCache(desc.getDatabaseType(), desc.getDatabaseVersion());
                }
                return desc.m_builtInObjs;
            }
        };
    }

    protected void registerBuiltInObjects(BuiltInObjectCache cache) {
    }

    public final <T extends SystemObject> T getBuiltInObject(DBObjectCriteria<T> criteria) {
        SystemObject retval = null;
        Collection<T> list = this.listBuiltInObjects(criteria);
        if (list != null && list.size() == 1) {
            retval = (SystemObject)list.iterator().next();
        }
        return (T)retval;
    }

    public final <T extends SystemObject> Collection<T> listBuiltInObjects(DBObjectCriteria<T> criteria) {
        Collection<T> objs;
        if (this.m_base == null) {
            objs = this.listBuiltInObjectsImpl(criteria);
            for (SystemObject obj : objs) {
                this.initialiseBuiltInObject(obj);
            }
        } else {
            objs = this.m_base.listBuiltInObjects(criteria);
        }
        return objs;
    }

    protected <T extends SystemObject> Collection<T> listBuiltInObjectsImpl(DBObjectCriteria<T> criteria) {
        TreeSet<DBObject> retval = null;
        Iterator<BuiltInObjectCache> caches = this.getBuiltInObjectCaches();
        while (caches.hasNext()) {
            Collection<T> listed;
            BuiltInObjectCache cache = caches.next();
            if (cache == null || (listed = cache.listBuiltInObjects(criteria)) == null || listed.size() <= 0) continue;
            if (retval == null) {
                retval = new TreeSet<DBObject>(DBUtil.getTypeComparator());
            }
            for (SystemObject obj : listed) {
                if (retval.contains(obj)) continue;
                retval.add((SystemObject)obj.copyTo(null, new IDPolicy.SameIDPolicy()));
            }
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    protected void initialiseBuiltInObject(SystemObject obj) {
        obj.setProperty(BUILT_IN_OBJECT, Boolean.TRUE);
    }

    public String getPublicSchemaName() {
        String retval = null;
        if (this.m_base != null) {
            retval = this.m_base.getPublicSchemaName();
        }
        return retval;
    }

    public String getDefaultSchemaName() {
        String retval = null;
        if (this.m_base != null) {
            retval = this.m_base.getDefaultSchemaName();
        }
        return retval;
    }

    public String getSchemaDisplayName() {
        String retval = this.m_base == null ? DisplayNames.getPropertyDisplayName("schema") : this.m_base.getSchemaDisplayName();
        return retval;
    }

    public final boolean isValidFKDataType(DataType fktype, DataType reftype) {
        PredefinedDataType reftype2;
        PredefinedDataType fktype2 = DataTypeHelper.unwrapDataType(fktype, PredefinedDataType.class);
        if (fktype2 != null) {
            fktype = fktype2;
        }
        if ((reftype2 = DataTypeHelper.unwrapDataType(reftype, PredefinedDataType.class)) != null) {
            reftype = reftype2;
        }
        return this.isValidFKDataTypeImpl(fktype, reftype);
    }

    protected boolean isValidFKDataTypeImpl(DataType fktype, DataType reftype) {
        boolean retval;
        if (this.m_base == null) {
            retval = ModelUtil.areEqual((Object)fktype, (Object)reftype);
            if (!retval && fktype instanceof PredefinedDataType && reftype instanceof PredefinedDataType) {
                retval = this.isValidFKDataTypeValueTypeImpl(((PredefinedDataType)fktype).getValueType(), ((PredefinedDataType)reftype).getValueType());
            }
        } else {
            retval = this.m_base.isValidFKDataTypeImpl(fktype, reftype);
        }
        return retval;
    }

    protected boolean isValidFKDataTypeValueTypeImpl(PredefinedDataType.ValueType fktype, PredefinedDataType.ValueType reftype) {
        return fktype == reftype && PredefinedDataType.ValueType.isNumericType(fktype);
    }

    @Deprecated
    public void makeNameValidAndUnique(DBObject object, DBObjectProvider pro) throws InvalidNameException {
        if (object != null) {
            String type = object.getType();
            String base = pro.getInternalName(object.getName(), type);
            object.setName(pro.getUniqueName(type, object, base));
        }
    }

    public Collection<String> getReservedWords() {
        return Collections.emptySet();
    }

    public SqlAliasExpander getSqlAliasExpander(DBObjectProvider pro) {
        return this.getSqlAliasExpander(pro, null);
    }

    public SqlAliasExpander getSqlAliasExpander(DBObjectProvider pro, Schema defaultSchema) {
        if (this.m_base != null) {
            return this.m_base.getSqlAliasExpander(pro, defaultSchema);
        }
        return null;
    }

    public final DefaultSourceOptions getDefaultSourceOptions() {
        if (this.m_base != null) {
            return this.m_base.getDefaultSourceOptions();
        }
        if (this.m_defaultSourceOptions == null) {
            this.m_defaultSourceOptions = new DefaultSourceOptions();
            this.initialiseDefaultSourceOptions(this.m_defaultSourceOptions);
        }
        return this.m_defaultSourceOptions;
    }

    protected void initialiseDefaultSourceOptions(DefaultSourceOptions opts) {
    }

    public boolean isNullConstraintColumnAllowed(ColumnConstraint con) {
        if (this.m_base != null) {
            return this.m_base.isNullConstraintColumnAllowed(con);
        }
        return !(con instanceof PKConstraint) || !con.isEnabled();
    }

    public final List<BuiltInFunction> listBuiltInFunctions() {
        return this.listBuiltInFunctions(null);
    }

    public final List<BuiltInFunction> listBuiltInFunctions(String name) {
        if (this.m_base != null) {
            return this.m_base.listBuiltInFunctions(name);
        }
        ArrayList<BuiltInFunction> ret = new ArrayList<BuiltInFunction>();
        Iterator<BuiltInObjectCache> caches = this.getBuiltInObjectCaches();
        while (caches.hasNext()) {
            BuiltInObjectCache cache = caches.next();
            if (cache == null) continue;
            for (BuiltInFunction bif : cache.listBuiltInFunctions()) {
                if (name != null && !name.equals(bif.getName())) continue;
                ret.add(bif);
            }
        }
        return ret;
    }

    public String getBuiltInFunctionDescription(BuiltInFunction bif) {
        if (this.m_base != null) {
            return this.m_base.getBuiltInFunctionDescription(bif);
        }
        return null;
    }

    public boolean allowSurrogatesInIdentifierValidation() {
        return false;
    }

    public static void validateIdentifier(String identifier, char quoter, int maxLength, String allowedChars, String excludedChars, boolean alphaStart, Set reservedWords, int casePolicy, boolean allowSurrogates) throws InvalidNameException {
        int charCount = identifier.length();
        int codePointCount = identifier.codePointCount(0, charCount);
        if (!ModelUtil.hasLength((String)identifier)) {
            throw new InvalidNameException(null, APIBundle.get("INVALID_IDENTIFIER_NO_NAME"));
        }
        if (identifier.charAt(0) == quoter) {
            if (identifier.charAt(charCount - 1) != quoter) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_MISSING_CLOSING_QUOTE", identifier));
            }
            if (charCount <= 2) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_NO_NAME", identifier));
            }
            int embeddedQuoteCount = 0;
            for (int idx = 1; idx < charCount - 1; ++idx) {
                if (excludedChars != null && excludedChars.indexOf(identifier.charAt(idx)) >= 0) {
                    throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_ILLEGAL_CHARACTER", identifier));
                }
                if (identifier.charAt(idx) != quoter) continue;
                if (++idx == charCount - 1 || identifier.charAt(idx) != quoter) {
                    throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_ILLEGAL_CHARACTER", identifier));
                }
                ++embeddedQuoteCount;
            }
            if (codePointCount - embeddedQuoteCount > maxLength + 2) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_TOO_LONG", identifier));
            }
        } else {
            if (codePointCount > maxLength) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_TOO_LONG", identifier));
            }
            if (casePolicy == 2) {
                identifier = identifier.toUpperCase();
            } else if (casePolicy == 1) {
                identifier = identifier.toLowerCase();
            }
            if (reservedWords != null && reservedWords.contains(identifier)) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_RESERVED_WORD", identifier));
            }
            if (alphaStart && !Character.isAlphabetic(identifier.codePointAt(0))) {
                throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_NON_ALPHA_START", identifier));
            }
            if (allowedChars != null) {
                IntStream codePoints = identifier.codePoints();
                PrimitiveIterator.OfInt iter = codePoints.iterator();
                while (iter.hasNext()) {
                    boolean isAlphaNumeric;
                    Integer codePoint = (Integer)iter.next();
                    boolean bl = isAlphaNumeric = Character.isAlphabetic(codePoint) || Character.isDigit(codePoint);
                    if ((allowSurrogates || !Character.isSupplementaryCodePoint(codePoint)) && (isAlphaNumeric || allowedChars.indexOf(codePoint) >= 0)) continue;
                    throw new InvalidNameException(null, APIBundle.format("INVALID_IDENTIFIER_ILLEGAL_CHARACTER", identifier));
                }
            }
        }
    }

    public static void validateIdentifier(String identifier, char quoter, int maxLength, String allowedChars, boolean alphaStart, Set reservedWords, int casePolicy, boolean allowSurrogates) throws InvalidNameException {
        DatabaseDescriptor.validateIdentifier(identifier, quoter, maxLength, allowedChars, null, alphaStart, reservedWords, casePolicy, allowSurrogates);
    }

    private abstract class VersionIterator<C>
    implements Iterator<C> {
        private Integer m_last;
        private List<Integer> m_versions;

        private VersionIterator() {
        }

        private List<Integer> getVersions() {
            if (this.m_versions == null) {
                this.m_versions = DatabaseRegistry.getInstance().listDatabaseVersions(DatabaseDescriptor.this.getDatabaseType());
            }
            return this.m_versions;
        }

        protected abstract C getVersion(DatabaseDescriptor var1);

        @Override
        public boolean hasNext() {
            boolean retval = false;
            List<Integer> versions = this.getVersions();
            if (versions.size() > 0) {
                retval = this.m_last == null ? true : this.m_last > 0 && this.m_last > versions.get(0);
            }
            return retval;
        }

        @Override
        public C next() {
            DatabaseDescriptor desc;
            if (this.m_last == null) {
                desc = DatabaseDescriptor.this;
            } else {
                List<Integer> versions = this.getVersions();
                int previousVersion = versions.get(versions.indexOf(this.m_last) - 1);
                desc = DatabaseRegistry.getInstance().getDatabaseDescriptor(DatabaseDescriptor.this.getDatabaseType(), previousVersion);
            }
            this.m_last = desc != null ? Integer.valueOf(desc.getDatabaseVersion()) : Integer.valueOf(0);
            return this.getVersion(desc);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

