/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Map;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.util.DBObjectIDMap;

public abstract class IDPolicy {
    private Map<DBObjectID, DBObjectID> m_idMap = new DBObjectIDMap<DBObjectID>(true);

    protected final void copyID(DBObject original, DBObject copy) {
        DBObjectID newID = this.getNewID(original, copy);
        if (newID != null) {
            copy.setID(newID);
            DBObjectID originalID = original.getID();
            if (originalID != null) {
                this.m_idMap.put(originalID, newID);
            }
        }
    }

    protected abstract DBObjectID getNewID(DBObject var1, DBObject var2);

    public final Map<DBObjectID, DBObjectID> getIDMap() {
        return this.m_idMap;
    }

    public final Map<DBObjectID, DBObjectID> getReverseIDMap() {
        DBObjectIDMap<DBObjectID> sdrawkcab = new DBObjectIDMap<DBObjectID>(true);
        for (Map.Entry<DBObjectID, DBObjectID> entry : this.m_idMap.entrySet()) {
            DBObjectID value = entry.getValue();
            if (value == null) continue;
            sdrawkcab.put(value, entry.getKey());
        }
        return sdrawkcab;
    }

    public static class DBLinkIDPolicy
    extends IDPolicy {
        private final AbstractDBObjectProvider m_pro;
        private final String m_dbname;

        public DBLinkIDPolicy(AbstractDBObjectProvider pro, String dbName) {
            this.m_pro = pro;
            this.m_dbname = dbName;
        }

        @Override
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            BaseObjectID ret = null;
            DBObjectID id = original.getID();
            if (id instanceof BaseObjectID) {
                ret = BaseObjectID.copyWithNewProvider((BaseObjectID)id, this.m_pro);
                ret.setDatabaseName(this.m_dbname);
            }
            return ret;
        }
    }

    public static class DefaultIDPolicy
    extends IDPolicy {
        @Override
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            if (original.getID() != null && copy.getID() == null) {
                return TemporaryObjectID.createID(copy);
            }
            return null;
        }
    }

    public static class SameIDPolicy
    extends IDPolicy {
        @Override
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            DBObjectID id;
            DBObjectID retval = id = original.getID();
            if (id instanceof TemporaryObjectID) {
                DBObject originalOriginal = ((TemporaryObjectID)id).getOriginalObject();
                if (originalOriginal == copy) {
                    DBObjectID copyID = copy.getID();
                    if (copyID != null) {
                        retval = copyID;
                    }
                } else {
                    retval = TemporaryObjectID.createID(copy, originalOriginal);
                }
            }
            return retval;
        }
    }

    @Deprecated
    public static class TemporaryIDPolicy
    extends TemporaryObjectID.TemporaryIDPolicy {
    }
}

