/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.ColumnConstraintReferenceID;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.MissingProviderException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.util.ModelUtil;

public class ReferenceID
extends BaseObjectID
implements ColumnConstraintReferenceID {
    private String m_subtype;
    private Object m_identifier;
    private List<String> m_childObjectNames = new ArrayList<String>();

    public ReferenceID() {
        this.setType("UNSPECIFIED_TYPE");
    }

    public ReferenceID(DBObjectID id) throws DBException {
        this(id, null);
    }

    public ReferenceID(DBObjectID id, DBObjectProvider pro) throws DBException {
        DBObject obj = null;
        obj = id.resolveID();
        this.initialise(obj, id, pro);
    }

    public ReferenceID(DBObject obj) {
        this(obj, (DBObjectProvider)null);
    }

    public ReferenceID(DBObject obj, DBObjectProvider pro) {
        try {
            this.initialise(obj, obj.getID(), pro);
        }
        catch (DBException dbe) {
            this.getLogger().warning("Error initialising reference: " + dbe.getMessage());
        }
    }

    public ReferenceID(String type, String schemaName, String name) {
        this(type, schemaName, null, name, null, null, null);
    }

    public ReferenceID(String type, Schema schema, String name) {
        this(type, schema, name, null);
    }

    public ReferenceID(String type, Schema schema, String name, String dbName) {
        this(type, null, null, name, null, dbName, null);
        this.setSchema(schema);
    }

    public ReferenceID(String type, DBObjectID parent, String name, String subtype, String[] childObjectNames) {
        this(type, null, parent, name, subtype, null, childObjectNames);
    }

    private ReferenceID(String type, String schemaName, DBObjectID parent, String name, String subtype, String dbName, String[] childObjectNames) {
        this.setType(type);
        this.setName(name);
        this.setSchemaName(schemaName);
        this.setParent(parent);
        this.setDatabaseName(dbName);
        this.setChildObjectNames(childObjectNames);
        this.m_subtype = subtype;
    }

    @Override
    public void construct(String id) {
        String pseudo;
        String[] items = id.split(":");
        int next = 3;
        if (items.length > 2) {
            this.setType(" ".equals(items[0]) ? null : items[0]);
            this.setSchemaName(" ".equals(items[1]) ? null : items[1]);
            this.setName(" ".equals(items[2]) ? null : items[2]);
        }
        if (items.length > 3 && !ReferenceID.isRecognizedType(pseudo = items[3] + ":")) {
            this.setDatabaseName(" ".equals(items[3]) ? null : items[3]);
            next = 4;
        }
        StringBuilder parentIdBuilder = new StringBuilder();
        for (int index = next; index < items.length; ++index) {
            parentIdBuilder.append(items[index]);
            if (index >= items.length - 1) continue;
            parentIdBuilder.append(":");
        }
        if (parentIdBuilder.length() > 0) {
            this.setParent(BaseObjectID.createFromString(parentIdBuilder.toString()));
        }
    }

    private void initialise(DBObject obj, DBObjectID id, DBObjectProvider pro) throws DBException {
        DBObjectID par;
        if (obj != null) {
            this.initialise(obj);
        } else if (id instanceof BaseObjectID) {
            id.copyTo(this);
        }
        if (pro instanceof AbstractDBObjectProvider) {
            this.setProviderImpl((AbstractDBObjectProvider)pro);
        }
        if ((par = this.getParent()) != null && !(par instanceof ReferenceID)) {
            par = new ReferenceID(par, this.getProvider());
            this.setParent(par);
        }
        if (id instanceof IdentifierBasedID) {
            this.m_identifier = ((IdentifierBasedID)id).getIdentifier();
        }
    }

    private void initialise(DBObject obj) {
        DBObject objPar = obj.getParent();
        if (objPar != null) {
            this.setParent(new ReferenceID(objPar));
        }
        this.setType(obj.getType());
        this.setName(obj.getName());
        if (obj instanceof SchemaObject) {
            this.setSchema(((SchemaObject)obj).getSchema());
        }
        if (obj instanceof Constraint) {
            this.setSubType(((Constraint)obj).getConstraintType());
        } else if (obj instanceof Type) {
            this.setSubType(((Type)obj).getCollectionType());
        }
        if (obj instanceof ColumnConstraint) {
            for (DBObjectID id : ((ColumnConstraint)obj).getColumnIDs()) {
                this.addChildObjectName(id);
            }
        }
    }

    public final String[] getChildObjectNames() {
        return this.m_childObjectNames.toArray(new String[this.m_childObjectNames.size()]);
    }

    public final void setChildObjectNames(String[] names) {
        this.m_childObjectNames.clear();
        if (names != null) {
            for (String s : names) {
                this.m_childObjectNames.add(s);
            }
        }
    }

    @Override
    public final String getSubType() {
        return this.m_subtype;
    }

    public final void setSubType(String subType) {
        this.m_subtype = subType;
    }

    public final Object getIdentifier() {
        return this.m_identifier;
    }

    public final void setIdentifier(Object obj) {
        this.m_identifier = obj;
    }

    @Override
    @Deprecated
    public final DBObject resolveReference(Database db) {
        try {
            return DBUtil.resolveInOtherProvider(this, db);
        }
        catch (DBException dbe) {
            return null;
        }
    }

    @Override
    @Deprecated
    public final DBObjectID getNewID() {
        return null;
    }

    @Override
    @Deprecated
    public final String[] getColumnNames() {
        return this.getChildObjectNames();
    }

    @Override
    protected boolean equalsImpl(DBObjectID id, boolean strict) {
        boolean equal = id instanceof ReferenceID && this.equalsImpl((ReferenceID)id);
        String name = this.getName();
        if (!equal && "DATATYPE".equals(this.getType())) {
            String otherType;
            if (id instanceof BaseObjectID && ("TYPE".equals(otherType = id.getType()) || "SYNONYM".equals(otherType))) {
                equal = ModelUtil.areEqual((Object)name, (Object)((BaseObjectID)id).getName()) && ModelUtil.areEqual((Object)this.getSchemaName(), (Object)((BaseObjectID)id).getSchemaName());
            }
        } else if (!equal && !strict) {
            Object ident;
            if (id instanceof IdentifierBasedID && this.m_identifier != null && (ident = ((IdentifierBasedID)id).getIdentifier()) != null && this.m_identifier != null && ident.getClass() == this.m_identifier.getClass() && ModelUtil.areEqual((Object)this.getType(), (Object)id.getType()) && ident.equals(this.m_identifier)) {
                equal = true;
            }
            if (!equal && id instanceof BaseObjectID && this.hasSameObjectName((BaseObjectID)id)) {
                equal = true;
            }
            if (!equal && !(id instanceof ReferenceID)) {
                try {
                    DBObject obj = id.resolveID();
                    equal = this.resolvesTo(obj);
                }
                catch (DBException dbe) {
                    this.getLogger().fine(dbe.getMessage());
                }
            }
        }
        return equal;
    }

    protected boolean resolvesTo(DBObject obj) {
        boolean retval = false;
        if (obj != null) {
            int pos;
            Schema schema;
            DBObjectID parID = this.getParent();
            String type = this.getType();
            if ("DATATYPE".equals(type)) {
                type = "TYPE";
            }
            String name = this.getName();
            boolean schemaMatches = obj instanceof SchemaObject ? (schema = ((SchemaObject)obj).getSchema()) != null && ModelUtil.areEqual((Object)schema.getName(), (Object)this.getSchemaName()) : true;
            if (schemaMatches && ModelUtil.areEqual((Object)name, (Object)obj.getName()) && (ModelUtil.areEqual((Object)type, (Object)obj.getType()) || "UNSPECIFIED_TYPE".equals(type))) {
                retval = true;
            } else if (name != null && obj instanceof PlSqlSubProgram && (pos = name.indexOf("(")) > 0) {
                String baseName = name.substring(0, pos);
                if (this.getParent() == null) {
                    if (obj instanceof Procedure && schemaMatches && ModelUtil.areEqual((Object)obj.getName(), (Object)baseName)) {
                        retval = true;
                    }
                } else {
                    DBObjectID objParentID;
                    DBObject objParent = obj.getParent();
                    DBObjectID dBObjectID = objParentID = objParent == null ? null : objParent.getID();
                    if (this.getParent().equals(objParentID, false)) {
                        DBObject sp = obj.getParent().findOwnedObject(this);
                        retval = obj == sp;
                    }
                }
            }
        }
        return retval;
    }

    protected boolean equalsImpl(ReferenceID id) {
        return super.equalsImpl(id) && ModelUtil.areEqual((Object)id.m_subtype, (Object)this.m_subtype) && ModelUtil.areEqual(id.m_childObjectNames, this.m_childObjectNames) && ModelUtil.areEqual((Object)id.m_identifier, (Object)this.m_identifier);
    }

    public Object copyTo(Object target) {
        if (target instanceof BaseObjectID && !(target instanceof ReferenceID)) {
            this.copyToImpl((BaseObjectID)target);
            return target;
        }
        ReferenceID copy = target == null ? new ReferenceID() : (ReferenceID)target;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(ReferenceID target) {
        super.copyToImpl(target);
        target.m_identifier = this.m_identifier;
        target.m_subtype = this.m_subtype;
        target.setChildObjectNames(this.getChildObjectNames());
    }

    @Override
    protected String toStringImpl() {
        StringBuilder builder = new StringBuilder();
        String type = this.getType();
        String sName = this.getSchemaName();
        String name = this.getName();
        builder.append(type).append(":");
        builder.append(ModelUtil.hasLength((String)sName) ? sName : " ").append(":");
        builder.append(ModelUtil.hasLength((String)name) ? name : " ");
        if (this.getParent() instanceof BaseObjectID) {
            builder.append(":").append(this.getParent().toString());
        }
        return builder.toString();
    }

    @Override
    public DBObject resolveID() throws DBException {
        DBObject retval;
        if ("DATATYPE".equals(this.getType())) {
            retval = DataTypeHelper.resolveDataTypeReferenceID(this);
        } else {
            try {
                retval = super.resolveID();
            }
            catch (MissingProviderException mpe) {
                retval = null;
            }
        }
        return retval;
    }

    @Override
    public DBObject resolveInParentObject(DBObject parent) throws DBException {
        return this.resolveInParentObject(parent, null);
    }

    private DBObject resolveInParentObject(DBObject parent, ReferenceInfo info) throws DBException {
        DBObject retval;
        if (parent instanceof Synonym) {
            List<SchemaObject> chain = DBUtil.getSynonymReferenceChain((Synonym)parent);
            int size = chain.size();
            if (info != null) {
                for (int i = 1; i < size; ++i) {
                    info.add(chain.get(i));
                }
            }
            parent = chain.get(size - 1);
        }
        if ((retval = super.resolveInParentObject(parent)) == null) {
            retval = parent.findOwnedObject(this.getType(), this.getName());
        }
        return retval;
    }

    public void addChildObjectName(DBObjectID id) {
        String name;
        if (id instanceof BaseObjectID && ModelUtil.hasLength((String)(name = ((BaseObjectID)id).getName()))) {
            this.addChildObjectName(name);
            return;
        }
        try {
            DBObject obj = id.resolveID();
            if (obj != null) {
                this.addChildObjectName(obj);
                return;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public void addChildObjectName(DBObject obj) {
        if (obj != null) {
            this.addChildObjectName(obj.getName());
        }
    }

    public void addChildObjectName(String name) {
        this.m_childObjectNames.add(name);
    }

    public ReferenceInfo getReferenceInfo() throws DBException {
        DBObject result;
        ReferenceInfo retval = new ReferenceInfo();
        DBObjectID parent = this.getParent();
        if (parent != null) {
            DBObject parentObj;
            if (parent instanceof ReferenceID) {
                ReferenceInfo parInfo = ((ReferenceID)parent).getReferenceInfo();
                retval.addAll(parInfo);
                parentObj = parInfo.getResult();
            } else {
                parentObj = parent.resolveID();
            }
            result = parentObj == null ? null : this.resolveInParentObject(parentObj, retval);
        } else {
            result = this.resolveID();
        }
        retval.add(result);
        return retval;
    }

    public class ReferenceInfo {
        private final List<DBObject> m_objs = new ArrayList<DBObject>();

        private ReferenceInfo() {
        }

        public DBObject getResult() {
            if (this.m_objs.isEmpty()) {
                return null;
            }
            return this.m_objs.get(this.m_objs.size() - 1);
        }

        public List<SystemObject> getSystemObjects() {
            DBObject obj;
            ArrayList<SystemObject> ret = new ArrayList<SystemObject>();
            int size = this.m_objs.size();
            for (int i = 0; i < size && (obj = this.m_objs.get(i)) instanceof SystemObject; ++i) {
                ret.add((SystemObject)obj);
            }
            return ret;
        }

        private void add(DBObject obj) {
            this.m_objs.add(obj);
        }

        private void addAll(ReferenceInfo info) {
            this.m_objs.addAll(info.getSystemObjects());
        }
    }
}

