/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.AbstractPropertyManager;
import oracle.javatools.db.property.PropertyAction;

abstract class AbstractDDLGenerator<T extends DDLType>
extends AbstractPropertyManager
implements DDLGenerator<T> {
    private Class<? extends Database> m_databaseClass;

    protected AbstractDDLGenerator(Class<? extends Database> databaseClass, DBObjectProvider pro) {
        super(pro);
        if (databaseClass == null) {
            throw new IllegalArgumentException("Database class cannot be null");
        }
        this.m_databaseClass = databaseClass;
    }

    @Override
    protected Class<? extends DBObjectProvider> getProviderClass() {
        return this.m_databaseClass;
    }

    @Override
    public boolean supportsAction(String type, PropertyAction.Type action) {
        return false;
    }

    @Override
    protected boolean canCreate(Class<? extends SystemObject> objClass, String prop) {
        return false;
    }

    @Override
    public final DDL<T> getCreateDDL(DDLOptions options, DBObject ... objects) {
        DDL<T> retval = null;
        if (objects != null) {
            retval = this.getCreateDDLImpl(options, DBUtil.stripNulls(objects));
        }
        return this.finish(options, retval);
    }

    protected abstract DDL<T> getCreateDDLImpl(DDLOptions var1, DBObject ... var2);

    @Override
    public final DDL<T> getDeleteDDL(DDLOptions options, DBObject ... objects) {
        DDL<T> retval = null;
        if (objects != null) {
            retval = this.getDeleteDDLImpl(options, DBUtil.stripNulls(objects));
        }
        return this.finish(options, retval);
    }

    protected abstract DDL<T> getDeleteDDLImpl(DDLOptions var1, DBObject ... var2);

    @Override
    public final DDL<T> getUpdateDDL(DDLOptions options, Difference resultSet) {
        DDL ddl = null;
        if ((resultSet.isMap() || resultSet.isLeaf()) && SystemObject.class.isAssignableFrom(resultSet.getDifferenceClass())) {
            ddl = this.processResultSet(options, resultSet);
        } else if (resultSet.isList()) {
            for (Difference difference : resultSet.getChildren()) {
                ddl = this.append(ddl, this.processResultSet(options, difference));
            }
        } else {
            DBLog.getLogger(this).warning("unexpected Difference type for DDL");
        }
        return this.finish(options, ddl);
    }

    private DDL<T> processResultSet(DDLOptions options, Difference rs) {
        DDL<T> ddl = null;
        if (!rs.isSame()) {
            SystemObject updated = (SystemObject)rs.getUpdatedObject();
            SystemObject original = (SystemObject)rs.getOriginalObject();
            if (updated == null) {
                ddl = this.getDeleteDDLImpl(options, original);
            } else if (original == null) {
                ddl = this.getCreateDDLImpl(options, updated);
            } else {
                ddl = this.getUpdateDDLImpl(DDLOptions.copyForUpdate(options, rs), rs);
                if (ddl == null || ddl.size() == 0) {
                    throw UnsupportedDDLException.updateNotSupported(updated);
                }
            }
        }
        return ddl;
    }

    protected abstract DDL<T> getUpdateDDLImpl(DDLOptions var1, Difference var2);

    protected DDL<T> finish(DDLOptions options, DDL<T> ddl) {
        if (ddl != null && options.isIncludePrompts()) {
            return ddl.copyWithPrompts();
        }
        return ddl == null ? new DDL() : ddl;
    }

    protected DDL append(DDL ddl1, DDL ddl2) {
        if (ddl1 == null) {
            return ddl2;
        }
        if (ddl2 != null) {
            ddl1.append(ddl2);
        }
        return ddl1;
    }

    @Deprecated
    public final Ddl getCreateDDL(SchemaObject obj, boolean replace, boolean cascade) {
        return this.getCreateDDL(new DDLOptions(replace, cascade), obj).convertToLegacy();
    }

    @Deprecated
    public final Ddl getCreateDDL(SchemaObject[] objects, boolean replace, boolean cascade) {
        return this.getCreateDDL(new DDLOptions(replace, cascade), objects).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(SchemaObject object, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(true, cascade), object).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(SchemaObject[] objects, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(true, cascade), objects).convertToLegacy();
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(SchemaObject oldObject, SchemaObject newObject) {
        return this.getUpdateDDL(new SchemaObject[]{oldObject}, new SchemaObject[]{newObject});
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(SchemaObject[] oldObjects, SchemaObject[] newObjects) {
        Difference rs = this.getProvider().getDiffEngine().difference(oldObjects, newObjects);
        return this.getUpdateDDL(rs, false, false);
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(Difference resultSet, boolean replace, boolean cascade) {
        return this.getUpdateDDL(new DDLOptions(replace, cascade), resultSet).convertToLegacyArray();
    }

    @Deprecated
    public final Ddl getCreateDDL(Schema schema) {
        return this.getCreateDDL(new DDLOptions(), schema).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(Schema schema, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(false, cascade), schema).convertToLegacy();
    }
}

