/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

class BuildableDBObjectDiffer
extends DBObjectDiffer {
    private final PropertyHelper m_helper = new PropertyHelper();
    private final DiffEngine m_internalRefDerivedPropertyDelegate;

    BuildableDBObjectDiffer() {
        this(null, null);
    }

    BuildableDBObjectDiffer(DiffEngine internalRefDelegate, DiffEngine internalRefDerivedPropertyDelegate) {
        super(internalRefDelegate);
        this.m_internalRefDerivedPropertyDelegate = internalRefDerivedPropertyDelegate;
    }

    @Override
    protected ResultSet diffProperty(Object a, Object b, ResultSet r, DiffContext c, PropertyInfo prop, Map<String, PropertyInfo> beanProps) {
        ResultSet retval;
        String propertyName = prop.getPropertyName();
        boolean derived = prop.isDerived();
        AbstractBuildableObject aObj = (AbstractBuildableObject)a;
        AbstractBuildableObject bObj = (AbstractBuildableObject)b;
        boolean lazy = false;
        Boolean same = null;
        if (a != null || b != null) {
            DBObjectID bID;
            boolean aNeedsBuilding = DBUtil.needsBuilding(aObj, propertyName);
            boolean bNeedsBuilding = DBUtil.needsBuilding(bObj, propertyName);
            DBObjectID aID = aObj == null ? null : aObj.getID();
            DBObjectID dBObjectID = bID = bObj == null ? null : bObj.getID();
            if (this.isTempCopy(aID, bID) && aNeedsBuilding || this.isTempCopy(bID, aID) && bNeedsBuilding) {
                lazy = true;
                if (!derived) {
                    same = true;
                }
            } else if (!c.isTreeRequired() && (aNeedsBuilding || bNeedsBuilding)) {
                lazy = true;
            }
        }
        if (lazy) {
            retval = new LazyResultSet(r, aObj, bObj, prop, c);
            if (same != null) {
                retval.setSame(same);
            }
        } else {
            retval = super.diffProperty(a, b, r, c, prop, beanProps);
            if (!retval.isSame()) {
                String otherProp;
                if (derived) {
                    if (this.isSourcePropertySame(aObj, bObj, prop, r)) {
                        retval.setSame(true);
                    }
                } else if (this.m_internalRefDerivedPropertyDelegate != null && this.hasRenames(aObj, bObj, otherProp = this.getSourceInternalReferenceProperty(prop))) {
                    Boolean dvalSame = null;
                    for (PropertyInfo pi : beanProps.values()) {
                        Difference dvalDiff;
                        if (!pi.isDerived() || !propertyName.equals(pi.getDerivedSourceProperty())) continue;
                        Object dval1 = pi.getPropertyValue(a);
                        Object dval2 = pi.getPropertyValue(b);
                        if (dval1 == null || dval2 == null || !Boolean.FALSE.equals(dvalSame = Boolean.valueOf((dvalDiff = this.m_internalRefDerivedPropertyDelegate.difference(dval1, dval2)).isSame()))) continue;
                        dvalDiff.print(DBLog.getLogger(this), Level.FINE);
                        break;
                    }
                    if (Boolean.TRUE.equals(dvalSame)) {
                        retval.setSame(true);
                    }
                }
            }
        }
        return retval;
    }

    protected boolean isSourcePropertySame(AbstractBuildableObject a, AbstractBuildableObject b, PropertyInfo derivedPropertyInfo, ResultSet objDiff) {
        Difference sourcePropDiff = objDiff.getChildDifference(derivedPropertyInfo.getDerivedSourceProperty());
        return sourcePropDiff != null && sourcePropDiff.isSame();
    }

    private String getSourceInternalReferenceProperty(PropertyInfo prop) {
        String propName = prop.getPropertyName();
        String retval = "expressionSource".equals(propName) || "checkCondition".equals(propName) || "virtualExpressionSource".equals(propName) ? "columns" : null;
        return retval;
    }

    private boolean hasRenames(DBObject a, DBObject b, String propPath) {
        boolean retval = false;
        if (propPath != null) {
            SystemObject aSysObj = DBUtil.getSystemObject(a);
            SystemObject bSysObj = DBUtil.getSystemObject(b);
            if (aSysObj != null && bSysObj != null) {
                if (TemporaryObjectID.getOriginalObject(aSysObj) == bSysObj) {
                    retval = this.hasRenames(aSysObj, propPath);
                } else if (TemporaryObjectID.getOriginalObject(bSysObj) == aSysObj) {
                    retval = this.hasRenames(bSysObj, propPath);
                }
            }
        }
        return retval;
    }

    private boolean hasRenames(DBObject obj, String propPath) {
        boolean retval = false;
        Object val = this.m_helper.getPropertyValue(obj, propPath);
        if (val instanceof DBObject) {
            retval = this.isRenamed((DBObject)val);
        } else if (val instanceof DBObject[]) {
            for (DBObject kid : (DBObject[])val) {
                if (!this.isRenamed(kid)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    private boolean isRenamed(DBObject obj) {
        DBObject orig = TemporaryObjectID.getOriginalObject(obj);
        return orig != null && ModelUtil.areDifferent((Object)obj.getName(), (Object)orig.getName());
    }

    protected boolean isTempCopy(DBObjectID id1, DBObjectID id2) {
        DBObjectID origID;
        DBObject orig;
        boolean retval = false;
        if (id1 instanceof TemporaryObjectID && (orig = ((TemporaryObjectID)id1).getOriginalObject()) != null && (origID = orig.getID()) != null) {
            retval = origID.equals(id2, true) || this.isTempCopy(origID, id2);
        }
        return retval;
    }

    private static String getResultSetType(PropertyInfo prop) {
        Class<?> propClz = prop.getPropertyClass();
        String retval = propClz != null && propClz.isArray() ? "LIST" : (propClz != null && Copyable.class.isAssignableFrom(propClz) || Map.class.isAssignableFrom(propClz) ? "MAP" : "LEAF");
        return retval;
    }

    static boolean isLazyDifference(Difference diff) {
        return diff instanceof LazyResultSet;
    }

    private class LazyResultSet
    extends ResultSet {
        private static final String LAZY = "<LAZY>";
        private DiffContext m_diffContext;
        private PropertyInfo m_prop;
        private AbstractBuildableObject m_parentA;
        private AbstractBuildableObject m_parentB;
        private Holder<Object> m_lazyA;
        private Holder<Object> m_lazyB;
        private Boolean m_lazySame;
        private ResultSet m_lazyDiff;

        private LazyResultSet() {
        }

        LazyResultSet(ResultSet parent, AbstractBuildableObject parentA, AbstractBuildableObject parentB, PropertyInfo prop, DiffContext dc) {
            super(parent, null, null, prop.getPropertyName(), BuildableDBObjectDiffer.getResultSetType(prop));
            this.m_prop = prop;
            this.m_parentA = parentA;
            this.m_parentB = parentB;
            this.m_diffContext = dc;
            String propName = prop.getPropertyName();
            if (!DBUtil.needsBuilding(parentA, propName)) {
                this.a();
            }
            if (!DBUtil.needsBuilding(parentB, propName)) {
                this.b();
            }
        }

        @Override
        public boolean isLoaded() {
            return this.m_lazyDiff != null;
        }

        private boolean stillNeedsBuilding(AbstractBuildableObject obj) {
            return obj != null && DBUtil.needsBuilding(obj, this.m_prop.getPropertyName());
        }

        private ResultSet getLazyDiff(boolean force) {
            if (this.m_lazyDiff == null && this.m_parentA != null && this.m_parentB != null) {
                boolean doit = true;
                if (!force) {
                    boolean bl = doit = !this.stillNeedsBuilding(this.m_parentA) && !this.stillNeedsBuilding(this.m_parentB);
                }
                if (doit) {
                    Object a = this.a();
                    Object b = this.b();
                    if (a != null || b != null) {
                        this.m_lazyDiff = this.m_diffContext.getEngine().diff(a, b).getResult();
                        this.m_lazyDiff.setName(this.m_prop.getPropertyName());
                        this.m_lazyDiff.setParent(this.getParent());
                    }
                }
            }
            return this.m_lazyDiff;
        }

        @Override
        public boolean isSame() {
            boolean retval;
            if (this.m_lazySame != null) {
                retval = this.m_lazySame;
            } else {
                ResultSet diff = this.getLazyDiff(false);
                if (diff != null) {
                    this.m_lazySame = diff.isSame();
                    retval = this.m_lazySame;
                } else {
                    Boolean guess = this.guessIsSame();
                    if (guess != null) {
                        retval = guess;
                    } else {
                        ResultSet diff2 = this.getLazyDiff(true);
                        this.m_lazySame = diff2 == null ? true : diff2.isSame();
                        retval = this.m_lazySame;
                    }
                }
            }
            return retval;
        }

        private Boolean guessIsSame() {
            Boolean retval = null;
            ResultSet parentDiff = this.getParent();
            if (parentDiff != null && this.m_prop.isDerived()) {
                Difference sourcePropDiff = parentDiff.getChildDifference(this.m_prop.getDerivedSourceProperty(), true);
                retval = sourcePropDiff == null;
            }
            return retval;
        }

        @Override
        public void setSame(boolean same) {
            this.m_lazySame = same;
        }

        @Override
        public Collection<ResultSet> getChildren() {
            ResultSet diff;
            Collection<ResultSet> retval = null;
            if (!"LEAF".equals(this.getType()) && (diff = this.getLazyDiff(!Boolean.TRUE.equals(this.m_lazySame))) != null) {
                retval = diff.getChildren();
            }
            return retval == null ? Collections.emptyList() : retval;
        }

        @Override
        public Object a() {
            if (this.m_lazyA == null) {
                this.m_lazyA = new Holder();
                if (this.m_parentA != null) {
                    this.m_lazyA.set(BuildableDBObjectDiffer.this.m_helper.getPropertyValue(this.m_parentA, this.m_prop.getPropertyName()));
                }
            }
            return this.m_lazyA.get();
        }

        @Override
        public Object b() {
            if (this.m_lazyB == null) {
                this.m_lazyB = new Holder();
                if (this.m_parentB != null) {
                    this.m_lazyB.set(BuildableDBObjectDiffer.this.m_helper.getPropertyValue(this.m_parentB, this.m_prop.getPropertyName()));
                }
            }
            return this.m_lazyB.get();
        }

        @Override
        protected String getOriginalObjectForLog() {
            return this.m_lazyA == null ? LAZY : super.getOriginalObjectForLog();
        }

        @Override
        protected String getUpdatedObjectForLog() {
            return this.m_lazyB == null ? LAZY : super.getUpdatedObjectForLog();
        }

        @Override
        protected Collection<? extends Difference> getChildrenForLog() {
            return this.m_lazyDiff == null ? Collections.emptyList() : super.getChildrenForLog();
        }

        @Override
        protected String getSameTextForLog() {
            return this.m_lazySame == null ? LAZY : super.getSameTextForLog();
        }

        @Override
        protected PropertyInfo getPropertyInfo() {
            return this.m_prop;
        }

        @Override
        public Class getResultSetClass() {
            Object b;
            Object a;
            Class<?> retval = null;
            if (this.m_lazyA != null && (a = this.m_lazyA.get()) != null) {
                retval = a.getClass();
            }
            if (retval == null && this.m_lazyB != null && (b = this.m_lazyB.get()) != null) {
                retval = b.getClass();
            }
            if (retval == null && (retval = this.m_prop.getPropertyClass()) == null) {
                retval = super.getResultSetClass();
            }
            return retval;
        }

        @Override
        public LazyResultSet copyTo(Object target) {
            LazyResultSet copy = target == null ? new LazyResultSet() : (LazyResultSet)target;
            super.copyToImpl(copy);
            copy.m_lazyA = this.m_lazyA;
            copy.m_lazyB = this.m_lazyB;
            copy.m_parentA = this.m_parentA;
            copy.m_parentB = this.m_parentB;
            copy.m_prop = this.m_prop;
            copy.m_lazySame = this.m_lazySame;
            copy.m_lazyDiff = this.m_lazyDiff == null ? null : this.m_lazyDiff.copyTo(null);
            copy.m_diffContext = this.m_diffContext;
            return copy;
        }

        @Override
        protected boolean hasChildren() {
            return this.m_lazyDiff == null ? !"LEAF".equals(this.getType()) : this.m_lazyDiff.hasChildren();
        }
    }
}

