/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.BuildableDBObjectDiffer;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class DifferenceApplier {
    private List<DBObjectChange> m_events;
    private boolean m_applyToB;
    private DBObjectProvider m_pro;

    public DifferenceApplier(DBObjectProvider pro) {
        this(pro, false);
    }

    public DifferenceApplier(DBObjectProvider pro, boolean applyToB) {
        this.m_pro = pro;
        this.m_applyToB = applyToB;
    }

    private Object getOriginalObject(Difference rs) {
        return this.m_applyToB ? rs.getUpdatedObject() : rs.getOriginalObject();
    }

    private Object getUpdatedObject(Difference rs) {
        return this.m_applyToB ? rs.getOriginalObject() : rs.getUpdatedObject();
    }

    private Integer getIndexOfUpdatedObject(Difference rs) {
        return this.m_applyToB ? rs.getIndexOfOriginalObject() : rs.getIndexOfUpdatedObject();
    }

    public final void apply(SystemObject original, SystemObject updated) {
        this.apply(this.m_pro.getDiffEngine().difference(original, updated));
    }

    public final void apply(Difference diff) {
        this.apply(diff, null);
    }

    public final void apply(Difference rs, SystemObject copyOfOriginal) {
        this.m_events = new ArrayList<DBObjectChange>();
        if (!rs.isSame()) {
            if (rs.isList()) {
                Collection<? extends Difference> change = rs.getChildren();
                for (Difference difference : change) {
                    if (!difference.isModified() || !difference.isMap() || difference.isSame()) continue;
                    this.applyObjectDiff(difference, copyOfOriginal);
                }
            } else if (rs.isMap()) {
                this.applyObjectDiff(rs, copyOfOriginal);
            }
        }
    }

    private void applyObjectDiff(Difference objDiff, DBObject copyOfOriginal) {
        this.applyProperties(objDiff, null);
        this.m_events.add(new ResultSetChange(objDiff, copyOfOriginal, this.m_pro));
    }

    private void applyProperties(Difference objDiff, Difference parentDiff) {
        Object obj = this.getOriginalObject(objDiff);
        if (obj instanceof DBObject) {
            Runnable r = () -> this.applyPropertiesImpl(objDiff, parentDiff);
            DBUtil.invokeCompoundChange((DBObject)obj, r, true);
        } else {
            this.applyPropertiesImpl(objDiff, parentDiff);
        }
    }

    private final void applyPropertiesImpl(Difference rs, Difference parent) {
        block13: {
            Object original = this.getOriginalObject(rs);
            if (original == null) break block13;
            Class<?> objClass = rs.getDifferenceClass();
            if (Map.class.isAssignableFrom(objClass)) {
                for (Difference difference : rs.getChildren()) {
                    Holder<?> newPropValue;
                    if (!this.shouldApplyChildDiff(difference) || (newPropValue = this.getAppliedPropertyValue(difference, rs, parent)) == null) continue;
                    ((Map)original).put(difference.getPropertyName(), newPropValue.get());
                }
            } else {
                TreeMap<PropertyInfo, Difference> process = new TreeMap<PropertyInfo, Difference>();
                Map<String, PropertyInfo> map = PropertyHelper.getPropertyInfos(original.getClass(), null, null);
                Collection<? extends Difference> changed = rs.getChildren();
                for (Difference difference : changed) {
                    String propertyName = difference.getPropertyName();
                    if (!this.shouldApplyChildDiff(difference)) continue;
                    PropertyInfo info = map.get(propertyName);
                    if (info == null) {
                        throw new IllegalStateException("don't have a property info for property " + propertyName + " on object " + objClass);
                    }
                    process.put(info, difference);
                }
                for (PropertyInfo propertyInfo : process.keySet()) {
                    Difference change = (Difference)process.get(propertyInfo);
                    Object value = null;
                    boolean setProp = false;
                    if (change.isList()) {
                        boolean rsIsDBObject = DBObject.class.isAssignableFrom(rs.getDifferenceClass());
                        value = this.applyList(change, rsIsDBObject ? rs : parent);
                        setProp = true;
                    } else if ("schema".equals(propertyInfo.getPropertyName()) && SchemaObject.class.isAssignableFrom(rs.getDifferenceClass())) {
                        value = this.getUpdatedObject(change);
                        setProp = true;
                    } else {
                        Holder<?> newPropValue = this.getAppliedPropertyValue(change, rs, parent);
                        if (newPropValue != null) {
                            value = newPropValue.get();
                            setProp = true;
                        }
                    }
                    if (!setProp) continue;
                    try {
                        propertyInfo.setPropertyValue(original, value);
                    }
                    catch (Exception e) {
                        DBLog.logStackTrace("Error applying property value", e);
                    }
                }
            }
        }
    }

    private boolean shouldApplyChildDiff(Difference change) {
        boolean retval = BuildableDBObjectDiffer.isLazyDifference(change) ? false : !change.isSame();
        return retval;
    }

    private Holder<?> getAppliedPropertyValue(Difference change, Difference rs, Difference parent) {
        boolean setProp = true;
        Object newPropValue = this.getUpdatedObject(change);
        if (change.isSame()) {
            setProp = false;
        } else if (newPropValue != null) {
            if (change.isList()) {
                newPropValue = this.applyList(change, parent);
            } else {
                Object originalPropValue = this.getOriginalObject(change);
                if (originalPropValue == null || originalPropValue.getClass() != newPropValue.getClass()) {
                    Object parentObj;
                    Object object = parentObj = parent == null ? null : this.getOriginalObject(parent);
                    if (newPropValue instanceof ChildDBObject && this.m_pro != null && parentObj instanceof DBObject) {
                        ChildDBObject newChildObject = (ChildDBObject)newPropValue;
                        newPropValue = this.m_pro.getObjectFactory().newObject(newChildObject.getClass(), (DBObject)parentObj, false, false);
                        ((ChildDBObject)newPropValue).setID(null);
                        newChildObject.copyTo((DBObject)((ChildDBObject)newPropValue), new TemporaryObjectID.CopyBackPolicy());
                    } else if (newPropValue instanceof Copyable) {
                        newPropValue = ((Copyable)newPropValue).copyTo(null);
                    }
                } else if (change.isMap() && (newPropValue instanceof DBObject || "properties".equals(change.getPropertyName()) && this.getUpdatedObject(rs) instanceof DBObject)) {
                    setProp = false;
                    this.applyProperties(change, rs);
                }
            }
        }
        return setProp ? new Holder(newPropValue) : null;
    }

    private final Object[] applyList(Difference listDiff, Difference parent) {
        ArrayList<Object> value = null;
        ArrayList<? extends Difference> changes = new ArrayList<Difference>(listDiff.getChildren());
        if (changes != null) {
            Collections.sort(changes, new Comparator<Difference>(){

                @Override
                public int compare(Difference o1, Difference o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -100;
                    }
                    if (o2 == null) {
                        return 100;
                    }
                    return DifferenceApplier.this.getIndexOfUpdatedObject(o1).compareTo(DifferenceApplier.this.getIndexOfUpdatedObject(o2));
                }
            });
            value = new ArrayList<Object>(changes.size());
            for (Difference difference : changes) {
                Holder<?> newChild = this.getAppliedPropertyValue(difference, listDiff, parent);
                if (newChild == null) {
                    value.add(this.getOriginalObject(difference));
                    continue;
                }
                Object newChildValue = newChild.get();
                if (newChildValue == null) continue;
                value.add(newChildValue);
            }
        }
        Object[] retval = value != null && value.size() > 0 ? value.toArray((Object[])Array.newInstance(listDiff.getDifferenceClass().getComponentType(), value.size())) : null;
        return retval;
    }

    public SystemObject getCopyOfOrigWithDiffApplied(Difference diff) {
        SystemObject retval = null;
        SystemObject orig = (SystemObject)diff.getOriginalObject();
        SystemObject upd = (SystemObject)diff.getUpdatedObject();
        if (orig != null) {
            if (this.m_pro != null) {
                this.m_pro.getObjectFactory().ensureID(orig, true, true);
            }
            Map<DBObjectID, DBObjectID> origToUpdIDMap = DBUtil.getTemporaryIDMap(upd);
            SameTempIDPolicy policy = new SameTempIDPolicy(origToUpdIDMap);
            orig.copyTo(null, policy);
            Difference diffToApply = (Difference)diff.copyTo(null);
            this.switchOriginalWithCopy(diffToApply, policy.m_ourTemps);
            this.apply(diffToApply);
            retval = (SystemObject)diffToApply.getOriginalObject();
            DBUtil.replaceAllIDs(retval, policy.m_ourTemps);
        }
        if (retval == null) {
            retval = upd;
        }
        return retval;
    }

    private void switchOriginalWithCopy(Difference diff, Map<DBObjectID, TemporaryObjectID> idMap) {
        Object newOrigMap;
        Object parOrig;
        Difference difference;
        String prop;
        Object orig = diff.getOriginalObject();
        if (orig instanceof DBObject) {
            DBObject tempCopy;
            TemporaryObjectID temporaryObjectID;
            DBObjectID origID = ((DBObject)orig).getID();
            if (origID != null && (temporaryObjectID = idMap.get(origID)) != null && (tempCopy = temporaryObjectID.getDBObject()) != null) {
                diff.setObject(diff.getOriginalContributor(), tempCopy);
            }
        } else if (orig instanceof Map && ModelUtil.hasLength((String)(prop = diff.getPropertyName())) && (difference = diff.getParent()) != null && (parOrig = difference.getOriginalObject()) instanceof DBObject && (newOrigMap = ((DBObject)parOrig).getProperty(prop)) instanceof Map) {
            diff.setObject(diff.getOriginalContributor(), newOrigMap);
        }
        for (Difference difference2 : diff.getChildren()) {
            this.switchOriginalWithCopy(difference2, idMap);
        }
    }

    @Deprecated
    public DBObjectChange[] fireEvents() {
        return this.m_events == null ? new DBObjectChange[]{} : this.m_events.toArray(new DBObjectChange[this.m_events.size()]);
    }

    public Iterable<DBObjectChange> getEvents() {
        return this.m_events;
    }

    private DBObjectChange fireLazyChangeEventImpl(SystemObject obj, SystemObject copyOfOriginal) {
        ResultSetChange change = new ResultSetChange(obj, (DBObject)copyOfOriginal, this.m_pro);
        obj.fireObjectUpdated(change);
        return change;
    }

    public static DBObjectChange fireLazyChangeEvent(SystemObject obj, SystemObject copyOfOriginal, DBObjectProvider pro) {
        DifferenceApplier app = new DifferenceApplier(pro);
        return app.fireLazyChangeEventImpl(obj, copyOfOriginal);
    }

    private static class SameTempIDPolicy
    extends IDPolicy.SameIDPolicy {
        private final Map<DBObjectID, TemporaryObjectID> m_ourTemps = new DBObjectIDMap<TemporaryObjectID>(true);
        private final Map<DBObjectID, DBObjectID> m_origToUpdIDMap;

        public SameTempIDPolicy(Map<DBObjectID, DBObjectID> origToUpdIDMap) {
            this.m_origToUpdIDMap = origToUpdIDMap;
        }

        @Override
        protected DBObjectID getNewID(DBObject original, DBObject copy) {
            TemporaryObjectID tempID = (TemporaryObjectID)TemporaryObjectID.createID(copy, original);
            DBObjectID origID = super.getNewID(original, copy);
            if (origID != null) {
                this.m_ourTemps.put(origID, tempID);
                DBObjectID fromUpd = this.m_origToUpdIDMap.get(origID);
                if (fromUpd != null) {
                    this.m_ourTemps.put(fromUpd, tempID);
                }
            }
            return origID;
        }
    }

    private final class ResultSetChange
    extends DBObjectChange {
        private DiffEngine m_diffEngine;
        private Difference m_diff;
        private DBObject m_lazyDiffObj;
        private final Collection<String> m_loaded;
        private final List<DBObject> m_objectsAdded;
        private final List<DBObject> m_objectsRemoved;
        private final Map<DBObject, DBObjectChange> m_objectsChanged;
        private Collection<String> m_allChangedProps;
        private boolean m_fullyLoaded;
        private final PropertyChangeMap m_propsChanged;

        private ResultSetChange(Difference rs, DBObject copyOfOriginal, DBObjectProvider pro) {
            super((DBObject)DifferenceApplier.this.getOriginalObject(rs), pro);
            this.m_loaded = new CopyOnWriteArraySet<String>();
            this.m_objectsAdded = new ArrayList<DBObject>();
            this.m_objectsRemoved = new ArrayList<DBObject>();
            this.m_objectsChanged = new IdentityHashMap<DBObject, DBObjectChange>();
            this.m_propsChanged = new PropertyChangeMap();
            this.m_diff = rs;
            this.m_lazyDiffObj = copyOfOriginal;
        }

        private ResultSetChange(DBObject toRebuild, DBObject copyOfOriginal, DBObjectProvider pro) {
            super(toRebuild, pro);
            this.m_loaded = new CopyOnWriteArraySet<String>();
            this.m_objectsAdded = new ArrayList<DBObject>();
            this.m_objectsRemoved = new ArrayList<DBObject>();
            this.m_objectsChanged = new IdentityHashMap<DBObject, DBObjectChange>();
            this.m_propsChanged = new PropertyChangeMap();
            this.m_lazyDiffObj = copyOfOriginal;
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableList(this.m_objectsAdded);
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableMap(this.m_objectsChanged);
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            this.ensureChildrenLoaded();
            return Collections.unmodifiableList(this.m_objectsRemoved);
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            return this.m_propsChanged;
        }

        @Override
        public Collection<String> getAllChangedProperties() {
            if (this.m_allChangedProps == null) {
                this.m_allChangedProps = new ArrayList<String>();
                for (Difference difference : this.getDifference().getChildren()) {
                    if (difference.isSame()) continue;
                    this.m_allChangedProps.add(difference.getPropertyName());
                }
            }
            return this.m_allChangedProps;
        }

        private Difference getDifference() {
            if (this.m_diff == null) {
                this.m_diff = this.getDiffEngine().difference(this.m_lazyDiffObj, this.getDBObject());
            }
            return this.m_diff;
        }

        private DiffEngine getDiffEngine() {
            if (this.m_diffEngine == null) {
                this.m_diffEngine = GenericDiffEngine.getDiffEngine(true);
            }
            return this.m_diffEngine;
        }

        private void ensureChildrenLoaded() {
            if (!this.m_fullyLoaded) {
                for (Difference difference : this.getDifference().getChildren()) {
                    this.loadDifferenceImpl(difference);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void loadDifferenceImpl(Difference diff) {
            String propName = diff.getPropertyName();
            if (!this.m_loaded.contains(propName) && !diff.isSame()) {
                boolean propChange = true;
                Class<?> diffClz = diff.getDifferenceClass();
                if (diff.isList()) {
                    if (diffClz.isArray() && DBObject.class.isAssignableFrom(diffClz.getComponentType())) {
                        for (Difference difference : diff.getChildren()) {
                            if (!difference.isSame()) {
                                DBObject updated = (DBObject)DifferenceApplier.this.getUpdatedObject(difference);
                                DBObject original = (DBObject)DifferenceApplier.this.getOriginalObject(difference);
                                if (updated == null && original != null) {
                                    this.m_objectsRemoved.add(original);
                                    continue;
                                }
                                if (updated != null && original == null) {
                                    DBObject realAdded;
                                    DBObject added = updated;
                                    DBObject originalParent = this.getDBObject();
                                    if (updated.getParent() != originalParent && (realAdded = this.findMatchingChild(updated, originalParent, kid -> DBUtil.areNamesAndTypesEqual(updated, kid))) != null) {
                                        added = realAdded;
                                    }
                                    this.m_objectsAdded.add(added);
                                    continue;
                                }
                                this.addChildObjectChange(difference);
                                continue;
                            }
                            int indexA = difference.getIndexOfOriginalObject();
                            int indexB = difference.getIndexOfUpdatedObject();
                            if (indexA < 0 || indexB < 0 || indexA == indexB) continue;
                            this.addChildObjectChange(difference);
                        }
                    }
                } else if (diff.isMap()) {
                    if ("properties".equals(propName)) {
                        propChange = false;
                        for (Difference difference : diff.getChildren()) {
                            this.loadDifferenceImpl(difference);
                        }
                    } else if (DBObject.class.isAssignableFrom(diffClz) && diff.isModified()) {
                        this.addChildObjectChange(diff);
                    }
                }
                if (propChange) {
                    void var6_11;
                    final DBObject obj = this.getDBObject();
                    final PropertyInfo info = diff.getPropertyInfo();
                    if (info != null && !"schema".equals(propName) && DBObject.class.isAssignableFrom(DBUtil.decodeArrayClass(diffClz)) && this.m_lazyDiffObj != null) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(obj, propName, null, null){

                            @Override
                            public Object getNewValue() {
                                return info.getPropertyValue(obj);
                            }

                            @Override
                            public Object getOldValue() {
                                return info.getPropertyValue(ResultSetChange.this.m_lazyDiffObj);
                            }
                        };
                    } else {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getDBObject(), propName, DifferenceApplier.this.getOriginalObject(diff), DifferenceApplier.this.getUpdatedObject(diff));
                    }
                    this.m_propsChanged.m_delegate.put(propName, var6_11);
                }
            }
            this.m_loaded.add(propName);
        }

        private DBObject findMatchingChild(DBObject child, DBObject copyOfParent, Predicate<DBObject> predicate) {
            String prop;
            DBObject retval = null;
            if (copyOfParent != null && (prop = DBUtil.getParentProperty(child)) != null && !DBUtil.needsBuilding(copyOfParent, prop)) {
                Object copyVal = copyOfParent.getProperty(prop);
                if (copyVal instanceof DBObject) {
                    retval = (DBObject)copyVal;
                } else if (copyVal instanceof DBObject[]) {
                    for (DBObject copyChild : (DBObject[])copyVal) {
                        if (!predicate.test(copyChild)) continue;
                        retval = copyChild;
                        break;
                    }
                }
            }
            return retval;
        }

        private void addChildObjectChange(Difference childDiff) {
            DBObject originalChild = (DBObject)DifferenceApplier.this.getOriginalObject(childDiff);
            DBObject copyOfOriginalChild = null;
            DBObjectID lookFor = originalChild.getID();
            if (lookFor instanceof BaseObjectID) {
                copyOfOriginalChild = this.findMatchingChild(originalChild, this.m_lazyDiffObj, child -> lookFor.equals(child.getID(), true));
            }
            this.m_objectsChanged.put(originalChild, new ResultSetChange(childDiff, copyOfOriginalChild, this.getProvider()));
        }

        @Override
        public boolean hasNameChanged() {
            if (this.m_diff == null) {
                DBObject obj = this.getDBObject();
                return !DBUtil.areNamesAndTypesEqual(this.m_lazyDiffObj, obj);
            }
            return super.hasNameChanged();
        }

        private class PropertyChangeMap
        extends AbstractMap<String, PropertyChangeEvent> {
            private Map<String, PropertyChangeEvent> m_delegate = new ConcurrentHashMap<String, PropertyChangeEvent>();

            private PropertyChangeMap() {
            }

            @Override
            public Set<Map.Entry<String, PropertyChangeEvent>> entrySet() {
                ResultSetChange.this.ensureChildrenLoaded();
                return this.m_delegate.entrySet();
            }

            @Override
            public PropertyChangeEvent get(Object key) {
                PropertyChangeEvent retval = this.m_delegate.get(key);
                if (key instanceof String && retval == null && !ResultSetChange.this.m_loaded.contains(key) && !ResultSetChange.this.m_fullyLoaded) {
                    Difference propDiff;
                    String propName = (String)key;
                    if (ResultSetChange.this.m_diff == null && ResultSetChange.this.m_lazyDiffObj != null && !"properties".equals(propName)) {
                        Object oldVal = ResultSetChange.this.m_lazyDiffObj.getProperty(propName);
                        Object newVal = ResultSetChange.this.getDBObject().getProperty(propName);
                        if (oldVal == null && newVal == null) {
                            ResultSet rs = new ResultSet(null, null, null, propName, "MAP");
                            rs.setSame(true);
                            propDiff = rs;
                        } else {
                            ResultSet rs = ResultSetChange.this.getDiffEngine().diff(oldVal, newVal).getResult();
                            rs.setName(propName);
                            propDiff = rs;
                        }
                    } else {
                        propDiff = ResultSetChange.this.m_diff.getChildDifference(propName);
                    }
                    if (propDiff != null) {
                        ResultSetChange.this.loadDifferenceImpl(propDiff);
                        retval = this.m_delegate.get(key);
                    }
                }
                return retval;
            }

            @Override
            public Set<String> keySet() {
                Set<String> retval;
                if (ResultSetChange.this.m_fullyLoaded) {
                    retval = super.keySet();
                } else {
                    retval = new HashSet();
                    this.addChangedProperties(ResultSetChange.this.getDifference(), retval);
                }
                return retval;
            }

            private void addChangedProperties(Difference diff, Collection<String> propNames) {
                for (Difference difference : diff.getChildren()) {
                    if (difference.isSame()) continue;
                    String propName = difference.getPropertyName();
                    if ("properties".equals(propName)) {
                        this.addChangedProperties(difference, propNames);
                        continue;
                    }
                    propNames.add(propName);
                }
            }

            @Override
            public boolean containsKey(Object key) {
                return this.keySet().contains(key);
            }
        }
    }
}

