/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.event;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;

public abstract class DBObjectPropertyListener
extends DBObjectListener {
    private final String[] m_properties;

    public DBObjectPropertyListener(String ... properties) {
        this.m_properties = properties;
        if (this.m_properties == null || this.m_properties.length == 0) {
            throw new IllegalArgumentException("Must specify properties to listen for");
        }
    }

    @Override
    public final void objectUpdated(DBObjectChange change) {
        DBObject obj = change.getDBObject();
        for (String prop : this.m_properties) {
            String[] path = Property.getProperties(prop);
            this.objectUpdatedImpl(obj, prop, change, path);
        }
    }

    private void objectUpdatedImpl(DBObject objectListenedTo, String pathListenedTo, DBObjectChange change, String[] path) {
        Collection<DBObjectChange> childChanges;
        if (path.length == 1) {
            PropertyChangeEvent pce = change.getPropertyChange(path[0]);
            if (pce != null) {
                this.propertyChanged(objectListenedTo, pathListenedTo, pce);
            }
        } else if (path.length > 1 && !(childChanges = change.getOwnedObjectsUpdated(path[0])).isEmpty()) {
            String[] remainingPath = new String[path.length - 1];
            System.arraycopy(path, 1, remainingPath, 0, remainingPath.length);
            for (DBObjectChange childChange : childChanges) {
                this.objectUpdatedImpl(objectListenedTo, pathListenedTo, childChange, remainingPath);
            }
        }
    }

    protected abstract void propertyChanged(DBObject var1, String var2, PropertyChangeEvent var3);
}

