/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;

public class MaterializedView
extends Table
implements SQLQueryOwner {
    public static final String TYPE = "MATERIALIZED VIEW";

    public MaterializedView() {
        this((String)null, (Schema)null);
    }

    public MaterializedView(String name, Schema schema) {
        super(name, schema);
        this.setUpdatable(false);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public SQLQuery getSQLQuery() {
        return (SQLQuery)this.getProperty("SQLQuery");
    }

    @Override
    public void setSQLQuery(SQLQuery query) {
        this.setProperty("SQLQuery", query);
    }

    @Override
    @Derived(value="SQLQuery")
    public Column[] getColumns() {
        return super.getColumns();
    }

    @Internal
    public String getViewText() {
        SQLQuery query = this.getSQLQuery();
        return query == null ? null : query.getSQLText().trim();
    }

    public void setUpdatable(boolean updatable) {
        this.setProperty("updatable", updatable);
    }

    public boolean isUpdatable() {
        return (Boolean)this.getProperty("updatable", false);
    }

    public void setQueryRewrite(Boolean queryRewrite) {
        this.setProperty("queryRewrite", queryRewrite);
    }

    public Boolean getQueryRewrite() {
        return (Boolean)this.getProperty("queryRewrite");
    }

    @Deprecated
    @Transient
    public void setRewrite(boolean rewrite) {
        this.setQueryRewrite(rewrite);
    }

    @Deprecated
    public boolean isRewrite() {
        return Boolean.TRUE.equals(this.getQueryRewrite());
    }

    public void setRewriteType(RewriteCapability rewriteType) {
        this.setProperty("rewriteType", (Object)rewriteType);
    }

    public RewriteCapability getRewriteType() {
        return (RewriteCapability)((Object)this.getProperty("rewriteType"));
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public void setRefreshMode(RefreshMode refreshMode) {
        this.setProperty("refreshMode", (Object)refreshMode);
    }

    public RefreshMode getRefreshMode() {
        RefreshMode mode = (RefreshMode)((Object)this.getProperty("refreshMode"));
        return mode;
    }

    public void setRefreshMethod(RefreshMethod refreshMethod) {
        if (DBUtil.isDeprecated(refreshMethod)) {
            this.setProperty("refreshMethod", null);
        } else {
            this.setProperty("refreshMethod", (Object)refreshMethod);
        }
    }

    public RefreshMethod getRefreshMethod() {
        return (RefreshMethod)((Object)this.getProperty("refreshMethod"));
    }

    public void setFastRefresh(FastRefreshable fastRefresh) {
        this.setProperty("fastRefresh", (Object)fastRefresh);
    }

    public FastRefreshable getFastRefresh() {
        return (FastRefreshable)((Object)this.getProperty("fastRefresh"));
    }

    public void setLastRefreshType(RefreshMethod lastRefreshType) {
        this.setProperty("lastRefreshType", (Object)lastRefreshType);
    }

    public RefreshMethod getLastRefreshType() {
        return (RefreshMethod)((Object)this.getProperty("lastRefreshType"));
    }

    public void setLastRefreshDate(Date lastRefreshDate) {
        this.setProperty("lastRefreshDate", lastRefreshDate);
    }

    public Date getLastRefreshDate() {
        return (Date)this.getProperty("lastRefreshDate");
    }

    public void setNextRefreshDate(Date nextRefreshDate) {
        this.setProperty("nextRefreshDate", nextRefreshDate);
    }

    public Date getNextRefreshDate() {
        return (Date)this.getProperty("nextRefreshDate");
    }

    @Deprecated
    @Transient
    public String getNextRefresh() {
        Date d = this.getNextRefreshDate();
        return d == null ? null : d.toString();
    }

    @Deprecated
    @Transient
    public void setNextRefresh(String nextStr) {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            this.setNextRefreshDate(fmt.parse(nextStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getInterval() {
        return (String)this.getProperty("interval");
    }

    public void setInterval(String interval) {
        this.setProperty("interval", interval);
    }

    public String getFirstRefresh() {
        return (String)this.getProperty("firstRefresh");
    }

    public void setFirstRefresh(String firstRefresh) {
        this.setProperty("firstRefresh", firstRefresh);
    }

    public void setStaleness(Staleness staleness) {
        this.setProperty("staleness", (Object)staleness);
    }

    public Staleness getStaleness() {
        return (Staleness)((Object)this.getProperty("staleness"));
    }

    public void setBuildType(BuildType buildType) {
        this.setProperty("buildType", (Object)buildType);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public BuildType getBuildType() {
        return (BuildType)((Object)this.getProperty("buildType"));
    }

    public void setOnPrebuilt(PrebuiltType onPrebuilt) {
        this.setProperty("onPrebuilt", (Object)onPrebuilt);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public PrebuiltType getOnPrebuilt() {
        return (PrebuiltType)((Object)this.getProperty("onPrebuilt"));
    }

    public void setDefaultIndex(Boolean defaultIndex) {
        this.setProperty("defaultIndex", defaultIndex);
    }

    public Boolean getDefaultIndex() {
        return (Boolean)this.getProperty("defaultIndex");
    }

    @Deprecated
    public boolean isUseNoIndex() {
        return Boolean.FALSE.equals(this.getDefaultIndex());
    }

    @Deprecated
    @Transient
    public void setUseNoIndex(boolean useNoIndex) {
        this.setDefaultIndex(!useNoIndex);
    }

    @Deprecated
    @Transient
    public void setIndexPercentFree(int indexPctFree) {
        if (indexPctFree > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
            osp.setPercentFree(indexPctFree);
        }
    }

    @Deprecated
    public int getIndexPercentFree() {
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getPercentFree();
    }

    @Deprecated
    @Transient
    public void setIndexPercentUsed(int indexPctUsed) {
        if (indexPctUsed > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
            osp.setPercentUsed(indexPctUsed);
        }
    }

    @Deprecated
    @Transient
    public int getIndexPercentUsed() {
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getPercentUsed();
    }

    @Transient
    @Deprecated
    public void setIndexInitTrans(int indexInitTrans) {
        if (indexInitTrans > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
            osp.setInitrans(indexInitTrans);
        }
    }

    @Deprecated
    public int getIndexInitTrans() {
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getInitrans();
    }

    @Transient
    @Deprecated
    public void setMaxTrans(int maxTrans) {
        if (maxTrans > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
            osp.setMaxtrans(maxTrans);
        }
    }

    @Deprecated
    public int getMaxTrans() {
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getMaxtrans();
    }

    @Transient
    @Deprecated
    public void setMinTrans(int minTrans) {
        if (minTrans > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
            osp.setInitrans(minTrans);
        }
    }

    @Deprecated
    public int getMinTrans() {
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getInitrans();
    }

    @Transient
    @Deprecated
    public void setInitExtent(int initExtent) {
        if (initExtent > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
            osp.setInitialExtent(new BigInteger(Integer.toString(initExtent)));
        }
    }

    @Deprecated
    public int getInitExtent() {
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getInitialExtent().intValue();
    }

    @Deprecated
    @Transient
    public void setNextExtent(int nextExtent) {
        if (nextExtent > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
            osp.setNextExtent(new BigInteger(Integer.toString(nextExtent)));
        }
    }

    @Deprecated
    public int getNextExtent() {
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getNextExtent().intValue();
    }

    @Transient
    @Deprecated
    public void setIndexMinExtent(int indexMinExtent) {
        if (indexMinExtent > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
            osp.setMinExtent(BigInteger.valueOf(indexMinExtent));
        }
    }

    @Deprecated
    public int getIndexMinExtent() {
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getMinExtent().intValue();
    }

    @Transient
    @Deprecated
    public void setIndexMaxExtent(int indexMaxExtent) {
        if (indexMaxExtent > 0) {
            OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
            osp.setMaxExtent(BigInteger.valueOf(indexMaxExtent));
        }
    }

    @Deprecated
    public int getIndexMaxExtent() {
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getMaxExtent().intValue();
    }

    @Deprecated
    public String getTablespace() {
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? null : osp.getTablespace();
    }

    @Transient
    @Deprecated
    public void setTablespace(String tablespace) {
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setTablespace(tablespace);
    }

    public void setCache(Boolean cache) {
        this.setProperty("cache", cache);
    }

    public Boolean getCache() {
        return (Boolean)this.getProperty("cache");
    }

    @Deprecated
    public Boolean isCache() {
        return this.getCache();
    }

    @Deprecated
    @Transient
    public void setMasters(String[] masters) {
        this.getChildSupport("masters").setChildArray(masters);
    }

    @Deprecated
    @Transient
    public String[] getMasters() {
        return this.getChildSupport("masters").getChildArray(String.class);
    }

    public RefreshWith getKeyType() {
        return (RefreshWith)((Object)this.getProperty("keyType"));
    }

    public void setKeyType(RefreshWith keyType) {
        if (keyType == RefreshWith.UNSPECIFIED) {
            keyType = null;
        }
        this.setProperty("keyType", (Object)keyType);
    }

    public UsingConstraints getUsingConstraints() {
        return (UsingConstraints)((Object)this.getProperty("usingConstraints"));
    }

    public void setUsingConstraints(UsingConstraints usingConstraints) {
        this.setProperty("usingConstraints", (Object)usingConstraints);
    }

    public RollbackSegmentType getRollbackSegmentType() {
        return (RollbackSegmentType)((Object)this.getProperty("rollbackSegmentType"));
    }

    public void setRollbackSegmentType(RollbackSegmentType rollbackSegmentType) {
        this.setProperty("rollbackSegmentType", (Object)rollbackSegmentType);
    }

    public String getRollbackSegmentName() {
        return (String)this.getProperty("rollbackSegmentName");
    }

    public void setRollbackSegmentName(String rollbackSegmentName) {
        this.setProperty("rollbackSegmentName", rollbackSegmentName);
    }

    @Override
    public boolean isDeclarative() {
        SQLQuery query = this.getSQLQuery();
        return query != null && query.isDeclarative();
    }

    @Deprecated
    @Transient
    public void setParallel(int parallel) {
        this.setParallelDegree(parallel);
    }

    @Deprecated
    public int getParallel() {
        Integer p = this.getParallelDegree();
        return p instanceof Integer ? p : 1;
    }

    @Deprecated
    @Transient
    public void setParallelDegree(Integer parallel) {
        OracleTableProperties otp;
        OracleTableProperties oracleTableProperties = otp = parallel == null ? (OracleTableProperties)this.getProperty("OracleTableProperties") : OracleTableProperties.findOrCreateOracleTableProperties(this);
        if (otp != null) {
            otp.setParallelDegree(parallel);
        }
    }

    @Deprecated
    public Integer getParallelDegree() {
        OracleTableProperties otp = (OracleTableProperties)this.getProperty("OracleTableProperties");
        return otp == null ? null : otp.getParallelDegree();
    }

    @Deprecated
    @Transient
    public void setCompression(Boolean compression) {
        OracleTableProperties otp;
        OracleTableProperties oracleTableProperties = otp = compression == null ? (OracleTableProperties)this.getProperty("OracleTableProperties") : OracleTableProperties.findOrCreateOracleTableProperties(this);
        if (otp != null) {
            otp.setTableCompression(OracleTableProperties.OracleTableCompression.migrateFrom(compression));
        }
    }

    @Deprecated
    public Boolean getCompression() {
        OracleTableProperties otp = (OracleTableProperties)this.getProperty("OracleTableProperties");
        return otp == null ? null : OracleTableProperties.OracleTableCompression.convertToBoolean(otp.getTableCompression());
    }

    private OracleStorageProperties getOracleStorageProperties(boolean onIndex, boolean createIfNotFound) {
        String key = onIndex ? "MatViewIndexStorageProperties" : "OracleStorageProperties";
        OracleStorageProperties osp = (OracleStorageProperties)this.getProperty(key);
        if (osp == null && createIfNotFound) {
            osp = new OracleStorageProperties();
            this.setProperty(key, osp);
        }
        return osp;
    }

    public static enum UsingConstraints {
        TRUSTED,
        ENFORCED;

    }

    public static enum RollbackSegmentType {
        NONE,
        LOCAL,
        MASTER;

    }

    public static enum RefreshWith {
        UNSPECIFIED,
        PRIMARY_KEY,
        ROWID;

    }

    public static enum BuildType {
        IMMEDIATE,
        DEFERRED,
        PREBUILT;

    }

    public static enum PrebuiltType {
        NONE,
        UNSPECIFIED_PRECISION,
        WITH_REDUCED_PRECISION,
        WITHOUT_REDUCED_PRECISION;

    }

    public static enum Staleness {
        FRESH,
        STALE,
        UNUSABLE,
        UNKNOWN,
        UNDEFINED,
        NEEDS_COMPILE,
        COMPILATION_ERROR;

    }

    public static enum FastRefreshable {
        NO,
        DIRLOAD,
        DML,
        DIRLOAD_DML,
        DIRLOAD_LIMITEDDML;

    }

    public static enum RefreshMethod {
        FAST,
        COMPLETE,
        FORCE,
        NEVER,
        NA;

    }

    public static enum RefreshMode {
        NEVER,
        DEMAND,
        COMMIT,
        SPECIFY;

    }

    public static enum RewriteCapability {
        NONE,
        TEXTMATCH,
        GENERAL;

    }
}

