/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.NumberProperty;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.sql.SQLFragment;

public class OracleExternalTableProperties
extends AbstractChildBuildableObject {
    @PropertyKey(value=OracleExternalTableProperties.class, childOf={Table.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleExternalTableProperties";
    public static final String TYPE = "EXTERNAL TABLE PROPERTIES";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_LOADER = "ORACLE_LOADER";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_DATAPUMP = "ORACLE_DATAPUMP";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_HIVE = "ORACLE_HIVE";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_HDFS = "ORACLE_HDFS";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_BIGDATA = "ORACLE_BIGDATA";
    public static final int REJECT_LIMIT_UNLIMITED = -1;

    public OracleExternalTableProperties() {
        this.setAccessUsingClob(false);
        this.setProjectColumn(ProjectColumn.ALL);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setDefaultDirectory(DBObjectID defaultDirectory) {
        this.setProperty("defaultDirectory", defaultDirectory);
    }

    @References(value=Directory.class)
    public DBObjectID getDefaultDirectory() {
        return (DBObjectID)this.getProperty("defaultDirectory");
    }

    public void setLocationSpecifiers(LocationSpecifier[] locationSpecifiers) {
        this.getChildSupport("locationSpecifiers").setChildArray(locationSpecifiers);
    }

    public LocationSpecifier[] getLocationSpecifiers() {
        return this.getChildSupport("locationSpecifiers").getChildArray(LocationSpecifier.class);
    }

    public void addLocationSpecifier(LocationSpecifier locationSpecifier) {
        this.getChildSupport("locationSpecifiers").addChild(locationSpecifier);
    }

    public void addLocationSpecifier(DBObjectID directory, String specifier) {
        LocationSpecifier locationSpecifier = new LocationSpecifier(directory, specifier);
        this.getChildSupport("locationSpecifiers").addChild(locationSpecifier);
    }

    public void addLocationSpecifier(String specifier) {
        LocationSpecifier locationSpecifier = new LocationSpecifier(specifier);
        this.getChildSupport("locationSpecifiers").addChild(locationSpecifier);
    }

    public void removeLocationSpecifier(LocationSpecifier locationSpecifier) {
        this.getChildSupport("locationSpecifiers").removeChild(locationSpecifier);
    }

    public void removeAllLocationSpecifiers() {
        this.getChildSupport("locationSpecifiers").clearChildren();
    }

    public void setAccessDriverType(String accessDriverType) {
        this.setProperty("accessDriverType", accessDriverType);
    }

    public String getAccessDriverType() {
        return (String)this.getProperty("accessDriverType");
    }

    public void setAccessParameters(String accessParameters) {
        this.setProperty("accessParameters", accessParameters);
    }

    @TextProperty(multiLine=true)
    public String getAccessParameters() {
        return (String)this.getProperty("accessParameters");
    }

    public void setAccessParametersFragment(SQLFragment frag) {
        this.setProperty("accessParametersFragment", frag);
    }

    @Derived(value="accessParameters")
    @Internal
    public SQLFragment getAccessParametersFragment() {
        return (SQLFragment)this.getProperty("accessParametersFragment");
    }

    public void setAccessUsingClob(boolean accessUsingClob) {
        this.setProperty("accessUsingClob", accessUsingClob);
    }

    public boolean isAccessUsingClob() {
        return (Boolean)this.getProperty("accessUsingClob", false);
    }

    public void setRejectLimit(Integer rejectLimit) {
        this.setProperty("rejectLimit", rejectLimit);
    }

    @NumberProperty(unlimited=true, unlimitedValue=-1)
    public Integer getRejectLimit() {
        return (Integer)this.getProperty("rejectLimit");
    }

    public void setProjectColumn(ProjectColumn projectColumn) {
        this.setProperty("projectColumn", (Object)projectColumn);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public ProjectColumn getProjectColumn() {
        return (ProjectColumn)((Object)this.getProperty("projectColumn"));
    }

    public static class LocationSpecifier
    extends AbstractChildDBObject {
        public static final String TYPE = "LOCATION_SPECIFIER";

        public LocationSpecifier() {
            this(null);
        }

        public LocationSpecifier(String specifier) {
            this(null, specifier);
        }

        public LocationSpecifier(DBObjectID directory, String specifier) {
            this.setDirectory(directory);
            this.setSpecifier(specifier);
        }

        @Override
        public String getType() {
            return TYPE;
        }

        public void setDirectory(DBObjectID directory) {
            this.setProperty("directory", directory);
        }

        @References(value=Directory.class)
        public DBObjectID getDirectory() {
            return (DBObjectID)this.getProperty("directory");
        }

        public void setSpecifier(String specifier) {
            this.setProperty("specifier", specifier);
        }

        public String getSpecifier() {
            return (String)this.getProperty("specifier");
        }

        @Override
        @Internal
        public String getName() {
            return this.getSpecifier();
        }
    }

    public static enum ProjectColumn {
        ALL,
        REFERENCED;

    }

    public static enum AccessType {
        BLOB,
        CLOB;

    }
}

