/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.IndexObject;

public class OracleIndexPartitions
extends AbstractChildBuildableObject {
    @PropertyKey(value=OracleIndexPartitions.class, childOf={Index.class}, provider=OracleDatabase.class)
    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public static final String KEY = "OracleIndexPartitions";
    public static final String TYPE = "INDEX PARTITION MODEL";

    public OracleIndexPartitions() {
    }

    public OracleIndexPartitions(PartitionType partitionType) {
        this.setPartitionType(partitionType);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public PartitionType getPartitionType() {
        return (PartitionType)((Object)this.getProperty("partitionType"));
    }

    public IndexPartition[] getPartitions() {
        return this.getChildSupport("partitions").getChildArray(IndexPartition.class);
    }

    public DBObjectID[] getGlobalPartitionColumns() {
        return this.getChildSupport("globalPartitionColumns").getChildArray(DBObjectID.class);
    }

    @Deprecated
    public String[] getTablespaces() {
        ArrayList<String> tbspNames = new ArrayList<String>();
        for (DBObjectID tbspId : this.getHashQuantityTablespaceIds()) {
            Tablespace tbsp = null;
            try {
                tbsp = (Tablespace)tbspId.resolveID();
                if (tbsp == null) continue;
                tbspNames.add(tbsp.getName());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return tbspNames.toArray(new String[tbspNames.size()]);
    }

    @References(value=Tablespace.class)
    public DBObjectID[] getHashQuantityTablespaceIds() {
        return this.getChildSupport("hashQuantityTablespaceIds").getChildArray(DBObjectID.class);
    }

    public Integer getGlobalHashQuantity() {
        return (Integer)this.getProperty("globalHashQuantity");
    }

    public void setPartitionType(PartitionType partitionType) {
        if (partitionType == PartitionType.DOMAIN) {
            partitionType = PartitionType.LOCAL_OTHER;
        }
        this.setProperty("partitionType", (Object)partitionType);
    }

    public void setGlobalPartitionColumns(DBObjectID[] partitionColumns) {
        this.getChildSupport("globalPartitionColumns").setChildArray(partitionColumns);
    }

    public void addGlobalPartitionColumn(DBObjectID partitionColumn) {
        if (partitionColumn != null) {
            this.getChildSupport("globalPartitionColumns").addChild(partitionColumn);
        }
    }

    public void removeGlobalPartitionColumn(DBObjectID partitionColumn) {
        this.getChildSupport("globalPartitionColumns").removeChild(partitionColumn);
    }

    public void setPartitions(IndexPartition[] partitions) {
        this.getChildSupport("partitions").setChildArray(partitions);
    }

    public void addPartition(IndexPartition partition) {
        this.getChildSupport("partitions").addChild(partition);
    }

    public void addPartition(int index, IndexPartition partition) {
        this.getChildSupport("partitions").addChild(index, partition);
    }

    public void removePartition(IndexPartition partition) {
        this.getChildSupport("partitions").removeChild(partition);
    }

    @Transient
    @Deprecated
    public void setTablespaces(String[] tablespaces) {
        this.setHashQuantityTablespaceIds(new DBObjectID[0]);
        if (tablespaces != null) {
            for (String name : tablespaces) {
                this.addTablespace(name);
            }
        }
    }

    public void setHashQuantityTablespaceIds(DBObjectID[] tablespaceIDs) {
        this.getChildSupport("hashQuantityTablespaceIds").setChildArray(tablespaceIDs);
    }

    @Deprecated
    public void addTablespace(String tablespace) {
        if (tablespace != null) {
            ReferenceID id = new ReferenceID("TABLESPACE", (Schema)null, tablespace);
            this.setHashQuantityTablespaceIds(new DBObjectID[]{id});
        }
    }

    public void setGlobalHashQuantity(Integer globalHashQuantity) {
        this.setProperty("globalHashQuantity", globalHashQuantity);
    }

    public static Column[] getValidGlobalPartitionColumns(Index index) {
        IndexObject colExpr;
        String expr;
        ArrayList<Column> columns = new ArrayList<Column>();
        Table table = index.getTable();
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        int n = indexObjectArray.length;
        for (int i = 0; i < n && table.getColumn(expr = (colExpr = indexObjectArray[i]).getExpressionSource()) != null && !IndexObject.OrderType.DESC.equals((Object)colExpr.getOrderType()); ++i) {
            columns.add(table.getColumn(expr));
        }
        return columns.toArray(new Column[columns.size()]);
    }

    public void setLocalTablePartitionModelID(DBObjectID otpId) {
        this.setProperty("localTablePartitionModelID", otpId);
    }

    @Derived(value="partitionType")
    @References(value=OracleTablePartitions.class, internal=true)
    @Internal
    public DBObjectID getLocalTablePartitionModelID() {
        return (DBObjectID)this.getProperty("localTablePartitionModelID");
    }

    public static enum PartitionType {
        GLOBAL_RANGE,
        GLOBAL_HASH,
        LOCAL_HASH,
        LOCAL_COMP,
        LOCAL_OTHER,
        DOMAIN,
        SUBPARTITION;

    }
}

