/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Collection;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.property.Derived;

public class PlSqlReference
extends DBObjectPlSqlFragment {
    public static final String TYPE = "PlSqlReference";

    public PlSqlReference() {
        this.setReferenceType(ReferenceType.DIRECT);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Deprecated
    public void setReferenceID(DBObjectID referenceID) {
        if (referenceID == null) {
            this.setReferences(null);
        } else {
            DBObjectID[] refs = new DBObjectID[]{referenceID};
            this.setReferences(refs);
        }
    }

    public DBObjectID getReferenceID() {
        DBObjectID[] refs = this.getReferences();
        if (refs.length > 0) {
            return refs[0];
        }
        DataTypeUsage dtu = this.getDataTypeUsage();
        if (dtu != null) {
            return dtu.getDataTypeID();
        }
        return null;
    }

    public void setReferenceNames(String[] names) {
        this.setProperty("referenceNames", names);
    }

    public String[] getReferenceNames() {
        return (String[])this.getProperty("referenceNames");
    }

    public void setReferences(DBObjectID[] references) {
        this.getChildSupport("references").setChildArray(references);
    }

    @Derived(value="referenceNames")
    public DBObjectID[] getReferences() {
        return this.getChildSupport("references").getChildArray(DBObjectID.class);
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.setProperty("referenceType", (Object)referenceType);
    }

    public ReferenceType getReferenceType() {
        return (ReferenceType)((Object)this.getProperty("referenceType"));
    }

    public void setDataTypeUsageSource(String dataTypeUsage) {
        if (this.getReferenceType() != ReferenceType.DIRECT) {
            throw new IllegalStateException("setting the DataTypeUsage string string is only allowed for DIRECT References");
        }
        this.setProperty("dataTypeUsageSource", dataTypeUsage);
    }

    public String getDataTypeUsageSource() {
        return (String)this.getProperty("dataTypeUsageSource");
    }

    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
        this.setProperty("dataTypeUsage", dataTypeUsage);
    }

    @Derived(value="dataTypeUsageSource")
    public DataTypeUsage getDataTypeUsage() {
        return (DataTypeUsage)this.getProperty("dataTypeUsage");
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
    }

    @Override
    public String toString() {
        String[] names = this.getReferenceNames();
        if (names != null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    sb.append('.');
                }
                sb.append(name);
                first = false;
            }
            if (this.getReferenceType() == ReferenceType.PCT_TYPE) {
                sb.append("%TYPE");
            } else if (this.getReferenceType() == ReferenceType.PCT_ROWTYPE) {
                sb.append("%ROWTYPE");
            } else if (this.getReferenceType() == ReferenceType.REF) {
                sb.insert(0, "REF ");
            }
            return sb.toString();
        }
        return null;
    }

    public static enum ReferenceType {
        DIRECT,
        REF,
        PCT_TYPE,
        PCT_ROWTYPE;

    }
}

