/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Map;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.util.ModelUtil;

public class Type
extends PlSqlSchemaObjectSpec
implements DataType {
    public static final String TYPE = "TYPE";
    public static final String OBJECT_TYPECODE = "OBJECT";
    public static final String COLLECTION_TYPECODE = "COLLECTION";
    public static final String TABLE_TYPE = "TABLE";
    public static final String VARRAY_TYPE = "VARYING ARRAY";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Integer getSQLType() {
        return null;
    }

    @Override
    public boolean canHaveBody() {
        return !COLLECTION_TYPECODE.equals(this.getTypeCode());
    }

    @Derived(value="source")
    public boolean isFinal() {
        return (Boolean)this.getProperty("final", false);
    }

    public void setFinal(boolean final_) {
        this.setProperty("final", final_);
    }

    @Derived(value="source")
    public boolean isInstantiable() {
        return (Boolean)this.getProperty("instantiable", false);
    }

    public void setInstantiable(boolean instantiable) {
        this.setProperty("instantiable", instantiable);
    }

    @Derived(value="source")
    public String getTypeCode() {
        return (String)this.getProperty("typeCode");
    }

    public void setTypeCode(String typeCode) {
        this.setProperty("typeCode", typeCode);
    }

    @Derived(value="source")
    public String getCollectionType() {
        return (String)this.getProperty("collectionType");
    }

    public void setCollectionType(String collectionType) {
        this.setProperty("collectionType", collectionType);
    }

    public void setAuthidCurrentUser(boolean authidCurrentUser) {
        this.setProperty("authidCurrentUser", authidCurrentUser);
    }

    @Derived(value="source")
    public boolean isAuthidCurrentUser() {
        return (Boolean)this.getProperty("authidCurrentUser", false);
    }

    public void setLimit(Integer limit) {
        this.setProperty("limit", limit);
    }

    @Derived(value="source")
    public Integer getLimit() {
        return (Integer)this.getProperty("limit");
    }

    public DataTypeUsage getOfTypeUsage() {
        PlSqlReference ref = this.getOfTypeUsageReference();
        return ref == null ? null : ref.getDataTypeUsage();
    }

    public void setOfTypeUsageReference(PlSqlReference ofTypeUsageRef) {
        this.setProperty("ofTypeUsageReference", ofTypeUsageRef);
    }

    @Derived(value="source")
    public PlSqlReference getOfTypeUsageReference() {
        return (PlSqlReference)this.getProperty("ofTypeUsageReference");
    }

    @Derived(value="source")
    public PlSqlReference getUnderTypeReference() {
        return (PlSqlReference)this.getProperty("underTypeReference");
    }

    public void setUnderTypeReference(PlSqlReference underTypeRef) {
        this.setProperty("underTypeReference", underTypeRef);
    }

    public DBObjectID getUnderTypeID() {
        PlSqlReference ref = this.getUnderTypeReference();
        return ref == null ? null : ref.getReferenceID();
    }

    public void setOID(String oid) {
        this.setProperty("OID", oid);
    }

    @Derived(value="source")
    public String getOID() {
        return (String)this.getProperty("OID");
    }

    public void setSqljExternalName(String sqljExternalName) {
        this.setProperty("sqljExternalName", sqljExternalName);
    }

    @Derived(value="source")
    public String getSqljExternalName() {
        return (String)this.getProperty("sqljExternalName");
    }

    public void setSqljUsing(SQLJUsingType sqljUsing) {
        this.setProperty("sqljUsing", (Object)sqljUsing);
    }

    @Derived(value="source")
    public SQLJUsingType getSqljUsing() {
        return (SQLJUsingType)((Object)this.getProperty("sqljUsing"));
    }

    public void setMethods(PlSqlMethod[] methods) {
        this.getChildSupport("methods").setChildArray(methods);
    }

    @Derived(value="source")
    public PlSqlMethod[] getMethods() {
        return this.getChildSupport("methods").getChildArray(PlSqlMethod.class);
    }

    public PlSqlMethod getMethod(String name) {
        return (PlSqlMethod)this.getChildSupport("methods").findChild(name);
    }

    public void addMethod(PlSqlMethod method) {
        this.getChildSupport("methods").addChild(method);
    }

    public void removeMethod(PlSqlMethod method) {
        this.getChildSupport("methods").removeChild(method);
    }

    @Override
    @Internal
    public PlSqlSubProgram[] getSubPrograms() {
        PlSqlMethod[] methods = this.getMethods();
        PlSqlSubProgram[] subs = new PlSqlSubProgram[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            subs[i] = methods[i];
        }
        return subs;
    }

    @Override
    public void setSubPrograms(PlSqlSubProgram[] subPrograms) {
        PlSqlMethod[] methods = new PlSqlMethod[subPrograms == null ? 0 : subPrograms.length];
        for (int i = 0; i < methods.length; ++i) {
            if (!(subPrograms[i] instanceof PlSqlMethod)) {
                throw new IllegalArgumentException("Array element " + i + " is not a PlSqlMethod");
            }
            methods[i] = (PlSqlMethod)subPrograms[i];
        }
        this.setMethods(methods);
    }

    @Override
    public void addSubProgram(PlSqlSubProgram subProgram) {
        if (!(subProgram instanceof PlSqlMethod)) {
            throw new IllegalArgumentException("subProgram is not a PlSqlMethod");
        }
        this.addMethod((PlSqlMethod)subProgram);
    }

    public void setAttributes(PlSqlAttribute[] attributes) {
        this.getChildSupport("attributes").setChildArray(attributes);
    }

    @Derived(value="source")
    public PlSqlAttribute[] getAttributes() {
        return this.getChildSupport("attributes").getChildArray(PlSqlAttribute.class);
    }

    public PlSqlAttribute getAttribute(String name) {
        return (PlSqlAttribute)this.getChildSupport("attributes").findChild(name);
    }

    public void addAttribute(PlSqlAttribute attribute) {
        this.getChildSupport("attributes").addChild(attribute);
    }

    public void removeAttribute(PlSqlAttribute attribute) {
        this.getChildSupport("attributes").removeChild(attribute);
    }

    @Override
    @Internal
    public PlSqlVariable[] getVariables() {
        PlSqlAttribute[] attrs = this.getAttributes();
        PlSqlVariable[] vars = new PlSqlVariable[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            vars[i] = attrs[i];
        }
        return vars;
    }

    @Override
    public void setVariables(PlSqlVariable[] vars) {
        PlSqlAttribute[] attrs = new PlSqlAttribute[vars == null ? 0 : vars.length];
        for (int i = 0; i < attrs.length; ++i) {
            if (!(vars[i] instanceof PlSqlAttribute)) {
                throw new IllegalArgumentException("Array element " + i + " is not a PlSqlAttribute");
            }
            attrs[i] = (PlSqlAttribute)vars[i];
        }
        this.setAttributes(attrs);
    }

    @Override
    public void addVariable(PlSqlVariable var) {
        if (!(var instanceof PlSqlAttribute)) {
            throw new IllegalArgumentException("subProgram is not a PlSqlAttribute");
        }
        this.addAttribute((PlSqlAttribute)var);
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        String name;
        String schemaName;
        StringBuffer fsb = new StringBuffer();
        DBObjectProvider pro = this.getID() instanceof BaseObjectID ? ((BaseObjectID)this.getID()).getProvider() : null;
        Schema s = this.getSchema();
        if (s != null && ModelUtil.hasLength((String)(schemaName = s.getName()))) {
            if (pro != null) {
                schemaName = pro.getExternalName(schemaName);
            }
            fsb.append(schemaName).append(".");
        }
        if ((name = this.getName()) != null && pro != null) {
            name = pro.getExternalName(name);
        }
        fsb.append(name);
        return DataTypeHelper.getTypeDDL(dataTypeUsage, fsb.toString());
    }

    @Override
    public DataTypeAttribute[] getDataTypeAttributes() {
        return new DataTypeAttribute[0];
    }

    @Override
    public boolean hasDataTypeAttribute(String name) {
        return false;
    }

    @Override
    public DataTypeAttribute getDataTypeAttribute(String name) {
        return null;
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        return new DataTypeUsage(this);
    }

    @Override
    public DataTypeUsage createUsage(Map<String, Object> attributes) {
        return this.createDefaultUsage();
    }

    @Override
    @Deprecated
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
    }

    @Override
    @Deprecated
    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
    }

    @Override
    public boolean matches(String usageString) {
        StringBuffer searchExpr = new StringBuffer("[? .] {");
        searchExpr.append("\"").append(this.getName()).append("\" |");
        searchExpr.append(this.getName().toUpperCase()).append("}");
        PlSqlSearch search = null;
        try {
            search = new PlSqlSearch(searchExpr.toString());
            return search.matches(usageString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public DataTypeUsage createUsage(String usageString) {
        return this.createDefaultUsage();
    }

    public static enum SQLJUsingType {
        SQLData,
        CustomDatum,
        OraData;

    }
}

