/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Tuple;

public abstract class PlSqlParser {
    private final PlSqlSourceObject m_root;
    private final String m_source;
    private final DBObjectProvider m_pro;

    protected PlSqlParser(DBObjectProvider pro, PlSqlSourceObject pso, String source) {
        if (pro == null) {
            throw new IllegalArgumentException("DBObjectProvider pro must not be null");
        }
        if (pso == null && source == null || pso != null && source != null) {
            throw new IllegalArgumentException("Please provide a PlSqlSourceObject or String, but not both");
        }
        this.m_pro = pro;
        if (pso != null) {
            this.m_root = pso;
        } else {
            Class<? extends DBObject> clz;
            PlSqlSourceObject root = null;
            String type = PlSqlUtilCore.getTypeFromSource(source);
            if (type != null && (clz = Metadata.getInstance().getObjectClass(type)) != null && PlSqlSourceObject.class.isAssignableFrom(clz)) {
                root = (PlSqlSourceObject)this.m_pro.getObjectFactory().newObject(clz, null, false, false);
                root.setSource(source);
            }
            this.m_root = root;
        }
        this.m_source = source == null ? this.m_root.getSource() : source;
    }

    public final PlSqlSourceObject getRoot() {
        return this.m_root;
    }

    public abstract PlSqlToken getTokenAtOffset(int var1) throws CancelledException;

    public abstract boolean isWrapped() throws CancelledException;

    public abstract PlSqlToken getTypeToken() throws CancelledException;

    public abstract PlSqlToken getSchemaToken() throws CancelledException;

    public abstract PlSqlToken getNameToken() throws CancelledException;

    public abstract int getStartOffsetOfObject() throws CancelledException;

    public abstract int getEndOffsetOfObject() throws CancelledException;

    public abstract List<Tuple<PlSqlToken, PlSqlToken>> getAlterStatements() throws CancelledException;

    public final List<Integer> getLocationOffsets(String text) throws CancelledException {
        String source = this.getSource();
        if (source != null) {
            return this.getLocationOffsets(text, 0, source.length() - 1);
        }
        return Collections.emptyList();
    }

    public final List<Integer> getLocationOffsets(String internalName, int start, int end) throws CancelledException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        char low0 = Character.toLowerCase(internalName.charAt(0));
        char upp0 = Character.toUpperCase(internalName.charAt(0));
        int textLen = internalName.length();
        boolean mustBeQuoted = false;
        for (int i = 0; i < textLen; ++i) {
            char c = internalName.charAt(i);
            if (!(i != 0 || Character.isLetter(c) && Character.isUpperCase(c))) {
                mustBeQuoted = true;
                break;
            }
            if (c == '_' || c == '$' || c == '#') continue;
            if (!Character.isLetterOrDigit(c)) {
                mustBeQuoted = true;
                break;
            }
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            mustBeQuoted = true;
            break;
        }
        boolean internalNameIsUpper = true;
        for (char c : internalName.toCharArray()) {
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            internalNameIsUpper = false;
            break;
        }
        String source = this.getSource();
        int pos = start;
        while (pos <= end - textLen + 1) {
            PlSqlToken tk;
            String chunk;
            char charAtPos = source.charAt(pos);
            boolean match = false;
            if ((charAtPos == low0 || charAtPos == upp0) && (chunk = source.substring(pos, pos + textLen)).equalsIgnoreCase(internalName) && (tk = this.getTokenAtOffset(pos)).isCode(true)) {
                if (tk.getType() == Token.Type.DOUBLE_QUOTED_STRING) {
                    String str = tk.getSource();
                    str = str.substring(1, str.length() - 1);
                    match = internalName.equals(str);
                } else if (!mustBeQuoted) {
                    match = tk.matches(internalName);
                }
            }
            if (match) {
                ret.add(pos);
                pos += textLen;
                continue;
            }
            ++pos;
        }
        return ret;
    }

    public abstract Object getParseNode(int var1) throws CancelledException;

    public abstract int getStartOffset(Object var1) throws IllegalArgumentException, CancelledException;

    public abstract int getEndOffset(Object var1) throws IllegalArgumentException, CancelledException;

    public abstract List getChildParseNodes(DBObjectPlSqlFragment var1, Object var2) throws IllegalArgumentException, CancelledException;

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected final String getSource() {
        return this.m_source;
    }

    public abstract Object getParseNode(DBObjectPlSqlFragment var1) throws CancelledException;

    public abstract DBObjectPlSqlFragment createFragment(DBObjectPlSqlFragment var1, Object var2, Object var3) throws CancelledException;

    public final Object getPropertyNode(DBObjectPlSqlFragment frag, String property) throws CancelledException {
        Object[] ret = this.getPropertyNodesImpl(frag, property);
        if (ret == null || ret.length == 0) {
            return null;
        }
        if (ret.length == 1) {
            return ret[0];
        }
        throw new UnsupportedOperationException("getPropertyNode() should not be called on a collection property");
    }

    public final Object[] getPropertyNodes(DBObjectPlSqlFragment frag, String property) throws CancelledException {
        Object[] ret = this.getPropertyNodesImpl(frag, property);
        if (ret == null) {
            return new Object[0];
        }
        return ret;
    }

    protected abstract Object[] getPropertyNodesImpl(DBObjectPlSqlFragment var1, String var2) throws CancelledException;

    public abstract List<Issue> getIssues() throws CancelledException;

    public abstract List<Issue> getIssues(String var1);

    public static interface Issue {
        public int getStartOffset();

        public int getEndOffset();

        public Severity getSeverity();

        public String getMessage();
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

