/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractPropertyManager
implements PropertyManager {
    private final DBObjectProvider m_pro;
    private final Metadata m_meta = Metadata.getInstance();
    private final PropertyHelper m_propHelper;

    protected AbstractPropertyManager(DBObjectProvider pro) {
        this.m_pro = pro;
        this.m_propHelper = new PropertyHelper(pro);
    }

    protected final PropertyHelper getPropertyHelper() {
        return this.m_propHelper;
    }

    protected AbstractPropertyManager getDelegate() {
        return null;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Class<? extends DBObjectProvider> getProviderClass() {
        DBObjectProvider pro = this.getProvider();
        return pro == null ? null : pro.getClass();
    }

    @Override
    public final boolean supportsProperty(String type, String prop) {
        return this.supportsProperty(this.m_meta.getObjectClass(type), prop);
    }

    @Override
    public boolean supportsProperty(Class<? extends DBObject> objClz, String prop) {
        boolean retval = false;
        if (objClz != null) {
            PropertyInfo info = this.findPropertyInfo(objClz, prop);
            boolean bl = retval = info != null;
            if (!retval && SystemObject.class.isAssignableFrom(objClz)) {
                retval = this.isProcessorProperty(objClz, prop);
            }
        }
        return retval;
    }

    @Override
    public PropertyAction supportsPropertyChange(Class<? extends SystemObject> objClz, String prop) {
        PropertyAction retval = null;
        AbstractPropertyManager pm = this.getDelegate();
        if (pm != null) {
            retval = pm.supportsPropertyChange(objClz, prop);
        }
        return retval;
    }

    @Override
    public PropertyInfo findPropertyInfo(Class<? extends DBObject> objClz, String prop) {
        PropertyInfo retval;
        block2: {
            Class<? extends DBObjectProvider> proClz;
            retval = null;
            if (this.m_pro != null) {
                retval = PropertyHelper.findPropertyInfo(objClz, prop, this.m_pro);
            }
            if (retval != null) break block2;
            Iterator<Class<? extends DBObjectProvider>> iterator = this.getProviderClasses(false).iterator();
            while (iterator.hasNext() && (retval = PropertyHelper.findPropertyInfo(objClz, prop, proClz = iterator.next())) == null) {
            }
        }
        return retval;
    }

    private Iterable<Class<? extends DBObjectProvider>> getProviderClasses(boolean addProClz) {
        Class<? extends DBObjectProvider> delegateProClz;
        AbstractPropertyManager delegate;
        Class<?> realProClz;
        LinkedHashSet<Class<? extends DBObjectProvider>> retval = new LinkedHashSet<Class<? extends DBObjectProvider>>();
        Class<? extends DBObjectProvider> thisProClz = this.getProviderClass();
        Class<?> clazz = realProClz = this.m_pro == null ? null : this.m_pro.getClass();
        if (realProClz != null) {
            if (addProClz) {
                retval.add(realProClz);
            }
            if (!thisProClz.isAssignableFrom(realProClz)) {
                retval.add(thisProClz);
            }
        } else {
            retval.add(thisProClz);
        }
        if (!((delegate = this.getDelegate()) == null || (delegateProClz = delegate.getProviderClass()).isAssignableFrom(thisProClz) || realProClz != null && delegateProClz.isAssignableFrom(realProClz))) {
            retval.add(delegateProClz);
        }
        return retval;
    }

    @Override
    public Map<String, PropertyInfo> getPropertyInfos(Class<? extends DBObject> objClz, PropertyCriteria criteria) {
        Iterable<Class<? extends DBObjectProvider>> proClzs = this.getProviderClasses(true);
        criteria.addPredicate(info -> this.supportsAnyProvider((PropertyInfo)info, proClzs));
        return PropertyHelper.getPropertyInfos(objClz, null, criteria);
    }

    private boolean supportsAnyProvider(PropertyInfo info, Iterable<Class<? extends DBObjectProvider>> proClzs) {
        boolean retval = false;
        for (Class<? extends DBObjectProvider> proClz : proClzs) {
            if (!info.isSupported(proClz, null)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    @Override
    public boolean canCreateProperty(SystemObject obj, String prop) {
        Trigger.BaseType baseType;
        String type = obj.getType();
        if ("PROCEDURE".equals(type) && "returnTypeReference".equals(prop)) {
            return false;
        }
        if ("TRIGGER".equals(type) && ((baseType = ((Trigger)obj).getBaseType()) == Trigger.BaseType.DATABASE ? "baseObjectID".equals(prop) || "statementLevel".equals(prop) || "referencingNewAs".equals(prop) || "referencingOldAs".equals(prop) || "whenClause".equals(prop) || "columnIDs".equals(prop) : (baseType == Trigger.BaseType.SCHEMA ? "statementLevel".equals(prop) || "referencingNewAs".equals(prop) || "referencingOldAs".equals(prop) || "whenClause".equals(prop) || "columnIDs".equals(prop) : baseType == Trigger.BaseType.VIEW && ("statementLevel".equals(prop) || "whenClause".equals(prop) || "columnIDs".equals(prop))))) {
            return false;
        }
        boolean retval = false;
        Class<?> objClz = obj.getClass();
        if (this.supportsProperty(objClz, prop)) {
            String[] props;
            PropertyInfo info;
            retval = this.canCreate(objClz, prop);
            if (!retval && (info = this.findPropertyInfo(obj.getClass(), prop)) != null && info.isDerived()) {
                String sourceProp = info.getDerivedSourceProperty();
                retval = this.canCreate(objClz, prop.replaceAll(info.getPropertyName(), sourceProp));
            }
            if (!retval && prop.contains("dataTypeUsage") && (props = Property.getProperties(prop)).length > 1 && "dataTypeUsage".equals(props[props.length - 1])) {
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public final boolean canAlterProperty(SystemObject original, SystemObject update, String prop) {
        boolean retval = false;
        PropertyAction action = this.canChangeProperty(original, update, prop);
        if (action != null) {
            retval = action.getType() == PropertyAction.Type.ALTER;
        }
        return retval;
    }

    @Override
    public final PropertyAction canChangeProperty(SystemObject original, SystemObject update, String prop) {
        if (this.supportsProperty(update.getClass(), prop)) {
            if (original == null) {
                if (this.canCreate(update, prop)) {
                    return new PropertyAction(PropertyAction.Type.CREATE);
                }
                this.getLogger().log(Level.FINEST, "Property {0}: not supported for CREATE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
            } else {
                if (this.canChangeWithAlter(original, update, prop)) {
                    this.getLogger().log(Level.FINEST, "Property {0}: can ALTER on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
                    return new PropertyAction(PropertyAction.Type.ALTER);
                }
                if (this.canChangeWithReplace(original, update, prop)) {
                    this.getLogger().log(Level.FINEST, "Property {0}: cannot ALTER but can REPLACE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
                    return new PropertyAction(PropertyAction.Type.REPLACE);
                }
                this.getLogger().log(Level.FINEST, "Property {0}: not supported for ALTER or REPLACE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
            }
        }
        return null;
    }

    protected boolean canCreate(SystemObject newObj, String prop) {
        return this.canCreate(newObj.getClass(), prop);
    }

    protected boolean canCreate(Class<? extends SystemObject> objClz, String prop) {
        boolean retval = true;
        AbstractPropertyManager pm = this.getDelegate();
        if (pm != null) {
            retval = pm.canCreate(objClz, prop);
        }
        if (!retval) {
            retval = this.isProcessorProperty(objClz, prop);
        }
        return retval;
    }

    @Deprecated
    protected boolean canCreate(String type, String prop) {
        return true;
    }

    protected boolean canChangeWithAlter(SystemObject orig, SystemObject update, String prop) {
        boolean retval = false;
        AbstractPropertyManager pm = this.getDelegate();
        if (pm == null) {
            PropertyInfo info;
            PropertyAction action = this.supportsPropertyChange(update.getClass(), prop);
            if (action != null && PropertyAction.Type.ALTER.equals((Object)action.getType()) && (info = this.findPropertyInfo(update.getClass(), prop)) != null) {
                retval = true;
                if (info.getPropertyClass().isArray()) {
                    Difference diff;
                    PropertyHelper helper = this.getPropertyHelper();
                    Object origValue = helper.getPropertyValue(orig, prop);
                    Object updatedValue = helper.getPropertyValue(update, prop);
                    DBObjectProvider pro = this.getProvider();
                    if (pro != null && (origValue != null || updatedValue != null) && (diff = pro.getDiffEngine().difference(origValue, updatedValue)).isList()) {
                        for (Difference difference : diff.getChildren()) {
                            if (difference.isSame()) continue;
                            Object origChild = difference.getOriginalObject();
                            Object updatedChild = difference.getUpdatedObject();
                            PropertyAction.ChildAction childAction = origChild == null ? PropertyAction.ChildAction.ADD : (updatedChild == null ? PropertyAction.ChildAction.REMOVE : PropertyAction.ChildAction.MODIFY);
                            if (action.supportsChildAction(childAction)) continue;
                            retval = false;
                            break;
                        }
                    }
                }
            }
        } else {
            retval = pm.canChangeWithAlter(orig, update, prop);
        }
        return retval;
    }

    protected boolean canChangeWithReplace(SystemObject orig, SystemObject update, String prop) {
        String type = update.getType();
        return (this.supportsAction(type, PropertyAction.Type.REPLACE) || this.supportsAction(type, PropertyAction.Type.DELETE)) && this.canCreate(update, prop);
    }

    @Override
    public final PropertyAction canUpdateObject(SystemObject orig, SystemObject update) {
        DiffEngine de;
        PropertyAction retval = null;
        DBObjectProvider pro = this.getProvider();
        if (pro != null && (de = this.getProvider().getDiffEngine()) != null) {
            Difference rs = de.difference(orig, update);
            retval = this.canUpdateObject(rs);
        }
        return retval;
    }

    @Override
    public final PropertyAction canUpdateObject(Difference rs) {
        SystemObject orig = (SystemObject)rs.getOriginalObject();
        SystemObject update = (SystemObject)rs.getUpdatedObject();
        PropertyAction retval = new PropertyAction(orig == null ? PropertyAction.Type.CREATE : PropertyAction.Type.ALTER);
        if (rs.isModified()) {
            Collection<? extends Difference> diffs = rs.getChildren();
            retval = this.processDiffs(orig, update, diffs, null, retval);
        }
        return retval;
    }

    private PropertyAction processDiffs(SystemObject orig, SystemObject update, Collection<? extends Difference> diffs, String parentPropPath, PropertyAction retval) {
        for (Difference difference : diffs) {
            String fullPropPath;
            if (retval == null) break;
            if (difference.isSame() || difference.isDerived()) continue;
            String propName = difference.getPropertyName();
            String string = fullPropPath = ModelUtil.hasLength((String)parentPropPath) ? parentPropPath + "/" + propName : propName;
            if (difference.isMap()) {
                retval = this.processDiffs(orig, update, difference.getChildren(), fullPropPath, retval);
                continue;
            }
            PropertyAction action = this.canChangeProperty(orig, update, fullPropPath);
            if (action == null) {
                PropertyInfo info = this.findPropertyInfo(update.getClass(), fullPropPath);
                Level level = info != null && info.isDerived() ? Level.FINE : Level.WARNING;
                this.getLogger().log(level, "Unsupported property: " + fullPropPath);
                retval = null;
                continue;
            }
            if (retval.getType() != action.getType() && retval.getType() == PropertyAction.Type.ALTER) {
                retval = action;
            }
            if (retval.getType() != action.getType()) continue;
            retval.addProperty(fullPropPath);
        }
        return retval;
    }

    @Override
    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        Nullable.NullBehaviour realNullBehaviour;
        PropertyInfo info;
        Collection retval = null;
        AbstractPropertyManager delegate = this.getDelegate();
        if (delegate != null) {
            retval = delegate.getAllowedPropertyValues(originalObject, updatedObject, property);
            if (retval != null) {
                Nullable.NullBehaviour delegateBehaviour = delegate.getNullBehaviour(originalObject, updatedObject, property);
                Nullable.NullBehaviour thisBehaviour = this.getNullBehaviour(originalObject, updatedObject, property);
                if (thisBehaviour != delegateBehaviour) {
                    if (delegateBehaviour == Nullable.NullBehaviour.NOT_NULLABLE) {
                        if (!retval.contains(null)) {
                            ArrayList newList = new ArrayList();
                            newList.add(null);
                            newList.addAll(retval);
                            retval = newList;
                        }
                    } else if (thisBehaviour == Nullable.NullBehaviour.NOT_NULLABLE) {
                        retval.remove(null);
                    }
                }
            }
        } else if (Property.getLastProperty(property).equals("constraintType")) {
            retval = new ArrayList<String>();
            if (updatedObject instanceof Relation && this.supportsProperty(updatedObject.getClass(), "constraints")) {
                retval.add("PKConstraint");
            }
        } else if (property.contains("attributeValues")) {
            Column column;
            DataTypeUsage dtu;
            if (updatedObject instanceof Column && (dtu = (column = (Column)updatedObject).getDataTypeUsage()) != null) {
                DataType dataType = null;
                try {
                    dataType = DataTypeHelper.getDataType(dtu, false);
                }
                catch (DBException e) {
                    this.getLogger().log(Level.FINE, "Error getting data type attributes allowable values for \"" + property + "\" : " + e.getMessage());
                }
                if (dataType != null) {
                    DataTypeAttribute attribute = dataType.getDataTypeAttribute(Property.getLastProperty(property));
                    ArrayList<Object> attribValues = new ArrayList<Object>();
                    if (attribute != null) {
                        if (!attribute.isMandatory()) {
                            attribValues.add(null);
                        }
                        Collections.addAll(attribValues, attribute.getValues());
                    }
                    retval = attribValues;
                }
            }
        } else if (updatedObject != null && (info = this.findPropertyInfo(updatedObject.getClass(), property)) != null && (retval = info.getAllowedValues()) != null && (realNullBehaviour = this.getNullBehaviour(originalObject, updatedObject, property)) == Nullable.NullBehaviour.NOT_NULLABLE) {
            retval.remove(null);
        }
        if (updatedObject instanceof Trigger && Property.getLastProperty(property).equals("timing")) {
            if (Trigger.BaseType.VIEW == ((Trigger)updatedObject).getBaseType()) {
                retval.retainAll(Collections.singleton(Trigger.Timing.INSTEAD_OF));
            } else {
                retval.remove((Object)Trigger.Timing.INSTEAD_OF);
            }
        }
        return retval;
    }

    @Override
    public Collection<String> getRestrictingProperties(Class<? extends SystemObject> objClz, String property) {
        Collection<String> retval = Collections.emptyList();
        AbstractPropertyManager delegate = this.getDelegate();
        if (delegate != null) {
            retval = delegate.getRestrictingProperties(objClz, property);
        }
        return retval;
    }

    @Override
    public Nullable.NullBehaviour getNullBehaviour(DBObject originalObject, DBObject updatedObject, String property) {
        PropertyInfo info;
        Nullable.NullBehaviour retval = null;
        if (updatedObject != null && (info = this.findPropertyInfo(updatedObject.getClass(), property)) != null) {
            retval = this.getNullBehaviour(info, originalObject != null);
        }
        return retval;
    }

    protected Nullable.NullBehaviour getNullBehaviour(PropertyInfo info, boolean edit) {
        Nullable.NullBehaviour retval = info.getNullBehaviour();
        if (edit && retval == Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED) {
            retval = Nullable.NullBehaviour.NOT_NULLABLE;
        }
        return retval;
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(DBObject object, String property) {
        Collection<String> retval;
        AbstractPropertyManager base = this.getDelegate();
        if (base != null) {
            retval = base.getAllowedReferenceTypes(object, property);
        } else if (object instanceof Trigger && "baseObjectID".equals(property)) {
            String triggerTypeString;
            Trigger.BaseType triggerType = ((Trigger)object).getBaseType();
            String string = triggerTypeString = triggerType == null ? null : triggerType.toString();
            retval = this.m_meta.getObjectClass(triggerTypeString) != null ? Collections.singleton(triggerType == null ? "TABLE" : triggerType.toString()) : null;
        } else {
            retval = this.getAllowedReferenceTypes(object.getType(), property);
        }
        return retval;
    }

    @Override
    public final Collection<String> getAllowedReferenceTypes(String objectType, String property) {
        PropertyInfo propInfo;
        Collection<String> retval = null;
        Class<? extends DBObject> objClz = this.m_meta.getObjectClass(objectType);
        if (objClz != null && (propInfo = this.findPropertyInfo(objClz, property)) != null) {
            retval = this.getAllowedReferenceTypes(propInfo);
        }
        return retval;
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(PropertyInfo propInfo) {
        return propInfo == null ? null : propInfo.getAllowedReferenceTypes();
    }

    @Override
    public Collection<String> getAllowedReferenceParentTypes(DBObject obj, String property) {
        Collection<String> retval;
        AbstractPropertyManager base = this.getDelegate();
        if (base != null) {
            retval = base.getAllowedReferenceParentTypes(obj, property);
        } else if (obj instanceof FKConstraint && "referenceID".equals(property)) {
            retval = Collections.singleton("TABLE");
        } else {
            Collection<String> refTypes = this.getAllowedReferenceTypes(obj, property);
            if (refTypes == null) {
                retval = null;
            } else {
                retval = new HashSet<String>();
                for (String type : refTypes) {
                    if ("SCHEMA".equals(type)) continue;
                    retval.addAll(this.m_meta.getOwnerTypes(type));
                }
            }
        }
        return retval;
    }

    @Override
    public Object getImplicitDefaultValue(DBObject obj, String property) {
        return null;
    }

    protected final boolean isProcessorProperty(Class<? extends SystemObject> clz, String prop) {
        DBObjectProvider pro = this.getProvider();
        if (pro != null) {
            for (UpdateProcessor up : pro.getDescriptor().getUpdateProcessors()) {
                if (!up.getProcessorProperties(pro).contains(prop)) continue;
                return true;
            }
        }
        return false;
    }
}

