/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.DynamicPropertyProvider;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.NumberProperty;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.util.ModelUtil;

public abstract class PropertyInfo
implements Comparable {
    public static final String ID = "ID";
    public static final String NAME = "name";

    public abstract String getPropertyName();

    @Deprecated
    public String getPropertyPath() {
        return this.getPropertyName();
    }

    public abstract Class<?> getPropertyClass();

    public Object getPropertyValue(Object bean) {
        Object retval = null;
        if (bean instanceof DBObject) {
            retval = ((DBObject)bean).getProperty(this.getPropertyName());
        }
        return retval;
    }

    public void setPropertyValue(Object bean, Object value) throws Exception {
        if (Boolean.FALSE.equals(value) && this.getNullBehaviour() == Nullable.NullBehaviour.NULL_MEANS_FALSE) {
            value = null;
        } else if (value instanceof DBObject[] && ((DBObject[])value).length == 0) {
            value = null;
        }
        if (bean instanceof DBObject) {
            ((DBObject)bean).setProperty(this.getPropertyName(), value);
        }
    }

    public Class<? extends DBObject> getReferencedClass() {
        Class<?> clz;
        References refs = this.getAnnotation(References.class);
        Class retval = refs == null ? (DBObjectID.class.isAssignableFrom(clz = DBUtil.decodeArrayClass(this.getPropertyClass())) ? DBObject.class : null) : refs.value();
        return retval;
    }

    public String[] getReferencedTypes() {
        References refs = this.getAnnotation(References.class);
        return refs == null ? null : PropertyInfo.getAllowedTypes(refs);
    }

    public boolean isInternalReference() {
        References refInfo = this.getAnnotation(References.class);
        return refInfo == null ? false : refInfo.internal();
    }

    public boolean isGetTransient() {
        return false;
    }

    public boolean isSetTransient() {
        return false;
    }

    @Deprecated
    public boolean isTransient() {
        return this.isGetTransient() || this.isSetTransient();
    }

    public boolean isInternal() {
        return this.getAnnotation(Internal.class) != null;
    }

    public boolean isDerived() {
        return this.getAnnotation(Derived.class) != null;
    }

    public String getDerivedSourceProperty() {
        Derived d = this.getAnnotation(Derived.class);
        return d == null ? null : d.value();
    }

    public boolean isDeprecated() {
        Deprecated d = this.getAnnotation(Deprecated.class);
        return d != null;
    }

    public boolean isSupported(Class<? extends DBObjectProvider> proClz, Class<? extends DBObject> objClz) {
        Class<? extends DBObjectProvider> supportedProClz = this.getProviderClass();
        Collection<Class<? extends DBObject>> supportedObjClzs = this.getObjectClasses();
        boolean retval = true;
        if (proClz != null && supportedProClz != null && !supportedProClz.isAssignableFrom(proClz)) {
            retval = false;
        } else if (supportedObjClzs != null && objClz != null) {
            boolean found = this.containsSuperclass(supportedObjClzs, objClz);
            if (!found) {
                for (Class<? extends DBObject> implClz : Metadata.getInstance().getDefaultImplClasses(objClz)) {
                    if (!this.containsSuperclass(supportedObjClzs, implClz)) continue;
                    found = true;
                    break;
                }
            }
            retval = found;
        }
        return retval;
    }

    private boolean containsSuperclass(Iterable<Class<? extends DBObject>> supportedObjClzs, Class<? extends DBObject> objClz) {
        boolean retval = false;
        for (Class<? extends DBObject> c : supportedObjClzs) {
            if (!c.isAssignableFrom(objClz)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    protected Collection<Class<? extends DBObject>> getObjectClasses() {
        return null;
    }

    protected Class<? extends DBObjectProvider> getProviderClass() {
        return null;
    }

    public DynamicPropertyProvider getDynamicPropertyProvider() {
        return null;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        PropertyInfo info = (PropertyInfo)o;
        if (this.equalsImpl(info)) {
            return 0;
        }
        String name = this.getPropertyName();
        String otherName = info.getPropertyName();
        if (name.equals(ID) && !otherName.equals(ID)) {
            return -100;
        }
        if (otherName.equals(ID)) {
            return 100;
        }
        if (name.equals(NAME) && !otherName.equals(NAME)) {
            return -50;
        }
        if (otherName.equals(NAME)) {
            return 50;
        }
        return name.compareTo(otherName);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((PropertyInfo)o);
    }

    protected abstract boolean equalsImpl(PropertyInfo var1);

    public boolean isStaticReference() {
        return false;
    }

    public boolean isTextMultiLine() {
        TextProperty textInfo = this.getAnnotation(TextProperty.class);
        return textInfo != null && textInfo.multiLine();
    }

    public boolean isTextPassword() {
        TextProperty textInfo = this.getAnnotation(TextProperty.class);
        return textInfo != null && textInfo.password();
    }

    public boolean isTextInternalName() {
        TextProperty textInfo = this.getAnnotation(TextProperty.class);
        return textInfo != null && textInfo.internalName();
    }

    public boolean isNumberUnlimited() {
        return this.getNumberUnlimitedValue() != null;
    }

    public Integer getNumberUnlimitedValue() {
        NumberProperty numberInfo = this.getAnnotation(NumberProperty.class);
        return numberInfo == null || !numberInfo.unlimited() ? null : Integer.valueOf(numberInfo.unlimitedValue());
    }

    public boolean isNumberPhysicalSize() {
        NumberProperty numberInfo = this.getAnnotation(NumberProperty.class);
        return numberInfo != null && numberInfo.physicalSize();
    }

    public CascadeAction getCascadeAction() {
        References refInfo = this.getAnnotation(References.class);
        return refInfo == null ? CascadeAction.UPDATE : refInfo.cascade();
    }

    protected <T extends Annotation> T getAnnotation(Class<T> clz) {
        return null;
    }

    public Nullable.NullBehaviour getNullBehaviour() {
        Class<?> clz;
        Nullable nul = this.getAnnotation(Nullable.class);
        Nullable.NullBehaviour retval = nul == null ? ((clz = this.getPropertyClass()).isPrimitive() || clz.isArray() ? Nullable.NullBehaviour.NOT_NULLABLE : Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED) : nul.value();
        return retval;
    }

    public Collection getAllowedValues() {
        ArrayList<Object> vals = null;
        Class<?> clz = this.getPropertyClass();
        if (clz != null) {
            if (Enum.class.isAssignableFrom(clz)) {
                vals = new ArrayList<Object>();
                try {
                    Method m = clz.getMethod("values", new Class[0]);
                    Object[] enumvals = (Object[])m.invoke(null, new Object[0]);
                    if (this.getNullBehaviour() != Nullable.NullBehaviour.NOT_NULLABLE) {
                        vals.add(null);
                    }
                    for (Object enumval : enumvals) {
                        if (DBUtil.isDeprecated((Enum)enumval)) continue;
                        vals.add(enumval);
                    }
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.WARNING, "Couldn't get enum values", e);
                }
            } else if (Boolean.TYPE.equals(clz) || Boolean.class.equals(clz)) {
                vals = new ArrayList();
                Nullable.NullBehaviour nullBehaviour = this.getNullBehaviour();
                if (Boolean.class.equals(clz) && nullBehaviour != Nullable.NullBehaviour.NOT_NULLABLE && nullBehaviour != Nullable.NullBehaviour.NULL_MEANS_FALSE) {
                    vals.add(null);
                }
                vals.add(true);
                vals.add(false);
            }
        }
        return vals;
    }

    public Collection<String> getAllowedReferenceTypes() {
        TreeSet<String> retval = null;
        if (DBObjectID.class.isAssignableFrom(DBUtil.decodeArrayClass(this.getPropertyClass()))) {
            boolean skipSchema;
            Collection<String> typesToTest;
            retval = new TreeSet<String>();
            Class<? extends DBObject> refClz = this.getReferencedClass();
            String[] infoTypes = this.getReferencedTypes();
            if (refClz != null && DBObject.class.isAssignableFrom(refClz) && (infoTypes == null || infoTypes.length == 0)) {
                typesToTest = Metadata.getInstance().getAllTypes(refClz);
                skipSchema = DBObject.class.equals(refClz) || SystemObject.class.equals(refClz);
            } else {
                typesToTest = Arrays.asList(infoTypes);
                skipSchema = false;
            }
            for (String type : typesToTest) {
                if (skipSchema && "SCHEMA".equals(type)) continue;
                retval.add(type);
            }
        }
        return retval;
    }

    static boolean hasAnnotation(Method method, Class<? extends Annotation> annotation) {
        return method != null && annotation != null && method.getAnnotation(annotation) != null;
    }

    static <T extends Annotation> T findAnnotation(Method method, Class<T> annotation) {
        T retval = null;
        Method am = PropertyInfo.findAnnotatedMethod(method, annotation);
        if (am != null) {
            retval = am.getAnnotation(annotation);
        }
        return retval;
    }

    static Method findAnnotatedMethod(Method method, Class<? extends Annotation> annotation) {
        Method retval;
        block6: {
            retval = null;
            try {
                if (method.isAnnotationPresent(annotation)) {
                    retval = method;
                    break block6;
                }
                if (!annotation.isAnnotationPresent(Inherited.class)) break block6;
                Class<?> clz = method.getDeclaringClass();
                while (clz != null) {
                    for (Class<?> iface : clz.getInterfaces()) {
                        retval = PropertyInfo.getMatchingAnnotatedMethod(method, iface, annotation);
                        if (retval == null) {
                            continue;
                        }
                        break block6;
                    }
                    retval = PropertyInfo.getMatchingAnnotatedMethod(method, clz = clz.getSuperclass(), annotation);
                    if (retval == null) continue;
                    break;
                }
            }
            catch (Throwable e) {
                DBLog.logStackTrace("Reflection error", e);
            }
        }
        return retval;
    }

    private static Method getMatchingAnnotatedMethod(Method method, Class<?> clz, Class<? extends Annotation> annotation) {
        Method retval = null;
        Method iMethod = PropertyInfo.getMatchingMethod(method, clz);
        if (iMethod != null && iMethod.isAnnotationPresent(annotation)) {
            retval = iMethod;
        }
        return retval;
    }

    private static Method getMatchingMethod(Method method, Class<?> clz) {
        if (clz == null) {
            return null;
        }
        try {
            return clz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception e) {
            return null;
        }
    }

    static String[] getAllowedTypes(References refs) {
        return refs == null ? null : refs.types();
    }

    static PropertyInfo createPropertyInfo(PropertyDescriptor desc) {
        return new DescriptorInfo(desc);
    }

    static PropertyInfo createPropertyInfo(String name, Field field) {
        return new FieldInfo(name, field);
    }

    private static class DataTypeAttributeInfo
    extends PropertyInfo {
        private final String m_attributeName;

        DataTypeAttributeInfo(String attributeName) {
            this.m_attributeName = attributeName;
        }

        @Override
        protected boolean equalsImpl(PropertyInfo info) {
            return info instanceof DataTypeAttributeInfo && ModelUtil.areEqual((Object)this.m_attributeName, (Object)((DataTypeAttributeInfo)info).m_attributeName);
        }

        @Override
        public Class<?> getPropertyClass() {
            return Object.class;
        }

        @Override
        public String getPropertyName() {
            return this.m_attributeName;
        }

        @Override
        public void setPropertyValue(Object bean, Object value) throws Exception {
            if (bean instanceof DataTypeUsage) {
                ((DataTypeUsage)bean).putAttributeValue(this.m_attributeName, value);
            }
        }

        @Override
        public Object getPropertyValue(Object bean) {
            Object retval = null;
            if (bean instanceof DataTypeUsage) {
                retval = ((DataTypeUsage)bean).getAttributeValue(this.m_attributeName);
            }
            return retval;
        }
    }

    private static class FieldInfo
    extends PropertyInfo {
        private final Field m_field;
        private final String m_name;

        FieldInfo(String name, Field field) {
            this.m_field = field;
            this.m_name = name;
            if (this.getAnnotation(PropertyKey.class) == null) {
                throw new IllegalArgumentException(this.m_name + " is invalid because its Field doesn't have a @PropertyKey");
            }
        }

        @Override
        protected boolean equalsImpl(PropertyInfo info) {
            return info instanceof FieldInfo && ModelUtil.areEqual((Object)this.m_name, (Object)((FieldInfo)info).m_name) && ModelUtil.areEqual((Object)this.m_field, (Object)((FieldInfo)info).m_field);
        }

        @Override
        public String getPropertyName() {
            return this.m_name;
        }

        @Override
        public Class<?> getPropertyClass() {
            PropertyKey pk = this.getAnnotation(PropertyKey.class);
            return pk.value();
        }

        @Override
        protected <T extends Annotation> T getAnnotation(Class<T> clz) {
            return this.m_field.getAnnotation(clz);
        }

        @Override
        public Class<? extends DBObjectProvider> getProviderClass() {
            PropertyKey pk = this.getAnnotation(PropertyKey.class);
            return pk.provider();
        }

        @Override
        public Collection<Class<? extends DBObject>> getObjectClasses() {
            PropertyKey pk = this.getAnnotation(PropertyKey.class);
            return Arrays.asList(pk.childOf());
        }
    }

    private static class DescriptorInfo
    extends PropertyInfo {
        private Map<Class<? extends Annotation>, Annotation> m_annotations;
        private final PropertyDescriptor m_desc;
        private Boolean m_isGetTransient;
        private Boolean m_isSetTransient;
        private Boolean m_deprecated;

        DescriptorInfo(PropertyDescriptor desc) {
            this.m_desc = desc;
        }

        @Override
        public String getPropertyName() {
            return this.m_desc.getName();
        }

        @Override
        public Class<?> getPropertyClass() {
            return this.m_desc.getPropertyType();
        }

        @Override
        public boolean isGetTransient() {
            if (this.m_isGetTransient == null) {
                Method m = this.m_desc.getReadMethod();
                this.m_isGetTransient = m == null ? false : m.isAnnotationPresent(Transient.class);
            }
            return this.m_isGetTransient;
        }

        @Override
        public boolean isSetTransient() {
            if (this.m_isSetTransient == null) {
                Method m = this.m_desc.getWriteMethod();
                this.m_isSetTransient = m == null ? false : m.isAnnotationPresent(Transient.class);
            }
            return this.m_isSetTransient;
        }

        @Override
        public boolean isDeprecated() {
            if (this.m_deprecated == null) {
                this.m_deprecated = DescriptorInfo.hasAnnotation(this.m_desc.getReadMethod(), Deprecated.class) || DescriptorInfo.hasAnnotation(this.m_desc.getWriteMethod(), Deprecated.class);
            }
            return this.m_deprecated;
        }

        @Override
        public Object getPropertyValue(Object owningObject) {
            try {
                return this.m_desc.getReadMethod().invoke(owningObject, new Object[0]);
            }
            catch (Exception e) {
                Throwable t = e;
                if (e instanceof InvocationTargetException) {
                    t = e.getCause();
                }
                DBLog.logStackTrace(t);
                return super.getPropertyValue(owningObject);
            }
        }

        @Override
        public void setPropertyValue(Object owningObject, Object value) throws Exception {
            Object[] args = new Object[]{value};
            this.m_desc.getWriteMethod().invoke(owningObject, args);
        }

        @Override
        protected boolean equalsImpl(PropertyInfo info) {
            return info instanceof DescriptorInfo && ModelUtil.areEqual((Object)this.m_desc, (Object)((DescriptorInfo)info).m_desc);
        }

        @Override
        protected <T extends Annotation> T getAnnotation(Class<T> clz) {
            Object retval;
            if (this.m_annotations != null && this.m_annotations.containsKey(clz)) {
                retval = this.m_annotations.get(clz);
            } else {
                retval = DescriptorInfo.findAnnotation(this.m_desc.getReadMethod(), clz);
                if (this.m_annotations == null) {
                    this.m_annotations = new HashMap<Class<? extends Annotation>, Annotation>();
                }
                this.m_annotations.put((Class<? extends Annotation>)clz, (Annotation)retval);
            }
            return retval;
        }

        @Override
        protected Collection<Class<? extends DBObject>> getObjectClasses() {
            Set<Class<? extends DBObject>> retval = Collections.singleton(this.m_desc.getReadMethod().getDeclaringClass());
            return retval;
        }

        @Override
        public DynamicPropertyProvider getDynamicPropertyProvider() {
            if ("attributeValues".equals(this.getPropertyName()) && DataTypeUsage.class.equals(this.m_desc.getReadMethod().getDeclaringClass())) {
                return new DynamicPropertyProvider(){

                    @Override
                    public PropertyInfo getPropertyInfo(Class<? extends DBObject> objectClz, String prop, DBObjectProvider pro) {
                        DataTypeAttributeInfo retval = null;
                        if (DataTypeRegistry.getInstance().isRegisteredAttribute(prop)) {
                            retval = new DataTypeAttributeInfo(prop);
                        }
                        return retval;
                    }
                };
            }
            return super.getDynamicPropertyProvider();
        }
    }
}

