/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.util.ModelUtil;

public final class DBObjectTransaction {
    private final DBObjectProvider m_pro;
    private boolean m_replace;
    private boolean m_cascade;
    private boolean m_refactorUpdated;
    private Map<String, Object> m_parameters;
    private final Map<DBObjectID, Difference> m_creates;
    private final Map<DBObjectID, Difference> m_updates;
    private final Map<DBObjectID, Difference> m_deletes;
    private boolean m_processing;
    private List<UpdateProcessor> m_processors;
    private UpdateProcessor m_currentProcessor;
    private final List<Difference> m_pendingProcess;
    private final List<Difference> m_processed;
    private final Map<DBObjectID, Difference> m_originalDiffs;
    private DBException m_exception;
    private Difference m_currentDiff;

    public DBObjectTransaction(DBObjectProvider pro) {
        this.m_pro = pro;
        this.m_pendingProcess = new ArrayList<Difference>();
        this.m_processed = new ArrayList<Difference>();
        this.m_creates = this.newIDMap();
        this.m_updates = this.newIDMap();
        this.m_deletes = this.newIDMap();
        this.m_originalDiffs = this.newIDMap();
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    private Map<DBObjectID, Difference> newIDMap() {
        return new DBObjectIDMap<Difference>(true);
    }

    public boolean isReplace() {
        return this.m_replace;
    }

    public void setReplace(boolean replace) {
        this.m_replace = replace;
    }

    public boolean isCascade() {
        return this.m_cascade;
    }

    public void setCascade(boolean cascade) {
        this.m_cascade = cascade;
    }

    public void setRefactorUpdatedObject(boolean refactorUpdated) {
        this.m_refactorUpdated = refactorUpdated;
    }

    public void addParameter(Object parameter) {
        if (parameter != null) {
            if (this.m_parameters == null) {
                this.m_parameters = new HashMap<String, Object>();
            }
            this.m_parameters.put(parameter.getClass().getName(), parameter);
        }
    }

    public <T> T getParameter(Class<T> parameterClz) {
        return (T)(this.m_parameters == null ? null : this.m_parameters.get(parameterClz.getName()));
    }

    public DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public void commit() throws DBException {
        this.m_pro.commitTransaction(this);
    }

    public void addException(DBException dbe) {
        if (this.m_exception == null) {
            this.m_exception = dbe;
        } else {
            this.m_exception.setNextException(dbe);
        }
    }

    private void checkException() throws DBException {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
    }

    public boolean isCurrentObject(DBObjectID id) {
        SystemObject orig;
        boolean retval = false;
        if (this.m_currentDiff != null && (orig = (SystemObject)this.m_currentDiff.getOriginalObject()) != null) {
            retval = ModelUtil.areEqual((Object)id, (Object)orig.getID());
        }
        return retval;
    }

    public SystemObject getDiffUpdatedObject(Difference objDiff) {
        return this.getDiffUpdatedObject(objDiff, false);
    }

    private SystemObject getDiffUpdatedObject(Difference objDiff, boolean forceCopy) {
        SystemObject retval = null;
        if (forceCopy || objDiff.isFiltered()) {
            retval = this.getCopyOfOrigWithDiffApplied(objDiff);
        }
        if (retval == null) {
            retval = (SystemObject)objDiff.getUpdatedObject();
        }
        return retval;
    }

    private SystemObject getCopyOfOrigWithDiffApplied(Difference objDiff) {
        SystemObject retval = null;
        try {
            DifferenceApplier applier = new DifferenceApplier(this.m_pro);
            retval = applier.getCopyOfOrigWithDiffApplied(objDiff);
        }
        catch (Exception e) {
            this.getLogger().log(DBLog.getExceptionLogLevel(), "Failed to create copy of original object", e);
        }
        return retval;
    }

    public void includeListDifference(Difference listDiff) {
        if (!listDiff.isList()) {
            throw new IllegalStateException("listDiff must be a Difference of type LIST");
        }
        for (Difference difference : listDiff.getChildren()) {
            this.includeObjectDifference(difference);
        }
    }

    public void includeUpdate(SystemObject updatedObject) {
        Difference diff = this.findExistingUpdate(updatedObject);
        SystemObject orig = null;
        if (diff == null) {
            try {
                DBObject origFromID;
                SystemObject lookup = updatedObject;
                DBObjectID id = updatedObject.getID();
                if (id instanceof TemporaryObjectID && (origFromID = TemporaryObjectID.findOriginalObject((TemporaryObjectID)id)) instanceof SystemObject) {
                    lookup = (SystemObject)origFromID;
                }
                orig = DBUtil.getProviderDefinition(lookup, this.getProvider());
            }
            catch (DBException dbe) {
                this.getLogger().warning("Couldn't get object definition: " + dbe.getMessage());
            }
        } else {
            orig = (SystemObject)diff.getOriginalObject();
        }
        this.includeUpdate(orig, updatedObject);
    }

    public void includeUpdate(SystemObject oldObject, SystemObject newObject) {
        DBObjectID id;
        if (newObject == null && (id = oldObject.getID()) instanceof TemporaryObjectID) {
            oldObject = (SystemObject)TemporaryObjectID.findOriginalObject((TemporaryObjectID)id);
        }
        Difference diff = this.difference(oldObject, newObject);
        this.includeObjectDifference(diff);
    }

    public Difference difference(SystemObject oldObject, SystemObject newObject) {
        return this.m_pro.getDiffEngine().difference(oldObject, newObject);
    }

    public Difference findExistingUpdate(Difference newDiff) {
        DBObjectID id;
        SystemObject obj;
        Difference retval = null;
        if (newDiff != null && (obj = (SystemObject)newDiff.getOriginalObject()) != null && (id = obj.getID()) != null) {
            retval = this.m_updates.get(id);
        }
        return retval;
    }

    public void includeObjectDifference(Difference objDiff) {
        SystemObject origObject = (SystemObject)objDiff.getOriginalObject();
        Difference oldDiff = null;
        boolean include = false;
        DBObjectID id = this.getMapKey(objDiff);
        if (objDiff.isSame() && !this.isReplace()) {
            if (origObject != null && this.findExistingUpdate(origObject) != null) {
                this.getLogger().warning("Overridding update included for " + origObject + " but there are no differences - ignoring.");
            }
        } else if (origObject == null) {
            SystemObject createMe = (SystemObject)objDiff.getUpdatedObject();
            oldDiff = this.m_creates.put(id, objDiff);
            include = true;
        } else if (objDiff.getUpdatedObject() == null) {
            boolean alreadyDeleted = this.m_deletes.containsKey(id);
            this.m_deletes.put(id, objDiff);
            if (!alreadyDeleted) {
                if (this.isCurrentObject(id)) {
                    this.getLogger().severe("Deleting the current object is not allowed");
                } else {
                    include = true;
                    if (this.m_updates.remove(id) != null) {
                        this.getLogger().fine("Deleting existing update for " + id);
                    }
                }
            }
        } else {
            include = true;
            oldDiff = this.m_updates.put(id, objDiff);
            if (oldDiff != null && oldDiff.getUpdatedObject() != objDiff.getUpdatedObject() && this.m_processing) {
                include = false;
                SystemObject existingUpdate = this.getDiffUpdatedObject(oldDiff, true);
                IdentityHashMap<DBObject, DBObject> renames = new IdentityHashMap<DBObject, DBObject>();
                IdentityHashMap<DBObject, DBObject> renamesInvert = new IdentityHashMap<DBObject, DBObject>();
                this.pretendIsOriginal(existingUpdate, renames, renamesInvert);
                SystemObject newUpdate = this.getDiffUpdatedObject(objDiff);
                this.resetOriginalObjects(newUpdate, renames);
                Difference delta = this.difference(existingUpdate, newUpdate);
                this.resetOriginalObjects(newUpdate, renamesInvert);
                if (!delta.isSame()) {
                    this.processObjectDifference(objDiff, delta);
                }
            }
        }
        if (oldDiff != null) {
            if (oldDiff == this.m_currentDiff) {
                this.m_currentDiff = objDiff;
                include = false;
            } else {
                this.m_processed.remove(oldDiff);
            }
        }
        if (include) {
            if (this.m_processing) {
                this.processObjectDifference(objDiff, null);
            } else {
                this.m_pendingProcess.add(objDiff);
                this.m_originalDiffs.put(id, objDiff);
            }
        }
    }

    private void resetOriginalObjects(DBObject obj, Map<DBObject, DBObject> mapping) {
        DBObject newOrig;
        DBObjectID id = obj.getID();
        if (id instanceof TemporaryObjectID && (newOrig = mapping.get(((TemporaryObjectID)id).getOriginalObject())) != null) {
            obj.setID(TemporaryObjectID.createID(obj, newOrig));
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            this.resetOriginalObjects(kid, mapping);
        }
    }

    public boolean containsUpdate(String type, String schema, String name) {
        NameBasedID id = new NameBasedID(type, schema, name);
        return this.m_creates.containsKey(id) || this.m_updates.containsKey(id);
    }

    private List<UpdateProcessor> getUpdateProcessors() {
        if (this.m_processors == null) {
            this.m_processors = this.getProvider().getDescriptor().getUpdateProcessors();
        }
        return this.m_processors;
    }

    public void setUpdateProcessors(List<UpdateProcessor> processors) {
        this.m_processors = processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processObjectDifference(Difference objDiff, Difference deltaDiff) {
        if (!this.m_processing) throw new IllegalStateException("Cannot process a diff when we're not processing");
        UpdateProcessor currentProcessor = this.m_currentProcessor;
        Difference currentDiff = this.m_currentDiff;
        DBObjectID currentKey = currentDiff == null ? null : this.getMapKey(currentDiff);
        DBObjectID incomingKey = this.getMapKey(objDiff);
        boolean recursiveUpdate = incomingKey.equals(currentKey, true);
        try {
            this.m_currentDiff = objDiff;
            Iterator<UpdateProcessor> iterator = this.getUpdateProcessors().iterator();
            while (iterator.hasNext()) {
                UpdateProcessor up;
                this.m_currentProcessor = up = iterator.next();
                if (this.m_currentDiff == null) continue;
                if (deltaDiff == null) {
                    up.processUpdate(this, this.m_currentDiff);
                    continue;
                }
                if (up.onlyProcessesPrimaryUpdates()) continue;
                up.processUpdate(this, deltaDiff);
            }
            if (this.m_currentDiff == null) return;
            Integer existingIndex = null;
            for (int i = 0; i < this.m_processed.size(); ++i) {
                Difference alreadyProcessed = this.m_processed.get(i);
                if (!this.getMapKey(alreadyProcessed).equals(incomingKey)) continue;
                existingIndex = i;
                break;
            }
            if (existingIndex == null) {
                this.m_processed.add(this.m_currentDiff);
                return;
            } else {
                this.m_processed.set(existingIndex, this.m_currentDiff);
            }
            return;
        }
        catch (DBException dbe) {
            this.addException(dbe);
            return;
        }
        finally {
            this.m_currentDiff = recursiveUpdate ? null : currentDiff;
            this.m_currentProcessor = currentProcessor;
        }
    }

    private void pretendIsOriginal(DBObject obj, Map<DBObject, DBObject> renames, Map<DBObject, DBObject> renamesInvert) {
        DBObjectID origID;
        DBObject orig = TemporaryObjectID.findOriginalObject(obj);
        DBObjectID dBObjectID = origID = orig == null ? null : orig.getID();
        if (origID != null) {
            String name;
            if (origID instanceof NameBasedID && ModelUtil.areDifferent((Object)(name = obj.getName()), (Object)((NameBasedID)origID).getName())) {
                NameBasedID newID = (NameBasedID)origID.copyTo(null);
                newID.setName(name);
                renames.put(orig, obj);
                renamesInvert.put(obj, orig);
            }
            obj.setID(origID);
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            this.pretendIsOriginal(kid, renames, renamesInvert);
        }
    }

    public void removeUpdate(Difference objDiff) {
        DBObjectID id = this.getMapKey(objDiff);
        this.removeFromProcess(this.m_creates.remove(id));
        this.removeFromProcess(this.m_deletes.remove(id));
        this.removeFromProcess(this.m_updates.remove(id));
        this.removeFromProcess(this.m_originalDiffs.remove(id));
    }

    private void removeFromProcess(Difference foundDiff) {
        if (foundDiff != null) {
            this.m_pendingProcess.remove(foundDiff);
            this.m_processed.remove(foundDiff);
            if (foundDiff == this.m_currentDiff) {
                this.m_currentDiff = null;
            }
        }
    }

    public Collection<DBObjectID> getDeleteIDs() {
        return Collections.unmodifiableCollection(this.m_deletes.keySet());
    }

    public Collection<DBObjectID> getCreateIDs() {
        return Collections.unmodifiableCollection(this.m_creates.keySet());
    }

    public Collection<DBObjectID> getUpdateIDs() {
        return Collections.unmodifiableCollection(this.m_updates.keySet());
    }

    public Difference findExistingUpdate(SystemObject obj) {
        DBObjectID id;
        DBObjectID dBObjectID = id = obj == null ? null : obj.getID();
        if (id instanceof TemporaryObjectID) {
            id = TemporaryObjectID.findOriginalID((TemporaryObjectID)id);
        }
        return this.m_updates.get(id);
    }

    public SystemObject getCopyForUpdate(SystemObject obj) {
        SystemObject retval;
        if (obj == null) {
            retval = null;
        } else {
            Difference objDiff = this.findExistingUpdate(obj);
            if (objDiff == null) {
                retval = DBUtil.makeTemporaryCopy(obj);
            } else {
                boolean forceCopy = this.isTempCopy(objDiff);
                retval = this.getDiffUpdatedObject(objDiff, forceCopy);
            }
        }
        return retval;
    }

    private boolean isTempCopy(Difference objDiff) {
        SystemObject orig = (SystemObject)objDiff.getOriginalObject();
        SystemObject upd = (SystemObject)objDiff.getUpdatedObject();
        DBObjectID updID = upd.getID();
        return updID instanceof TemporaryObjectID && TemporaryObjectID.findOriginalObject((TemporaryObjectID)updID) == orig;
    }

    private DBObjectID getMapKey(Difference objDiff) {
        SystemObject orig = (SystemObject)objDiff.getOriginalObject();
        DBObjectID retval = orig == null ? new NameBasedID((DBObject)((SystemObject)objDiff.getUpdatedObject()), (AbstractDBObjectProvider)this.getProvider()) : orig.getID();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Difference getTransactionDifference() throws DBException {
        this.checkException();
        try {
            this.m_processing = true;
            ArrayList<Difference> processList = new ArrayList<Difference>(this.m_pendingProcess);
            this.m_pendingProcess.clear();
            for (Difference objDiff : processList) {
                this.processObjectDifference(objDiff, null);
            }
        }
        finally {
            this.m_processing = false;
        }
        this.checkException();
        int totSize = this.m_processed.size();
        SystemObject[] newOrigs = new SystemObject[totSize];
        SystemObject[] newUpds = new SystemObject[totSize];
        ResultSet listDiff = new ResultSet(null, newOrigs, (Object)newUpds, null, "LIST");
        boolean same = true;
        int i = 0;
        for (Difference objDiff : this.m_processed) {
            SystemObject upd;
            DBObjectID key;
            Difference origDiff;
            ResultSet objRS;
            newOrigs[i] = (SystemObject)objDiff.getOriginalObject();
            if (objDiff instanceof ResultSet) {
                objRS = (ResultSet)objDiff;
            } else {
                SystemObject newUpd = this.getDiffUpdatedObject(objDiff);
                objRS = (ResultSet)this.difference(newOrigs[i], newUpd);
            }
            newUpds[i] = (SystemObject)objRS.getUpdatedObject();
            listDiff.addToList(objRS);
            same &= objRS.isSame();
            if (this.m_refactorUpdated && (origDiff = this.m_originalDiffs.get(key = this.getMapKey(objRS))) != null && (upd = (SystemObject)origDiff.getUpdatedObject()) != null && upd != newUpds[i]) {
                newUpds[i].copyTo((DBObject)upd, false);
            }
            ++i;
        }
        listDiff.setSame(same);
        return listDiff;
    }
}

