/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBObjectUsage
extends AbstractFromObjectUsage
implements DBObjectUsage {
    protected AbstractDBObjectUsage() {
    }

    protected AbstractDBObjectUsage(DBObjectID id, DBObjectID fromID) {
        super(fromID);
        this.setObjectID(id);
    }

    @Override
    public void setObjectID(DBObjectID objectID) {
        this.setProperty("objectID", objectID);
    }

    @Override
    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    @Override
    public String getColumnName() {
        DBObjectID objectID = this.getObjectID();
        String retval = null;
        if (objectID != null) {
            String name;
            if (objectID instanceof BaseObjectID && ModelUtil.hasLength((String)(name = ((BaseObjectID)objectID).getName()))) {
                retval = this.getExternalName(name, "COLUMN");
            }
            if (!ModelUtil.hasLength(retval)) {
                try {
                    DBObject obj = objectID.resolveID();
                    if (obj != null) {
                        retval = this.getExternalName(obj.getName(), "COLUMN");
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger(this).warning("Couldn't resolve ID to get SQL text: " + dbe.getMessage());
                }
            }
        }
        return retval;
    }
}

