/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;

public class CaseStatement
extends AbstractSQLFragment {
    public static final String CASE = "CASE";
    public static final String WHEN = "WHEN";
    public static final String THEN = "THEN";
    public static final String ELSE = "ELSE";
    public static final String END = "END";

    public CaseStatement() {
    }

    public CaseStatement(SQLFragment expression, WhenThen[] whenThens, SQLFragment elseExpression) {
        this.setExpression(expression);
        this.setWhenThens(whenThens);
        this.setElseExpression(elseExpression);
    }

    public CaseStatement(SQLFragment expression, WhenThen[] whenThens) {
        this.setExpression(expression);
        this.setWhenThens(whenThens);
    }

    public CaseStatement(WhenThen[] whenThens, SQLFragment elseExpression) {
        this.setWhenThens(whenThens);
        this.setElseExpression(elseExpression);
    }

    public CaseStatement(WhenThen[] whenThens) {
        this.setWhenThens(whenThens);
    }

    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    public void setExpression(SQLFragment expression) {
        this.setProperty("expression", expression);
    }

    public WhenThen[] getWhenThens() {
        return this.getChildSupport("whenThens").getChildArray(WhenThen.class);
    }

    public void setWhenThens(WhenThen[] whenThens) {
        this.getChildSupport("whenThens").setChildArray(whenThens);
    }

    public SQLFragment getElseExpression() {
        return (SQLFragment)this.getProperty("elseExpression");
    }

    public void setElseExpression(SQLFragment elseExpression) {
        this.setProperty("elseExpression", elseExpression);
    }

    @Override
    public String getSQLText() {
        SQLFragment elseExpression;
        StringBuilder sql = new StringBuilder();
        SQLFragment expression = this.getExpression();
        sql.append(CASE).append(" ");
        if (expression != null) {
            sql.append(expression.getSQLText()).append(" ");
        }
        sql.append("\n");
        WhenThen[] whenThens = this.getWhenThens();
        if (whenThens != null) {
            for (WhenThen whenThen : whenThens) {
                sql.append(" ").append(" ");
                sql.append(whenThen.getSQLText());
                sql.append("\n");
            }
        }
        if ((elseExpression = this.getElseExpression()) != null) {
            sql.append(" ").append(" ");
            sql.append(ELSE).append(" ").append(elseExpression.getSQLText());
            sql.append(" ").append("\n");
        }
        sql.append(END);
        return sql.toString();
    }

    public static class WhenThen
    extends AbstractSQLFragment {
        public WhenThen() {
        }

        public WhenThen(SQLFragment condition, SQLFragment result) {
            this.setWhenExpression(condition);
            this.setThenExpression(result);
        }

        public void setWhenExpression(SQLFragment whenExpression) {
            this.setProperty("whenExpression", whenExpression);
        }

        public SQLFragment getWhenExpression() {
            return (SQLFragment)this.getProperty("whenExpression");
        }

        public void setThenExpression(SQLFragment thenExpression) {
            this.setProperty("thenExpression", thenExpression);
        }

        public SQLFragment getThenExpression() {
            return (SQLFragment)this.getProperty("thenExpression");
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            sql.append(CaseStatement.WHEN).append(" ");
            sql.append(this.getTextOrNull(this.getWhenExpression())).append(" ");
            sql.append(CaseStatement.THEN).append(" ");
            sql.append(this.getTextOrNull(this.getThenExpression())).append(" ");
            return sql.toString();
        }
    }
}

