/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

public class ModelObject
extends AbstractSQLFragment {
    public static final String TYPE = "MODEL";
    private static final String IGNORE = "IGNORE";
    private static final String KEEP = "KEEP";
    private static final String NAV = "NAV";
    private static final String UNIQUE = "UNIQUE";
    private static final String DIMENSION = "DIMENSION";
    private static final String SINGLE = "SINGLE";
    private static final String REFERENCE = "REFERENCE";
    private static final String RETURN = "RETURN";
    private static final String UPDATED = "UPDATED";
    private static final String ALL = "ALL";
    private static final String ROWS = "ROWS";
    private static final String PARTITION_BY = "PARTITION BY";
    private static final String DIMENSION_BY = "DIMENSION BY";
    private static final String MEASURES = "MEASURES";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    private static final String EQUALS = "=";
    private static final String ON = "ON";
    private static final String MAIN = "MAIN";
    private static final String RULES = "RULES";
    private static final String UPDATE = "UPDATE";
    private static final String UPSERT = "UPSERT";
    private static final String AUTOMATIC = "AUTOMATIC";
    private static final String SEQUENTIAL = "SEQUENTIAL";
    private static final String ORDER = "ORDER";
    private static final String ITERATE = "ITERATE";
    private static final String UNTIL = "UNTIL";
    private static final String LEFT_SQUARE_BRACKET = "[";
    private static final String RIGHT_SQUARE_BRACKET = "]";
    private static final String COMMA = ",";
    private static final String FOR = "FOR";
    private static final String IN = "IN";
    private static final String LIKE = "LIKE";
    private static final String FROM = "FROM";
    private static final String TO = "TO";
    private static final String INCREMENT = "INCREMENT";
    private static final String DECREMENT = "DECREMENT";

    public ModelObject() {
        this.setReturnUpdatedRows(this.getReturnUpdatedRows());
        this.setReturnAllRows(this.getReturnAllRows());
    }

    public void setCellReferenceOptions(CellReferenceOptions cellReferenceOptions) {
        this.setProperty("cellReferenceOptions", cellReferenceOptions);
    }

    public CellReferenceOptions getCellReferenceOptions() {
        return (CellReferenceOptions)this.getProperty("cellReferenceOptions");
    }

    public void setReturnUpdatedRows(boolean returnUpdatedRows) {
        this.setProperty("returnUpdatedRows", returnUpdatedRows);
    }

    public boolean getReturnUpdatedRows() {
        return (Boolean)this.getProperty("returnUpdatedRows", false);
    }

    public void setReturnAllRows(boolean returnAllRows) {
        this.setProperty("returnAllRows", returnAllRows);
    }

    public boolean getReturnAllRows() {
        return (Boolean)this.getProperty("returnAllRows", false);
    }

    public void setReferenceModels(SQLFragment[] referenceModels) {
        this.getChildSupport("referenceModels").setChildArray(referenceModels);
    }

    public SQLFragment[] getReferenceModels() {
        return this.getChildSupport("referenceModels").getChildArray(SQLFragment.class);
    }

    public void setMainModelName(String mainModelName) {
        this.setProperty("mainModelName", mainModelName);
    }

    public String getMainModelName() {
        return (String)this.getProperty("mainModelName");
    }

    public void setModelColumnClauses(SQLFragment modelColumnClauses) {
        this.setProperty("modelColumnClauses", modelColumnClauses);
    }

    public SQLFragment getModelColumnClauses() {
        return (SQLFragment)this.getProperty("modelColumnClauses");
    }

    public void setMainModelCellReferenceOptions(SQLFragment mainModelCellReferenceOptions) {
        this.setProperty("mainModelCellReferenceOptions", mainModelCellReferenceOptions);
    }

    public SQLFragment getMainModelCellReferenceOptions() {
        return (SQLFragment)this.getProperty("mainModelCellReferenceOptions");
    }

    public void setModelRulesClause(SQLFragment modelRulesClause) {
        this.setProperty("modelRulesClause", modelRulesClause);
    }

    public SQLFragment getModelRulesClause() {
        return (SQLFragment)this.getProperty("modelRulesClause");
    }

    @Override
    public String getSQLText() {
        StringBuilder sql = new StringBuilder();
        sql.append(TYPE);
        if (this.getCellReferenceOptions() != null) {
            CellReferenceOptions cellReferenceOptions = this.getCellReferenceOptions();
            sql.append(" ").append(cellReferenceOptions.getSQLText());
        }
        if (this.getReturnUpdatedRows()) {
            sql.append(" ").append(RETURN).append(" ").append(" ").append(UPDATED).append(" ").append(ROWS).append("\n");
        } else if (this.getReturnAllRows()) {
            sql.append(" ").append(RETURN).append(" ").append(" ").append(ALL).append(" ").append(ROWS).append("\n");
        }
        SQLFragment[] referenceModels = this.getReferenceModels();
        if (referenceModels != null) {
            for (SQLFragment referenceModel : referenceModels) {
                sql.append(" ").append(referenceModel.getSQLText());
            }
        }
        String mainModelName = this.getMainModelName();
        SQLFragment modelColumnClauses = this.getModelColumnClauses();
        SQLFragment cellReferenceOptions = this.getMainModelCellReferenceOptions();
        SQLFragment modelRulesClause = this.getModelRulesClause();
        sql.append(" ");
        if (ModelUtil.hasLength((String)mainModelName)) {
            sql.append(MAIN).append(" ").append(mainModelName);
        }
        sql.append(" ").append(modelColumnClauses.getSQLText());
        if (cellReferenceOptions != null) {
            sql.append(" ").append(cellReferenceOptions.getSQLText());
        }
        sql.append(" ").append(modelRulesClause.getSQLText());
        return sql.toString();
    }

    public static class MultiColumnForLoop
    extends AbstractSQLFragment {
        public void setDimensionColumns(ExpressionList dimensionColumns) {
            this.setProperty("dimensionColumns", dimensionColumns);
        }

        public ExpressionList getDimensionColumns() {
            return (ExpressionList)this.getProperty("dimensionColumns");
        }

        public void setLiterals(ExpressionList literals) {
            this.setProperty("literals", literals);
        }

        public ExpressionList getLiterals() {
            return (ExpressionList)this.getProperty("literals");
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            ExpressionList literals = this.getLiterals();
            boolean addParen = literals.getArgumentCount() == 1;
            sql.append(ModelObject.FOR).append(" ").append(this.getDimensionColumns().getSQLText());
            sql.append(" ").append(ModelObject.IN).append(" ");
            if (addParen) {
                sql.append(ModelObject.LEFT_PAREN).append(" ");
            }
            sql.append(literals.getSQLText());
            if (addParen) {
                sql.append(ModelObject.RIGHT_PAREN).append(" ");
            }
            return sql.toString();
        }
    }

    public static class SingleColumnForLoop
    extends AbstractSQLFragment {
        public void setDimensionColumn(String dimensionColumn) {
            this.setProperty("dimensionColumn", dimensionColumn);
        }

        public String getDimensionColumn() {
            return (String)this.getProperty("dimensionColumn");
        }

        public void setInExpressionList(ExpressionList inExpressionList) {
            this.setProperty("inExpressionList", inExpressionList);
        }

        public ExpressionList getInExpressionList() {
            return (ExpressionList)this.getProperty("inExpressionList");
        }

        public void setLikePattern(String likePattern) {
            this.setProperty("likePattern", likePattern);
        }

        public String getLikePattern() {
            return (String)this.getProperty("likePattern");
        }

        public void setFromLiteral(String fromLiteral) {
            this.setProperty("fromLiteral", fromLiteral);
        }

        public String getFromLiteral() {
            return (String)this.getProperty("fromLiteral");
        }

        public void setToLiteral(String toLiteral) {
            this.setProperty("toLiteral", toLiteral);
        }

        public String getToLiteral() {
            return (String)this.getProperty("toLiteral");
        }

        public void setIncrementLiteral(String literal) {
            this.setProperty("incrementLiteral", literal);
        }

        public String getIncrementLiteral() {
            return (String)this.getProperty("incrementLiteral");
        }

        public void setDecrementLiteral(String literal) {
            this.setProperty("decrementLiteral", literal);
        }

        public String getDecrementLiteral() {
            return (String)this.getProperty("decrementLiteral");
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            sql.append(ModelObject.FOR).append(" ").append(this.getDimensionColumn());
            ExpressionList inExpressionList = this.getInExpressionList();
            if (inExpressionList != null) {
                sql.append(" ").append(ModelObject.IN).append(inExpressionList.getSQLText());
            } else {
                String likePattern = this.getLikePattern();
                if (ModelUtil.hasLength((String)likePattern)) {
                    sql.append(" ").append(ModelObject.LIKE).append(likePattern);
                }
                sql.append(" ").append(ModelObject.FROM).append(" ").append(this.getFromLiteral());
                sql.append(" ").append(ModelObject.TO).append(" ").append(this.getToLiteral());
                String literal = this.getIncrementLiteral();
                if (ModelUtil.hasLength((String)literal)) {
                    sql.append(" ").append(ModelObject.INCREMENT);
                } else {
                    literal = this.getDecrementLiteral();
                    sql.append(" ").append(ModelObject.DECREMENT);
                }
                sql.append(" ").append(literal);
            }
            return sql.toString();
        }
    }

    public static class CellAssignment
    extends AbstractSQLFragment {
        public void setMeasureColumn(String measureColumn) {
            this.setProperty("measureColumn", measureColumn);
        }

        public String getMeasureColumn() {
            return (String)this.getProperty("measureColumn");
        }

        public void setCellAssignment(SQLFragment[] exprs) {
            this.getChildSupport("cellAssignment").setChildArray(exprs);
        }

        public SQLFragment[] getCellAssignment() {
            return this.getChildSupport("cellAssignment").getChildArray(SQLFragment.class);
        }

        @Override
        public String getSQLText() {
            SQLFragment[] exprs;
            StringBuilder sql = new StringBuilder();
            sql.append(this.getMeasureColumn()).append(" ").append(ModelObject.LEFT_SQUARE_BRACKET);
            boolean first = true;
            for (SQLFragment expr : exprs = this.getCellAssignment()) {
                if (first) {
                    first = false;
                } else {
                    sql.append(ModelObject.COMMA).append(" ");
                }
                sql.append(expr.getSQLText());
            }
            sql.append(ModelObject.RIGHT_SQUARE_BRACKET);
            return sql.toString();
        }
    }

    public static class ModelRulesCellAssignmentExpr
    extends AbstractSQLFragment {
        public ModelRulesCellAssignmentExpr() {
            this.setUpdate(this.getUpdate());
            this.setUpsert(this.getUpsert());
            this.setAll(this.getAll());
        }

        public void setUpdate(boolean update) {
            this.setProperty("update", update);
        }

        public boolean getUpdate() {
            return (Boolean)this.getProperty("update", false);
        }

        public void setUpsert(boolean upsert) {
            this.setProperty("upsert", upsert);
        }

        public boolean getUpsert() {
            return (Boolean)this.getProperty("upsert", false);
        }

        public void setAll(boolean all) {
            this.setProperty("all", all);
        }

        public boolean getAll() {
            return (Boolean)this.getProperty("all", false);
        }

        public void setModelRulesCellAssignment(SQLFragment cellAssignment) {
            this.setProperty("modelRulesCellAssignment", cellAssignment);
        }

        public SQLFragment getModelRulesCellAssignment() {
            return (SQLFragment)this.getProperty("modelRulesCellAssignment");
        }

        public void setOrderBy(SQLFragment orderBy) {
            this.setProperty("orderBy", orderBy);
        }

        public SQLFragment getOrderBy() {
            return (SQLFragment)this.getProperty("orderBy");
        }

        public void setExpr(SQLFragment expr) {
            this.setProperty("expr", expr);
        }

        public SQLFragment getExpr() {
            return (SQLFragment)this.getProperty("expr");
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            if (this.getUpdate()) {
                sql.append(ModelObject.UPDATE);
                sql.append(" ");
            } else if (this.getUpsert()) {
                sql.append(ModelObject.UPSERT);
                if (this.getAll()) {
                    sql.append(ModelObject.ALL);
                }
                sql.append(" ");
            }
            sql.append(this.getModelRulesCellAssignment().getSQLText());
            SQLFragment orderBy = this.getOrderBy();
            if (orderBy != null) {
                sql.append(" ").append(orderBy.getSQLText());
            }
            sql.append(" ").append(ModelObject.EQUALS).append(" ");
            sql.append(this.getExpr().getSQLText());
            sql.append(" ").append("\n");
            return sql.toString();
        }
    }

    public static class ModelRulesClause
    extends AbstractSQLFragment {
        public ModelRulesClause() {
            this.setRulesPresent(this.getRulesPresent());
            this.setRulesUpdate(this.getRulesUpdate());
            this.setRulesUpsert(this.getRulesUpsert());
            this.setRulesAll(this.getRulesAll());
            this.setAutomatic(this.getAutomatic());
            this.setSequential(this.getSequential());
            this.setOrder(this.getOrder());
        }

        public void setRulesPresent(boolean rules) {
            this.setProperty("rulesPresent", rules);
        }

        public boolean getRulesPresent() {
            return (Boolean)this.getProperty("rulesPresent", false);
        }

        public void setRulesUpdate(boolean update) {
            this.setProperty("rulesUpdate", update);
        }

        public boolean getRulesUpdate() {
            return (Boolean)this.getProperty("rulesUpdate", false);
        }

        public void setRulesUpsert(boolean upsert) {
            this.setProperty("rulesUpsert", upsert);
        }

        public boolean getRulesUpsert() {
            return (Boolean)this.getProperty("rulesUpsert", false);
        }

        public void setRulesAll(boolean all) {
            this.setProperty("rulesAll", all);
        }

        public boolean getRulesAll() {
            return (Boolean)this.getProperty("rulesAll", false);
        }

        public void setAutomatic(boolean automatic) {
            this.setProperty("automatic", automatic);
        }

        public boolean getAutomatic() {
            return (Boolean)this.getProperty("automatic", false);
        }

        public void setSequential(boolean sequential) {
            this.setProperty("sequential", sequential);
        }

        public boolean getSequential() {
            return (Boolean)this.getProperty("sequential", false);
        }

        public void setOrder(boolean order) {
            this.setProperty("order", order);
        }

        public boolean getOrder() {
            return (Boolean)this.getProperty("order", false);
        }

        public void setIterateNumber(String number) {
            this.setProperty("iterateNumber", number);
        }

        public String getIterateNumber() {
            return (String)this.getProperty("iterateNumber");
        }

        public void setUntilCondition(SQLFragment condition) {
            this.setProperty("untilCondition", condition);
        }

        public SQLFragment getUntilCondition() {
            return (SQLFragment)this.getProperty("untilCondition");
        }

        public void setCellAssignmentExprs(ExpressionList cellAssignmentExprs) {
            this.setProperty("cellAssignmentExprs", cellAssignmentExprs);
        }

        public ExpressionList getCellAssignmentExprs() {
            return (ExpressionList)this.getProperty("cellAssignmentExprs");
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            if (this.getRulesPresent()) {
                String iterateNumber;
                sql.append(ModelObject.RULES);
                if (this.getRulesUpdate()) {
                    sql.append(" ").append(ModelObject.UPDATE);
                } else if (this.getRulesUpsert()) {
                    sql.append(" ").append(ModelObject.UPSERT);
                    if (this.getRulesAll()) {
                        sql.append(" ").append(ModelObject.ALL);
                    }
                }
                if (this.getAutomatic()) {
                    sql.append(" ").append(ModelObject.AUTOMATIC);
                } else if (this.getSequential()) {
                    sql.append(" ").append(ModelObject.SEQUENTIAL);
                }
                if (this.getOrder()) {
                    sql.append(" ").append(ModelObject.ORDER);
                }
                if ((iterateNumber = this.getIterateNumber()) != null) {
                    sql.append(" ").append(ModelObject.ITERATE).append(" ").append(ModelObject.LEFT_PAREN).append(iterateNumber).append(ModelObject.RIGHT_PAREN);
                    SQLFragment condition = this.getUntilCondition();
                    if (condition != null) {
                        sql.append(" ").append(ModelObject.UNTIL).append(" ").append(ModelObject.LEFT_PAREN).append(condition.getSQLText()).append(ModelObject.RIGHT_PAREN);
                    }
                }
            }
            StringBuilder append = sql.append("\n");
            ExpressionList cellAssignmentExpressions = this.getCellAssignmentExprs();
            sql.append(" ").append(cellAssignmentExpressions.getSQLText());
            return sql.toString();
        }
    }

    public static class ReferenceModel
    extends AbstractSQLFragment {
        public void setReferenceModelName(String name) {
            this.setProperty("referenceModelName", name);
        }

        public String getReferenceModelName() {
            return (String)this.getProperty("referenceModelName");
        }

        public void setSubquery(SQLQuery subQuery) {
            this.setProperty("subquery", subQuery);
        }

        public SQLQuery getSubquery() {
            return (SQLQuery)this.getProperty("subquery");
        }

        public void setModelColumnClauses(SQLFragment modelColumnClauses) {
            this.setProperty("modelColumnClauses", modelColumnClauses);
        }

        public SQLFragment getModelColumnClauses() {
            return (SQLFragment)this.getProperty("modelColumnClauses");
        }

        public void setCellReferenceOptions(SQLFragment cellReferenceOptions) {
            this.setProperty("cellReferenceOptions", cellReferenceOptions);
        }

        public SQLFragment getCellReferenceOptions() {
            return (SQLFragment)this.getProperty("cellReferenceOptions");
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            String referenceModelName = this.getReferenceModelName();
            SQLQuery subQuery = this.getSubquery();
            SQLFragment cellReferenceOptions = this.getCellReferenceOptions();
            SQLFragment modelColumnClauses = this.getModelColumnClauses();
            sql.append(ModelObject.REFERENCE).append(" ").append(referenceModelName).append(" ").append(ModelObject.ON).append(" ").append(ModelObject.LEFT_PAREN).append(subQuery.getSQLText()).append(ModelObject.RIGHT_PAREN).append(modelColumnClauses);
            if (cellReferenceOptions != null) {
                sql.append(" ").append(cellReferenceOptions.getSQLText());
            }
            return sql.toString();
        }
    }

    public static class ModelColumnClauses
    extends AbstractSQLFragment {
        public void setPartitionByExpressionList(SQLFragment expressionList) {
            this.setProperty("partitionByExpressionList", expressionList);
        }

        public SQLFragment getPartitionByExpressionList() {
            return (SQLFragment)this.getProperty("partitionByExpressionList");
        }

        public void setDimensionByExpressionList(SQLFragment expressionList) {
            this.setProperty("dimensionByExpressionList", expressionList);
        }

        public SQLFragment getDimensionByExpressionList() {
            return (SQLFragment)this.getProperty("dimensionByExpressionList");
        }

        public void setMeasuresExpressionList(SQLFragment expressionList) {
            this.setProperty("measuresExpressionList", expressionList);
        }

        public SQLFragment getMeasuresExpressionList() {
            return (SQLFragment)this.getProperty("measuresExpressionList");
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            SQLFragment partitionByExpressionList = this.getPartitionByExpressionList();
            SQLFragment dimensionByExpressionList = this.getDimensionByExpressionList();
            SQLFragment measuresExpressionList = this.getMeasuresExpressionList();
            this.appendModelColumnClause(sql, ModelObject.PARTITION_BY, partitionByExpressionList);
            this.appendModelColumnClause(sql, ModelObject.DIMENSION_BY, dimensionByExpressionList);
            this.appendModelColumnClause(sql, ModelObject.MEASURES, measuresExpressionList);
            return sql.toString();
        }

        private void appendModelColumnClause(StringBuilder sql, String clauseName, SQLFragment exprList) {
            if (exprList != null) {
                sql.append(clauseName);
                String expression = exprList.getSQLText();
                sql.append(" ");
                if (expression.startsWith(ModelObject.LEFT_PAREN) && expression.endsWith(ModelObject.RIGHT_PAREN)) {
                    sql.append(expression);
                } else {
                    sql.append(ModelObject.LEFT_PAREN).append(expression).append(ModelObject.RIGHT_PAREN);
                }
                sql.append(" ").append("\n");
            }
        }
    }

    public static class CellReferenceOptions
    extends AbstractSQLFragment {
        public CellReferenceOptions() {
            this.setIgnoreNav(this.getIgnoreNav());
            this.setKeepNav(this.getKeepNav());
            this.setUniqueDimension(this.getUniqueDimension());
            this.setUniqueSingleReference(this.getUniqueSingleReference());
        }

        public void setIgnoreNav(boolean ignorNav) {
            this.setProperty("ignoreNav", ignorNav);
        }

        public boolean getIgnoreNav() {
            return (Boolean)this.getProperty("ignoreNav", false);
        }

        public void setKeepNav(boolean keepNav) {
            this.setProperty("keepNav", keepNav);
        }

        public boolean getKeepNav() {
            return (Boolean)this.getProperty("keepNav", false);
        }

        public void setUniqueDimension(boolean uniqueDimension) {
            this.setProperty("uniqueDimension", uniqueDimension);
        }

        public boolean getUniqueDimension() {
            return (Boolean)this.getProperty("uniqueDimension", false);
        }

        public void setUniqueSingleReference(boolean uniqueSingleReference) {
            this.setProperty("uniqueSingleReference", uniqueSingleReference);
        }

        public boolean getUniqueSingleReference() {
            return (Boolean)this.getProperty("uniqueSingleReference", false);
        }

        @Override
        public String getSQLText() {
            StringBuilder sql = new StringBuilder();
            if (this.getIgnoreNav()) {
                sql.append(" ").append(ModelObject.IGNORE).append(" ").append(ModelObject.NAV);
            } else if (this.getKeepNav()) {
                sql.append(" ").append(ModelObject.KEEP).append(" ").append(ModelObject.NAV);
            }
            if (this.getUniqueDimension()) {
                sql.append(" ").append(ModelObject.UNIQUE).append(" ").append(ModelObject.DIMENSION);
            } else if (this.getUniqueSingleReference()) {
                sql.append(" ").append(ModelObject.UNIQUE).append(" ").append(ModelObject.SINGLE).append(" ").append(ModelObject.REFERENCE);
            }
            return sql.toString();
        }
    }
}

