/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SetOperator;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public class SQLQuery
extends AbstractSQLFragment {
    public static final String TYPE = "SQLQuery";
    public static final String SQL_TEMPLATE = "SELECT \n    \nFROM \n    \n";
    private static final String WITH = "WITH";

    public SQLQuery() {
        this(null);
    }

    public SQLQuery(String queryText) {
        this.setQueryString(queryText);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void processPropertyChange(DBObjectChange change) {
        super.processPropertyChange(change);
        Collection<String> changed = change.getAllChangedProperties();
        if (!changed.contains("queryString") && !changed.contains("declarative")) {
            for (String prop : changed) {
                PropertyInfo info = PropertyHelper.findPropertyInfo(this.getClass(), prop, (DBObjectProvider)null);
                if (info == null || !info.isDerived() || !"queryString".equals(info.getDerivedSourceProperty())) continue;
                this.setDeclarative(true);
                this.setQueryString(null);
                break;
            }
        }
    }

    @Internal
    public boolean isDeclarative() {
        return (Boolean)this.getProperty("declarative", false);
    }

    public void setDeclarative(boolean declarative) {
        this.setProperty("declarative", declarative);
    }

    @TextProperty(multiLine=true)
    public String getQueryString() {
        String query = (String)this.getProperty("queryString");
        if (!ModelUtil.hasLength((String)query) && this.isDeclarative()) {
            query = this.constructQueryText();
        }
        return query;
    }

    public void setQueryString(String query) {
        this.setProperty("queryString", query);
    }

    @Deprecated
    protected void clearQueryString() {
    }

    @Derived(value="queryString")
    public SelectObject[] getSelectObjects() {
        return this.getChildSupport("selectObjects").getChildArray(SelectObject.class);
    }

    @Transient
    public void setSelectObjects(SelectObject[] selects) {
        this.getChildSupport("selectObjects").setChildArray(selects);
    }

    public void addSelectObject(SelectObject s) {
        this.getChildSupport("selectObjects").addChild(s);
    }

    public void addSelectObject(int index, SelectObject s) {
        this.getChildSupport("selectObjects").addChild(index, s);
    }

    public boolean removeSelectObject(SelectObject s) {
        return this.getChildSupport("selectObjects").removeChild(s);
    }

    public void moveSelectObject(SelectObject s, int newIndex) {
        this.getChildSupport("selectObjects").moveChild(s, newIndex);
    }

    public int indexOf(SelectObject s) {
        return this.getChildSupport("selectObjects").indexOfChild(s);
    }

    @Derived(value="queryString")
    public FromObject[] getFromObjects() {
        return this.getChildSupport("fromObjects").getChildArray(FromObject.class);
    }

    @Transient
    public void setFromObjects(FromObject[] froms) {
        this.getChildSupport("fromObjects").setChildArray(froms);
    }

    public void addFromObject(FromObject f) {
        this.getChildSupport("fromObjects").addChild(f);
    }

    public void addFromObject(int index, FromObject f) {
        this.getChildSupport("fromObjects").addChild(index, f);
    }

    public boolean removeFromObject(FromObject f) {
        return this.getChildSupport("fromObjects").removeChild(f);
    }

    public void moveFromObject(FromObject f, int newIndex) {
        this.getChildSupport("fromObjects").moveChild(f, newIndex);
    }

    public int indexOf(FromObject f) {
        return this.getChildSupport("fromObjects").indexOfChild(f);
    }

    @Derived(value="queryString")
    public OrderByObject[] getOrderByObjects() {
        return this.getChildSupport("orderByObjects").getChildArray(OrderByObject.class);
    }

    @Transient
    public void setOrderByObjects(OrderByObject[] orderBys) {
        this.getChildSupport("orderByObjects").setChildArray(orderBys);
    }

    public void addOrderByObject(OrderByObject o) {
        this.getChildSupport("orderByObjects").addChild(o);
    }

    public void addOrderByObject(int index, OrderByObject o) {
        this.getChildSupport("orderByObjects").addChild(index, o);
    }

    public boolean removeOrderByObject(OrderByObject o) {
        return this.getChildSupport("orderByObjects").removeChild(o);
    }

    public void moveOrderByObject(OrderByObject o, int newIndex) {
        this.getChildSupport("orderByObjects").moveChild(o, newIndex);
    }

    public int indexOf(OrderByObject o) {
        return this.getChildSupport("orderByObjects").indexOfChild(o);
    }

    @Transient
    public void setWhereObject(WhereObject where) {
        this.setProperty("whereObject", where);
    }

    @Derived(value="queryString")
    public WhereObject getWhereObject() {
        return (WhereObject)this.getProperty("whereObject");
    }

    @Transient
    public void setSetOperator(SetOperator setOperator) {
        this.setProperty("setOperator", setOperator);
    }

    @Derived(value="queryString")
    public SetOperator getSetOperator() {
        return (SetOperator)this.getProperty("setOperator");
    }

    @Transient
    public void setHierarchicalQueryObject(HierarchicalQueryObject connectby) {
        this.setProperty("hierarchicalQueryObject", connectby);
    }

    @Derived(value="queryString")
    public HierarchicalQueryObject getHierarchicalQueryObject() {
        return (HierarchicalQueryObject)this.getProperty("hierarchicalQueryObject");
    }

    @Transient
    public void setGroupByObject(GroupByObject groupby) {
        this.setProperty("groupByObject", groupby);
    }

    @Derived(value="queryString")
    public GroupByObject getGroupByObject() {
        return (GroupByObject)this.getProperty("groupByObject");
    }

    @Transient
    public void setModelObject(ModelObject model) {
        this.setProperty("modelObject", model);
    }

    @Derived(value="queryString")
    public ModelObject getModelObject() {
        return (ModelObject)this.getProperty("modelObject");
    }

    @Transient
    public void setDistinct(boolean isDistinct) {
        this.setProperty("distinct", isDistinct);
    }

    @Derived(value="queryString")
    public boolean isDistinct() {
        return (Boolean)this.getProperty("distinct", false);
    }

    @Transient
    public void setOrderSiblings(boolean orderSiblings) {
        this.setProperty("orderSiblings", orderSiblings);
    }

    @Derived(value="queryString")
    public boolean isOrderSiblings() {
        return (Boolean)this.getProperty("orderSiblings", false);
    }

    @Transient
    public void setDistinctSource(String distinctSource) {
        this.setProperty("distinctSource", distinctSource);
    }

    @Derived(value="queryString")
    public String getDistinctSource() {
        return (String)this.getProperty("distinctSource");
    }

    @Override
    public String getSQLText() {
        return this.getQueryString();
    }

    private void terminatePreviousLine(StringBuilder sql) {
        int len = sql.length();
        if (len > 0 && !"\n".equals(Character.valueOf(sql.charAt(len - 1)))) {
            sql.append(" ").append("\n");
        }
    }

    private String constructQueryText() {
        StringBuilder sql = new StringBuilder();
        SetOperator setOperator = this.getSetOperator();
        if (setOperator == null) {
            ModelObject model;
            GroupByObject groupby;
            HierarchicalQueryObject connectBy;
            this.appendSelectSQL(sql);
            this.appendFromSQL(sql);
            WhereObject where = this.getWhereObject();
            if (where != null) {
                this.terminatePreviousLine(sql);
                sql.append("WHERE").append(" ").append("\n");
                this.appendToBuffer(sql, where.getSQLText(), "    ");
            }
            if ((connectBy = this.getHierarchicalQueryObject()) != null) {
                this.terminatePreviousLine(sql);
                sql.append(connectBy.getSQLText());
            }
            if ((groupby = this.getGroupByObject()) != null) {
                this.terminatePreviousLine(sql);
                sql.append(groupby.getSQLText());
            }
            if ((model = this.getModelObject()) != null) {
                this.terminatePreviousLine(sql);
                sql.append(model.getSQLText());
            }
        } else {
            sql.append(setOperator.getSQLText());
        }
        OrderByObject[] obos = this.getOrderByObjects();
        if (obos != null && obos.length > 0) {
            this.terminatePreviousLine(sql);
            sql.append(this.isOrderSiblings() ? ORDERSIBLINGSBY : ORDERBY).append(" ").append("\n");
            this.appendToBuffer(sql, Arrays.asList(obos), "    ");
        }
        return sql.toString();
    }

    protected void appendSelectSQL(StringBuilder sql) {
        boolean firstWith = true;
        for (FromObject fo : this.getFromObjects()) {
            if (!fo.isWith()) continue;
            if (firstWith) {
                sql.append(WITH);
                firstWith = false;
            } else {
                sql.append(",");
            }
            sql.append("\n");
            this.appendToBuffer(sql, fo.getSQLText(), "    ");
        }
        if (!firstWith) {
            sql.append("\n");
        }
        sql.append("SELECT").append(" ");
        String distinct = this.getDistinctSource();
        if (ModelUtil.hasLength((String)distinct)) {
            sql.append(distinct).append(" ");
        }
        sql.append("\n");
        SelectObject[] selects = this.getSelectObjects();
        if (selects.length > 0) {
            this.appendToBuffer(sql, Arrays.asList(selects), "    ");
            sql.append(" ");
        } else {
            sql.append("    ");
        }
        sql.append("\n");
    }

    protected void appendFromSQL(StringBuilder sql) {
        sql.append("FROM");
        boolean first = true;
        for (FromObject fo : this.getFromObjects()) {
            if (fo.isWith()) continue;
            if (!first) {
                sql.append(",");
            }
            first = false;
            sql.append(" ").append("\n");
            this.appendToBuffer(sql, fo.getSQLText(), "    ");
        }
        if (first) {
            sql.append(" ").append("\n");
            sql.append("    ").append("\n");
        }
    }
}

