/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;

public abstract class SQLQueryBuilderFactory {
    public final SQLQueryBuilder createSQLQueryBuilder(DBObjectProvider provider) {
        return this.createBuilderImpl(provider, SQLQueryBuilderFactory.checkDefaultSchema(provider, null));
    }

    public final SQLQueryBuilder createSQLQueryBuilder(DBObjectProvider provider, Schema defaultSchema) {
        defaultSchema = SQLQueryBuilderFactory.checkDefaultSchema(provider, defaultSchema);
        return this.createBuilderImpl(provider, defaultSchema);
    }

    protected abstract SQLQueryBuilder createBuilderImpl(DBObjectProvider var1, Schema var2);

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider) {
        return SQLQueryBuilderFactory.createBuilder(provider, null);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, Schema schema) {
        DatabaseDescriptor dd = provider.getDescriptor();
        SQLQueryBuilderFactory f = dd.getSQLQueryBuilderFactory();
        if (f != null) {
            return f.createSQLQueryBuilder(provider, schema);
        }
        return null;
    }

    private static Schema checkDefaultSchema(DBObjectProvider provider, DBObject parent) {
        Schema defaultSchema = null;
        defaultSchema = parent instanceof Schema ? (Schema)parent : DBUtil.getSchema(parent);
        if (defaultSchema == null && provider != null) {
            try {
                defaultSchema = provider.getDefaultSchema();
            }
            catch (DBException dbe) {
                DBLog.getLogger(SQLQueryBuilderFactory.class).warning("Cannot get default schema for sql query building: " + dbe.getMessage());
            }
        }
        return defaultSchema;
    }

    public static SQLQueryBuilder findOrCreateBuilder(SQLQuery query, DBObjectProvider pro) {
        return SQLQueryBuilderFactory.findOrCreateBuilder(query, pro, SQLQueryBuilderFactory.checkDefaultSchema(pro, query));
    }

    public static SQLQueryBuilder findOrCreateBuilder(SQLQuery query, DBObjectProvider pro, Schema defaultSchema) {
        SQLQueryBuilder retval = null;
        DerivedPropertyBuilder dpb = pro.getObjectFactory().ensureDerivedPropertyBuilder(query, false);
        if (dpb instanceof SQLQueryBuilder) {
            retval = (SQLQueryBuilder)((Object)dpb);
            if (dpb instanceof AbstractSQLQueryBuilder) {
                ((AbstractSQLQueryBuilder)dpb).setSQLQuery(query);
                if (defaultSchema != null) {
                    ((AbstractSQLQueryBuilder)dpb).setDefaultSchema(defaultSchema);
                }
            }
        } else if (dpb != null) {
            throw new IllegalStateException("Derived property builder for a query should be a SQLQueryBuilder.");
        }
        return retval;
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, Schema defaultSchema, String sqlText) throws SQLQueryException {
        SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder(provider, defaultSchema);
        builder.buildQuery(sqlText);
        return builder;
    }
}

