/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.lang;

import java.util.Locale;

public class LocaleUtil {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/common/lang/LocaleUtil.java /main/4 2010/02/17 16:23:11 bmoroze Exp $";
    private static final String HE = "he";
    private static final String IW = "iw";
    private static final String AR = "ar";

    public static final String getLanguage(String locale) {
        if (locale == null) {
            return null;
        }
        int len = locale.length();
        if (len > 2) {
            if (locale.charAt(2) == '-' || locale.charAt(2) == '_') {
                return locale.substring(0, 2).toLowerCase();
            }
            return null;
        }
        if (len == 2) {
            return locale.toLowerCase();
        }
        return null;
    }

    public static final String getCountry(String locale) {
        if (locale == null) {
            return null;
        }
        int len = locale.length();
        if (len > 5) {
            if (locale.charAt(2) == '-' || locale.charAt(2) == '_') {
                if (locale.charAt(5) == '-' || locale.charAt(5) == '_') {
                    return locale.substring(3, 5).toUpperCase();
                }
                return null;
            }
            return null;
        }
        if (len == 5) {
            if (locale.charAt(2) == '-' || locale.charAt(2) == '_') {
                return locale.substring(3).toUpperCase();
            }
            return null;
        }
        return null;
    }

    public static final String getVariant(String locale) {
        if (locale == null) {
            return null;
        }
        int len = locale.length();
        if (len > 5) {
            if (locale.charAt(2) == '-' || locale.charAt(2) == '_') {
                if (locale.charAt(5) == '-' || locale.charAt(5) == '_') {
                    return locale.substring(6);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static String validate(String locale) {
        if (locale == null) {
            return locale;
        }
        return locale.replace('_', '-');
    }

    public static final boolean isBidi(String locale) {
        return LocaleUtil.isArabic(locale) || LocaleUtil.isHebrew(locale);
    }

    public static final boolean isArabic(String locale) {
        String loc = LocaleUtil.getLanguage(locale);
        return loc != null && loc.equalsIgnoreCase(AR);
    }

    public static final boolean isHebrew(String locale) {
        String loc = LocaleUtil.getLanguage(locale);
        return loc != null && (loc.equalsIgnoreCase(HE) || loc.equalsIgnoreCase(IW));
    }

    public static final String getDefaultLocaleString() {
        Locale javaLocale = Locale.getDefault();
        return LocaleUtil.getLocaleString(javaLocale);
    }

    public static final String getLocaleString(Locale locale) {
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (lang.equalsIgnoreCase(IW)) {
            lang = HE;
        }
        String localeStr = country.equals("") ? lang : lang + "-" + country;
        return localeStr;
    }

    public static final Locale getLocale(String locale) {
        String lan;
        String ter = "";
        String var = "";
        Object loc = null;
        int i = locale.indexOf("-");
        int j = locale.indexOf("_");
        if (i < 0) {
            i = j;
        }
        if (i > 0) {
            lan = locale.substring(0, i);
            ter = locale.substring(i + 1, locale.length());
            i = ter.indexOf("-");
            j = ter.indexOf("_");
            if (i < 0) {
                i = j;
            }
            if (i > 0) {
                var = ter.substring(i + 1, ter.length());
                ter = ter.substring(0, i);
            }
        } else if (locale.length() > 0) {
            lan = locale;
        } else {
            return LocaleUtil.getLocale(LocaleUtil.getDefaultLocaleString());
        }
        return new Locale(lan.toLowerCase(), ter.toUpperCase(), var);
    }

    public static final boolean isLatin1(String locale) {
        String lang = LocaleUtil.getLanguage(locale);
        if (lang == null) {
            return false;
        }
        return lang.equalsIgnoreCase("ca") || lang.equalsIgnoreCase("da") || lang.equalsIgnoreCase("de") || lang.equalsIgnoreCase("en") || lang.equalsIgnoreCase("es") || lang.equalsIgnoreCase("fi") || lang.equalsIgnoreCase("fr") || lang.equalsIgnoreCase("is") || lang.equalsIgnoreCase("it") || lang.equalsIgnoreCase("ms") || lang.equalsIgnoreCase("nb") || lang.equalsIgnoreCase("nl") || lang.equalsIgnoreCase("nn") || lang.equalsIgnoreCase("no") || lang.equalsIgnoreCase("pt") || lang.equalsIgnoreCase("sv");
    }

    public static final boolean isSimplifiedChinese(String locale) {
        if (locale == null) {
            return false;
        }
        return locale.equalsIgnoreCase("zh-CN") || locale.equalsIgnoreCase("zh-SG");
    }

    public static final boolean isTraditionalChinese(String locale) {
        if (locale == null) {
            return false;
        }
        return locale.equalsIgnoreCase("zh-TW") || locale.equalsIgnoreCase("zh-MO") || locale.equalsIgnoreCase("zh-HK");
    }

    public static final boolean isJapanese(String locale) {
        String lang = LocaleUtil.getLanguage(locale);
        if (lang == null) {
            return false;
        }
        return lang.equalsIgnoreCase("ja");
    }

    public static final boolean isKorean(String locale) {
        String lang = LocaleUtil.getLanguage(locale);
        if (lang == null) {
            return false;
        }
        return lang.equalsIgnoreCase("ko");
    }
}

