/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.util;

import java.io.ByteArrayOutputStream;

public class Hex {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/common/util/Hex.java /main/4 2010/02/17 16:23:11 bmoroze Exp $";

    public static String hex(int c, int len) {
        String valStr = Integer.toHexString(c).toUpperCase();
        int valLen = valStr.length();
        if (valLen >= len) {
            return valStr.substring(valLen - len);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len - valLen; ++i) {
            buf.append('0');
        }
        buf.append(valStr);
        return buf.toString();
    }

    public static String hex(long c, int len) {
        String valStr = Long.toHexString(c).toUpperCase();
        int valLen = valStr.length();
        if (valLen >= len) {
            return valStr.substring(valLen - len);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len - valLen; ++i) {
            buf.append('0');
        }
        buf.append(valStr);
        return buf.toString();
    }

    public static String hex(long val) {
        return "0x" + Long.toHexString(val).toUpperCase();
    }

    public static String hex(int val) {
        return "0x" + Integer.toHexString(val).toUpperCase();
    }

    public static String dump(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buf.append(Hex.hex(b[i] & 0xFF, 2));
        }
        return buf.toString();
    }

    public static String dump(byte[] b, int start, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            buf.append(Hex.hex(b[start + i] & 0xFF, 2));
        }
        return buf.toString();
    }

    public static byte[] parse(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        int count = str.length() / 2;
        for (int i = 0; i < count; ++i) {
            int val = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            tmp.write(val);
        }
        return tmp.toByteArray();
    }

    public static boolean equals(byte[] b1, byte[] b2) {
        int len1 = b1.length;
        int len2 = b2.length;
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

