/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.hover.HoverFlavor;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdevimpl.history.HistoryHyperlink;

final class HistoryHover
extends InfoTipHover {
    static HistoryHover get(final URL url, Collection<HistoryHyperlink> links, List<Object> items, JComponent parent, Point p, InfoTipStyles style) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Insets insets = style.getBorderInsets();
        panel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        panel.setOpaque(false);
        int preferredWidth = 300;
        JComponent comp = HistoryHover.addRevisionIdentifier(style, panel, items);
        preferredWidth = Math.max(preferredWidth, comp.getPreferredSize().width);
        for (int i = 0; i < items.size(); ++i) {
            Pair<HistoryHyperlink, List<String>> tasks;
            if (items.get(i) == null || items.get(i) instanceof RevisionIdentifier) continue;
            if (items.get(i) instanceof String && ((String)items.get(i)).length() > 80) {
                comp = HistoryHover.addTextComponent(style, panel, (String)items.get(i));
            } else if (items.get(i) instanceof String && items.get(i).toString().trim().indexOf(10) >= 0) {
                comp = new JLabel(HistoryHover.getFormatted((String)items.get(i)));
                HistoryHover.addComponent(style, panel, (JLabel)comp);
            } else if (items.get(i) instanceof Date) {
                DateFormat df = DateFormat.getDateTimeInstance();
                comp = new JLabel(df.format((Date)items.get(i)));
                HistoryHover.addComponent(style, panel, (JLabel)comp);
            } else {
                comp = new JLabel(items.get(i).toString());
                HistoryHover.addComponent(style, panel, (JLabel)comp);
            }
            preferredWidth = Math.max(preferredWidth, comp.getPreferredSize().width);
            if (i != items.size() - 1 || !(items.get(i) instanceof String) || (tasks = HistoryHover.getTextFromPattern(links, (String)items.get(i))) == null) continue;
            HistoryHover.addTaskLinks(style, panel, ((HistoryHyperlink)tasks.getFirst()).getLabel(), preferredWidth, (Collection)tasks.getSecond(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = e.getSource();
                    if (obj instanceof AbstractButton) {
                        ((HistoryHyperlink)tasks.getFirst()).getProvider().executeHyperlink(url, ((AbstractButton)obj).getText());
                    }
                }
            });
        }
        return new HistoryHover((Template)new BasicTemplate((JComponent)panel), InfoTipStyles.DEFAULT, parent, p);
    }

    private static Pair<HistoryHyperlink, List<String>> getTextFromPattern(Collection<HistoryHyperlink> links, String value) {
        Pair tasksInfo = new Pair();
        ArrayList<String> str = new ArrayList<String>();
        for (HistoryHyperlink link : links) {
            Pattern pt = Pattern.compile(link.getPattern());
            Matcher matcher = pt.matcher(value);
            while (matcher.find()) {
                str.add(value.substring(matcher.start(), matcher.end()));
            }
            if (str.isEmpty()) continue;
            tasksInfo.setFirst((Object)link);
            tasksInfo.setSecond(str);
            return tasksInfo;
        }
        return null;
    }

    private static void addTaskLinks(InfoTipStyles style, JPanel panel, String labelTxt, int preferredWidth, Collection<String> bugs, ActionListener aListener) {
        if (bugs != null && !bugs.isEmpty()) {
            ArrayList<String> bugList = new ArrayList<String>(bugs);
            Collections.sort(bugList);
            JPanel bugPanel = new JPanel(new FlowLayout(0, 0, 0));
            bugPanel.setOpaque(false);
            if (labelTxt != null) {
                JLabel label = new JLabel(labelTxt);
                label.setOpaque(false);
                label.setForeground(style.getContentTextColor());
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
                bugPanel.add(label);
            }
            int w = 0;
            int h = 0;
            int maxHeight = 0;
            for (String bug : bugList) {
                HyperlinkButton bugField = new HyperlinkButton(bug);
                bugField.setForeground(style.getHyperLinkTextColor(false));
                bugField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                Dimension d = bugField.getPreferredSize();
                d.width += 5;
                bugField.setPreferredSize(d);
                if ((w += d.width) > preferredWidth) {
                    w = d.width;
                    h += maxHeight;
                    maxHeight = 0;
                }
                maxHeight = Math.max(maxHeight, d.height);
                bugField.addActionListener(aListener);
                bugPanel.add((Component)bugField);
            }
            bugPanel.setPreferredSize(new Dimension(w + 3, h += maxHeight));
            GridBagConstraints gbc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, style.getItemTitleInsets(), 0, 0);
            gbc.insets = new Insets(3, 0, 0, 0);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            panel.add((Component)bugPanel, gbc);
        }
    }

    private static void addComponent(InfoTipStyles style, JPanel panel, JLabel label) {
        label.setBorder(BorderFactory.createEmptyBorder());
        label.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, style.getItemTitleInsets(), 0, 0);
        panel.add((Component)label, gbc);
    }

    private static String getFormatted(String item) {
        StringBuffer htmlBuffer = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(item.toString()));
        try {
            String s;
            while ((s = br.readLine()) != null) {
                if (htmlBuffer.length() > 0) {
                    htmlBuffer.append("<br>");
                }
                htmlBuffer.append(s);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        htmlBuffer.append("</html>");
        htmlBuffer.insert(0, "<html>");
        return htmlBuffer.toString();
    }

    private static JLabel addRevisionIdentifier(InfoTipStyles style, JPanel panel, List<Object> items) {
        for (Object item : items) {
            if (item == null || !(item instanceof RevisionIdentifier)) continue;
            JLabel label = new JLabel(item.toString());
            label.setFont(style.getItemTitleFont());
            HistoryHover.addComponent(style, panel, label);
            return label;
        }
        return new JLabel();
    }

    private static JTextArea addTextComponent(InfoTipStyles style, JPanel panel, String comment) {
        GridBagConstraints gbc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, style.getItemTitleInsets(), 0, 0);
        JTextArea text = new JTextArea(comment.trim());
        text.setBackground(Color.WHITE);
        text.setEditable(false);
        text.setColumns(35);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setRows(7);
        text.setForeground(style.getContentTextColor());
        JScrollPane pane = new JScrollPane(text);
        pane.setBorder(BorderFactory.createLineBorder(style.getInternalBorderColor()));
        pane.setHorizontalScrollBarPolicy(31);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(3, 0, 0, 0);
        panel.add((Component)pane, gbc);
        return text;
    }

    public HistoryHover(Template template, InfoTipStyles infoTipStyles, JComponent jComponent, Rectangle rectangle) {
        super(template, infoTipStyles, jComponent, rectangle, HoverFlavor.getFlavor((String)"info"));
    }

    public HistoryHover(Template template, InfoTipStyles infoTipStyles, JComponent jComponent, Point point) {
        super(template, infoTipStyles, jComponent, point, HoverFlavor.getFlavor((String)"info"));
    }
}

