/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import oracle.ide.print.core.text.Document;
import oracle.ide.print.core.text.Symbol;
import oracle.ide.print.misc.Util;

public final class Provider
extends oracle.ide.print.core.comp.Provider {
    private char[] myText;
    private int[] myStyles;
    private Color[] myColors;
    private int mySelectionStart;
    private int mySelectionEnd;

    public Provider(String text, String name) {
        this(null, null, null, 0, text.length(), name);
        this.myText = new char[text.length()];
        int i = text.length();
        while (--i >= 0) {
            this.myText[i] = text.charAt(i);
        }
    }

    public Provider(char[] text, String name) {
        this(text, null, null, 0, text.length, name);
    }

    public Provider(char[] text, int[] styles, Color[] colors, int selectionStart, int selectionEnd, String name) {
        super(name);
        this.myText = text;
        this.myStyles = styles;
        this.myColors = colors;
        this.mySelectionStart = selectionStart;
        this.mySelectionEnd = selectionEnd;
    }

    private Component createDocument() {
        int i;
        int start = Util.getConfig().hasSelection() ? this.mySelectionStart : 0;
        int end = Util.getConfig().hasSelection() ? this.mySelectionEnd : this.myText.length;
        Symbol[] symbols = new Symbol[end - start];
        Color color = Util.getConfig().getTextColor();
        Font font = Util.getConfig().getTextFont();
        Font[] fonts = new Font[4];
        for (i = 0; i < fonts.length; ++i) {
            fonts[i] = new Font(font.getName(), i, font.getSize());
        }
        for (i = start; i < end; ++i) {
            symbols[i - start] = new Symbol(this.myText[i], this.getFont(i, fonts, font), this.getColor(i, color));
        }
        return new Document(symbols);
    }

    private Font getFont(int i, Font[] fonts, Font font) {
        if (this.myStyles == null || !Util.getConfig().hasFontStyle()) {
            return font;
        }
        return fonts[this.myStyles[i]];
    }

    private Color getColor(int i, Color color) {
        if (this.myColors == null || !Util.getConfig().hasForegroundColors()) {
            return color;
        }
        return this.myColors[i];
    }

    @Override
    protected Component getComponent() {
        return this.createDocument();
    }
}

