/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.Bundle;
import oracle.ide.ceditor.find.CurrentToolbarOptionsImpl;
import oracle.ide.ceditor.find.FindController;
import oracle.ide.ceditor.find.FindOptions;
import oracle.ide.ceditor.find.FindToolbar;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.ceditor.find.ReplaceToolbar;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.segmented.DefaultSegment;
import oracle.javatools.ui.segmented.Segment;
import oracle.javatools.ui.segmented.SegmentButton;
import oracle.javatools.ui.segmented.SegmentedControl;

final class FindToolbarOptions {
    private Toolbar toolbar;
    private SegmentedControl<String> segmented;
    private ToggleToolButton replaceToggle;
    private static final String CASE_ID = "case";
    private static final String WORD_ID = "word";
    private static final String REGEX_ID = "regex";
    private static final String SELECTED_ID = "selected";
    private static final String WRAP_ID = "wrap";
    private static final String HIGHLIGHT_ID = "highlight";

    FindToolbarOptions(BasicEditorPane editor, final FindToolbar findToolbar) {
        DefaultSegment caseSegment = new DefaultSegment((Object)CASE_ID, OracleIcons.getIcon((String)"matchcase.png"), Bundle.get("ISEARCH_OPTION_MATCH_CASE_TIP"));
        DefaultSegment wordSegment = new DefaultSegment((Object)WORD_ID, OracleIcons.getIcon((String)"whole_word.png"), Bundle.get("ISEARCH_OPTION_WHOLE_WORD_TIP"));
        DefaultSegment highlightSegment = new DefaultSegment((Object)HIGHLIGHT_ID, OracleIcons.getIcon((String)"findhighlight.png"), Bundle.get("ISEARCH_OPTION_HIGHLIGHT_ALL_TIP"));
        DefaultSegment regexpSegment = new DefaultSegment((Object)REGEX_ID, OracleIcons.getIcon((String)"regexp.png"), Bundle.get("ISEARCH_OPTION_REGEXP_TIP"));
        DefaultSegment selectedSegment = new DefaultSegment((Object)SELECTED_ID, OracleIcons.getIcon((String)"selected.png"), Bundle.get("ISEARCH_OPTION_SELECTED_TIP"));
        DefaultSegment wrapSegment = new DefaultSegment((Object)WRAP_ID, OracleIcons.getIcon((String)"wrap.png"), Bundle.get("ISEARCH_OPTION_WRAP_TIP"));
        this.segmented = new SegmentedControl(SegmentedControl.SelectionType.MULTIPLE);
        this.segmented.addSegment((Segment)caseSegment);
        this.segmented.addSegment((Segment)wordSegment);
        this.segmented.addSegment((Segment)highlightSegment);
        this.segmented.addSegment((Segment)regexpSegment);
        this.segmented.addSegment((Segment)selectedSegment);
        this.segmented.addSegment((Segment)wrapSegment);
        List buttons = this.segmented.getSegmentButtons();
        ((SegmentButton)buttons.get(0)).setName("find-option-case");
        ((SegmentButton)buttons.get(1)).setName("find-option-word");
        ((SegmentButton)buttons.get(2)).setName("find-option-highlight");
        ((SegmentButton)buttons.get(3)).setName("find-option-regex");
        ((SegmentButton)buttons.get(4)).setName("find-option-selected");
        ((SegmentButton)buttons.get(5)).setName("find-option-wrap");
        FindOptions findOptions = FindController.getFindOptions();
        if (findOptions.getMatchCase()) {
            this.segmented.setSelected((Segment)caseSegment);
        }
        if (findOptions.getWholeWordOnly()) {
            this.segmented.setSelected((Segment)wordSegment);
        }
        if (findOptions.getHighlightOccurrences()) {
            this.segmented.setSelected((Segment)highlightSegment);
        }
        if (findOptions.getRegexpSearch()) {
            this.segmented.setSelected((Segment)regexpSegment);
        }
        if (findOptions.getSearchSelected()) {
            this.segmented.setSelected((Segment)selectedSegment);
        }
        if (findOptions.getWrapAround()) {
            this.segmented.setSelected((Segment)wrapSegment);
        }
        this.segmented.addItemListener(new ItemListener((Segment)caseSegment, (Segment)wordSegment, (Segment)highlightSegment, (Segment)regexpSegment, (Segment)selectedSegment, (Segment)wrapSegment, findToolbar, editor){
            final /* synthetic */ Segment val$caseSegment;
            final /* synthetic */ Segment val$wordSegment;
            final /* synthetic */ Segment val$highlightSegment;
            final /* synthetic */ Segment val$regexpSegment;
            final /* synthetic */ Segment val$selectedSegment;
            final /* synthetic */ Segment val$wrapSegment;
            final /* synthetic */ FindToolbar val$findToolbar;
            final /* synthetic */ BasicEditorPane val$editor;
            {
                this.val$caseSegment = segment;
                this.val$wordSegment = segment2;
                this.val$highlightSegment = segment3;
                this.val$regexpSegment = segment4;
                this.val$selectedSegment = segment5;
                this.val$wrapSegment = segment6;
                this.val$findToolbar = findToolbar;
                this.val$editor = basicEditorPane;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                FindOptions findOptions = FindController.getFindOptions();
                findOptions.setMatchCase(FindToolbarOptions.this.segmented.isSelected(this.val$caseSegment));
                findOptions.setWholeWordOnly(FindToolbarOptions.this.segmented.isSelected(this.val$wordSegment));
                findOptions.setHighlightOccurrences(FindToolbarOptions.this.segmented.isSelected(this.val$highlightSegment));
                findOptions.setRegexpSearch(FindToolbarOptions.this.segmented.isSelected(this.val$regexpSegment));
                findOptions.setSearchSelected(FindToolbarOptions.this.segmented.isSelected(this.val$selectedSegment));
                findOptions.setWrapAround(FindToolbarOptions.this.segmented.isSelected(this.val$wrapSegment));
                if (e.getItem() == this.val$regexpSegment) {
                    this.val$findToolbar.validateRegExp();
                }
                if (e.getItem() == this.val$selectedSegment) {
                    boolean isSelected = FindToolbarOptions.this.segmented.isSelected(this.val$selectedSegment);
                    this.val$findToolbar.selectedRegion(isSelected);
                    if (isSelected) {
                        this.val$findToolbar.refind();
                    }
                    return;
                }
                if (e.getItem() == this.val$highlightSegment) {
                    if (FindToolbarOptions.this.segmented.isSelected(this.val$highlightSegment)) {
                        FindResult result = Finder.getLatestFindResult((BasicEditorPane)this.val$editor);
                        if (result != null && result.getFinds() != null) {
                            Finder.highlight((BasicEditorPane)this.val$editor, (List)result.getFinds());
                        } else {
                            Finder.clearHighlights((BasicEditorPane)this.val$editor);
                        }
                    } else {
                        Finder.clearHighlights((BasicEditorPane)this.val$editor);
                    }
                } else {
                    this.val$findToolbar.refind();
                }
            }
        });
        this.replaceToggle = this.buildReplace(editor);
        this.toolbar = new Toolbar();
        this.toolbar.add(this.segmented);
        this.toolbar.addFiller();
        this.toolbar.add((Component)this.replaceToggle);
        this.toolbar.addFiller();
        this.toolbar.setBorder(null);
        this.toolbar.setVisible(false);
        InputMap inputMap = this.toolbar.getInputMap(1);
        ActionMap actionMap = this.toolbar.getActionMap();
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                findToolbar.cancel();
            }
        };
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
        actionMap.put(cancelAction, cancelAction);
    }

    void disallowReplace() {
        this.toolbar.remove((Component)this.replaceToggle);
    }

    void allowExtraButtons() {
        ToolbarManager toolbarManager = ToolbarManager.getToolbarManager();
        toolbarManager.registerOnDemandToolbar("oracle.ide.ceditor.toolbar.find.options", this.toolbar, null);
        this.toolbar.addFiller();
    }

    void dispose() {
        ToolbarManager toolbarManager = ToolbarManager.getToolbarManager();
        toolbarManager.unRegisterOnDemandToolbar("oracle.ide.ceditor.toolbar.find.options", this.toolbar);
    }

    Component getOptionsComponent() {
        return this.toolbar;
    }

    private ToggleToolButton buildReplace(final BasicEditorPane editor) {
        ToggleAction replaceToggleAction = new ToggleAction(null, OracleIcons.getIcon((String)"find_and_replace.png")){

            public void actionPerformed(ActionEvent e) {
                FindToolbarController findToolbarController;
                boolean wasVisible = (findToolbarController = AbstractFindToolbarController.getFindController(editor)).isReplaceShowing();
                findToolbarController.setReplaceShowing(!wasVisible);
                FindOptions findOptions = FindController.getFindOptions();
                ReplaceToolbar replaceToolbar = findToolbarController.getReplaceToolbar();
                if (!wasVisible) {
                    replaceToolbar.setSearchFieldText(findOptions.getSearchText());
                }
            }
        };
        ToggleToolButton button = new ToggleToolButton(replaceToggleAction);
        button.setText(null);
        button.setToolTipText(Bundle.get("ISEARCH_OPTION_REPLACE_TOGGLE"));
        button.setFocusable(true);
        button.setName("find-option-replace");
        return button;
    }

    void populateCurrentOptions(CurrentToolbarOptionsImpl currentOptions) {
        currentOptions.setMatchCase(this.segmented.isSelected((Object)CASE_ID));
        currentOptions.setWholeWord(this.segmented.isSelected((Object)WORD_ID));
        currentOptions.setHighlightOccurences(this.segmented.isSelected((Object)HIGHLIGHT_ID));
        currentOptions.setRegExp(this.segmented.isSelected((Object)REGEX_ID));
        currentOptions.setSelected(this.segmented.isSelected((Object)SELECTED_ID));
        currentOptions.setWrap(this.segmented.isSelected((Object)WRAP_ID));
    }
}

