/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.jdevimpl.help.DirectURLTarget;
import oracle.jdevimpl.help.MacroURLTarget;

public class MultipleTypeTopic
extends SimpleTopic {
    public static final int STANDARD_HELP_TOPIC = 0;
    public static final int EXTERNAL_TOPIC = 3;
    public static final int LANGUAGE_TOPIC = 4;
    public static final int JAVADOC_TOPIC = 5;
    public static final int BOOK_TOPIC = 6;
    public static final int OTN_TOPIC = 9;
    public static final int TAHITI_TOPIC = 10;
    public static final int EXTERNAL_MACRO_TOPIC = 11;
    public static final String EXTERNAL_TOPIC_TYPE = "external";
    public static final String LANGUAGE_TOPIC_TYPE = "language";
    public static final String JAVADOC_TOPIC_TYPE = "javadoc";
    public static final String BOOK_TOPIC_TYPE = "book";
    public static final String OTN_TYPE = "otn";
    public static final String TAHITI_TYPE = "tahiti";
    public static final String EXTERNAL_MACRO_TYPE = "externalMacro";
    private int _topicType;
    private String _topicString;
    private String _description;

    public MultipleTypeTopic() {
    }

    public MultipleTypeTopic(String label, String id, String type) {
        super.setLabel(label);
        this._topicType = MultipleTypeTopic.mapTypeToInt(type);
        if (this._topicType == 3 || this._topicType == 9 || this._topicType == 10) {
            DirectURLTarget dTarget = new DirectURLTarget(id);
            super.setTarget((Target)dTarget);
        } else if (this._topicType == 11) {
            MacroURLTarget dTarget = new MacroURLTarget(id);
            super.setTarget((Target)dTarget);
        } else if (this._topicType == 4) {
            this._topicString = id;
        }
    }

    public MultipleTypeTopic(String label) {
        this();
        if (label != null) {
            super.setLabel(label);
        }
    }

    public MultipleTypeTopic(String label, Target target) {
        this(label);
        super.setTarget(target);
    }

    public MultipleTypeTopic(String label, Target target, Target defaultIconTarget, Target activeIconTarget) {
        this(label, target);
        this.setActiveIcon(activeIconTarget);
        this.setDefaultIcon(defaultIconTarget);
    }

    public void setTopicType(int topicType) {
        this._topicType = topicType;
    }

    public int getTopicType() {
        return this._topicType;
    }

    public void setTopicType(String topicType) {
        this._topicType = MultipleTypeTopic.mapTypeToInt(topicType);
    }

    public void setCueCardId(String cueCardId) {
        this._topicString = cueCardId;
    }

    public String getCueCardId() {
        return this._topicString;
    }

    public void setLanguageString(String languageString) {
        this._topicString = languageString;
    }

    public String getLanguageString() {
        return this._topicString;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultipleTypeTopic)) {
            return false;
        }
        MultipleTypeTopic o1 = (MultipleTypeTopic)((Object)o);
        if (o1.getTopicType() == 4 && this.getTopicType() == 4 || o1.getTopicType() == 5 && this.getTopicType() == 5 || o1.getTopicType() == 9 && this.getTopicType() == 9 || o1.getTopicType() == 10 && this.getTopicType() == 10 || o1.getTopicType() == 3 && this.getTopicType() == 3) {
            return o1.getCueCardId().equals(this.getCueCardId());
        }
        return o1.getTopicType() == this._topicType && o1.getTarget().equals(this.getTarget());
    }

    public static int mapTypeToInt(String topicType) {
        int type = 0;
        if (topicType.equalsIgnoreCase(EXTERNAL_TOPIC_TYPE)) {
            type = 3;
        } else if (topicType.equalsIgnoreCase(LANGUAGE_TOPIC_TYPE)) {
            type = 4;
        } else if (topicType.equalsIgnoreCase(JAVADOC_TOPIC_TYPE)) {
            type = 5;
        } else if (topicType.equalsIgnoreCase(BOOK_TOPIC_TYPE)) {
            type = 6;
        } else if (topicType.equalsIgnoreCase(OTN_TYPE)) {
            type = 9;
        } else if (topicType.equalsIgnoreCase(TAHITI_TYPE)) {
            type = 10;
        } else if (topicType.equalsIgnoreCase(EXTERNAL_MACRO_TYPE)) {
            type = 11;
        }
        return type;
    }
}

