/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.util.Hashtable;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.ModelAdapter;
import oracle.dss.dataView.PivotEvent;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.gridView.DatabodyDrillOutEvent;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewControllerActions;
import oracle.dss.gridView.GridViewData;
import oracle.dss.gridView.GridViewDataListener;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.gridView.GridViewDefaultValues;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.GridViewModel;
import oracle.dss.gridView.HeaderDrillOutEvent;
import oracle.dss.gridView.managers.GridViewDatabodyRuleStyles;
import oracle.dss.gridView.managers.GridViewHeaderRuleStyles;
import oracle.dss.gridView.managers.GridViewRuleFormatter;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataMap;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.TypeNotSupportedException;

public abstract class GridViewModelAdapter
extends ModelAdapter
implements GridViewModel,
GridViewControllerActions {
    protected GridView gridView = null;
    protected GridViewData dataSource = null;
    protected GridViewFormatManager gridViewFormatManager = null;
    protected GridViewHeaderStyleManager gridViewHeaderStyleManager = null;
    protected GridViewDatabodyStyleManager gridViewDatabodyStyleManager = null;
    protected ViewFormat viewFormat = null;
    private transient Hashtable metadataCache = new Hashtable();
    private static final String m_method_getdatafromtablecol = "getDataFromTableCol(int col)";
    private static final String m_method_getdatafromtablerow = "getDataFromTableRow(int row)";
    private static final String m_method_gettablefromdatacolumncount = "getTableFromDataRowCount(int count)";
    private static final String m_method_gettablefromdatarowcount = "getTableFromDataColumnCount(int count)";
    private static final String m_method_setsupporteddatalayerflags = "setSupportedDataLayerFlags ()";

    public GridViewModelAdapter(GridView gv) {
        this.gridView = gv;
        this.viewFormat = new ViewFormat();
        this.viewFormat.setViewFormatCallback((ViewFormatCallback)this.gridView);
        this.viewFormat.setView((DataviewCommon)this.gridView);
        this.setGridViewFormatManager(new GridViewRuleFormatter());
        this.setGridViewHeaderStyleManager(new GridViewHeaderRuleStyles());
        this.setGridViewDatabodyStyleManager(new GridViewDatabodyRuleStyles());
        this.initDefaults(new GridViewDefaultValues());
    }

    protected void initDefaults(GridViewDefaultValues gdv) {
        super.initDefaults((DataviewDefaultValues)gdv);
    }

    @Override
    public GridViewData getGridViewDataSource() {
        return this.dataSource;
    }

    protected void setGridViewDataSource(GridViewData gvd) {
        this.dataSource = gvd;
    }

    protected void setSupportedDataLayerFlags() {
        DataMap dataMap = this.getDataDirector().getSupportedDataMap();
        MetadataMap metaMap = this.getDataDirector().getSupportedMetadataMap();
        LayerMetadataMap layerMap = this.getDataDirector().getSupportedLayerMetadataMap();
        boolean typeSupported = false;
        if (dataMap == null) {
            this.gridView.getErrorHandler().trace("Current DataSource has a null DataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (metaMap == null) {
            this.gridView.getErrorHandler().trace("Current DataSource has a null MetadataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (layerMap == null) {
            this.gridView.getErrorHandler().trace("Current DataSource has a null LayerMetadataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (!(typeSupported = dataMap != null ? dataMap.contains((Object)"dataValue") : false)) {
            this.gridView.getErrorHandler().error((Throwable)new TypeNotSupportedException("DataMap", "DATA_UNFORMATTED"), this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        this.gridView.setDataUnformattedSupported(true);
        typeSupported = dataMap != null ? dataMap.contains((Object)"dataFormattedValue") : false;
        this.gridView.setDataFormattedSupported(typeSupported);
        typeSupported = dataMap != null ? dataMap.contains((Object)"dataRatio") : false;
        this.gridView.setDataRatioSupported(typeSupported);
        typeSupported = dataMap != null ? dataMap.contains((Object)"dataViewFormat") : false;
        this.gridView.setDataViewFormatSupported(typeSupported);
        typeSupported = dataMap != null ? dataMap.contains((Object)"dataViewStyle") : false;
        this.gridView.setDataViewStyleSupported(typeSupported);
        typeSupported = dataMap != null ? dataMap.contains((Object)"dataAnnotation") : false;
        this.gridView.setDataAnnotationSupported(typeSupported);
        typeSupported = dataMap != null ? dataMap.contains((Object)"dataIsTotal") : false;
        this.gridView.setDataIsTotalSupported(typeSupported);
        this.gridView.setDataTypeSupported(dataMap != null && dataMap.contains((Object)"dataType"));
        typeSupported = metaMap != null ? metaMap.contains((Object)"label") : false;
        if (!typeSupported) {
            this.gridView.getErrorHandler().error((Throwable)new TypeNotSupportedException("MetadataMap", "METADATA_LONGLABEL"), this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        this.gridView.setMetadataLongLabelSupported(true);
        if (metaMap != null) {
            typeSupported = metaMap.contains((Object)"drillState");
        }
        this.gridView.setMetadataDrillSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"mediumName") : false;
        this.gridView.setMetadataMediumLabelSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"shortName") : false;
        this.gridView.setMetadataShortLabelSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"viewStyle") : false;
        this.gridView.setMetadataViewStyleSupported(typeSupported);
        typeSupported = metaMap != null ? metaMap.contains((Object)"value") : false;
        this.gridView.setMetadataValueSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimShortName") : false;
        this.gridView.setLayerMetaShortLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"dimMediumName") : false;
        this.gridView.setLayerMetaMediumLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"layerLabel") : false;
        this.gridView.setLayerMetaLongLabelSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"layerName") : false;
        this.gridView.setLayerMetaNameSupported(typeSupported);
        typeSupported = layerMap != null ? layerMap.contains((Object)"viewStyle") : false;
        this.gridView.setLayerMetaViewStyleSupported(typeSupported);
    }

    @Override
    public GridViewFormatManager getGridViewFormatManager() {
        return this.gridViewFormatManager;
    }

    @Override
    public void setGridViewFormatManager(GridViewFormatManager fm) {
        this.setFormatManager(fm);
        this.gridViewFormatManager = fm;
    }

    @Override
    public ViewFormat getViewFormat() {
        return this.viewFormat;
    }

    @Override
    public void setViewFormat(ViewFormat vf) {
        this.viewFormat = (ViewFormat)vf.clone();
        this.viewFormat.setViewFormatCallback((ViewFormatCallback)this.gridView);
        this.viewFormat.setView((DataviewCommon)this.gridView);
    }

    @Override
    public GridViewHeaderStyleManager getGridViewHeaderStyleManager() {
        return this.gridViewHeaderStyleManager;
    }

    @Override
    public void setGridViewHeaderStyleManager(GridViewHeaderStyleManager sm) {
        this.gridViewHeaderStyleManager = sm;
    }

    @Override
    public GridViewDatabodyStyleManager getGridViewDatabodyStyleManager() {
        return this.gridViewDatabodyStyleManager;
    }

    @Override
    public void setGridViewDatabodyStyleManager(GridViewDatabodyStyleManager sm) {
        this.gridViewDatabodyStyleManager = sm;
    }

    @Override
    public int getDataFromTableRow(int row) {
        if (row < 0) {
            this.gridView.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getdatafromtablerow);
            return 0;
        }
        return row;
    }

    @Override
    public int getDataFromTableCol(int col) {
        if (col < 0) {
            this.gridView.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getdatafromtablecol);
            return 0;
        }
        return col;
    }

    @Override
    public int getTableFromDataRowCount(int count) {
        if (count < 0) {
            this.gridView.getErrorHandler().log("invalid row count", this.getClass().getName(), m_method_gettablefromdatarowcount);
            return 0;
        }
        return count;
    }

    @Override
    public int getTableFromDataColumnCount(int count) {
        if (count < 0) {
            this.gridView.getErrorHandler().log("invalid column count", this.getClass().getName(), m_method_gettablefromdatacolumncount);
            return 0;
        }
        return count;
    }

    @Override
    public Hashtable getMetadataCache() {
        return this.metadataCache;
    }

    @Override
    public void clearMetadataCache() {
        if (this.metadataCache != null) {
            this.metadataCache.clear();
        }
    }

    @Override
    public void addGridViewDataListener(GridViewDataListener l) {
        this.addDataListener(l);
        this.listenerList.add(GridViewDataListener.class, l);
    }

    @Override
    public void removeGridViewDataListener(GridViewDataListener l) {
        this.removeDataListener(l);
        this.listenerList.remove(GridViewDataListener.class, l);
    }

    @Override
    public GridViewControllerActions getGridViewControllerActions() {
        return this;
    }

    @Override
    public void databodyDrillOutGestureHappened(Object source, int column, int row, int type, int imageIndex) {
        DatabodyDrillOutEvent event = new DatabodyDrillOutEvent(source, column, row, type, imageIndex);
        this.fireDatabodyDrillOut(event);
    }

    @Override
    public void headerDrillOutGestureHappened(Object source, int edge, int layer, int slice, int type, int imageIndex) {
        HeaderDrillOutEvent event = new HeaderDrillOutEvent(source, edge, layer, slice, type, imageIndex);
        this.fireHeaderDrillOut(event);
    }

    @Override
    public boolean reorderGestureHappened(Object source, int edge, int fromLayer, int toLayer, int fromSlice, int toSlice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, DataDirectorException {
        PivotEvent e = new PivotEvent(source, edge, edge, fromLayer, toLayer, fromSlice, toSlice, flags, 1);
        this.fireviewPivotRequesting(e);
        if (e.isConsumed()) {
            return false;
        }
        boolean success = false;
        success = fromSlice > -1 && toSlice > -1 ? this.dataDirector.reorder(edge, fromSlice, toSlice, flags) : this.dataDirector.reorder(edge, fromLayer, toLayer, flags);
        this.fireviewPivotRequested(e);
        return success;
    }

    protected void fireHeaderDrillOut(HeaderDrillOutEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GridViewDataListener.class) continue;
            ((GridViewDataListener)listeners[i + 1]).viewHeaderDrillOut(e);
        }
    }

    protected void fireDatabodyDrillOut(DatabodyDrillOutEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GridViewDataListener.class) continue;
            ((GridViewDataListener)listeners[i + 1]).viewDatabodyDrillOut(e);
        }
    }

    @Override
    public abstract Object clone() throws CloneNotSupportedException;
}

