/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ldap;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.security.pki.OraclePKIProvider;

public class LdapSSLSocketFactory
extends SocketFactory {
    public static final String WALLET_LOCATION = "oracle.ldap.wltloc";
    public static final String WALLET_PASSWORD = "oracle.ldap.wltpass";
    protected static SSLSocketFactory a = null;
    static ResourceBundle b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    public LdapSSLSocketFactory() {
        this(System.getProperties());
    }

    public LdapSSLSocketFactory(Hashtable hashtable) {
        try {
            Security.insertProviderAt(new OraclePKIProvider(), 1);
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "OraclePKI");
            String string = (String)hashtable.get(WALLET_PASSWORD);
            String string2 = (String)hashtable.get(WALLET_LOCATION);
            if (string == null && string2 == null) {
                SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
                sSLContext.init(null, null, null);
                a = sSLContext.getSocketFactory();
            } else {
                File file = new File((String)hashtable.get(WALLET_LOCATION));
                if (!file.exists()) {
                    throw new IOException(b.getString("PKI-02003") + string2);
                }
                FileInputStream fileInputStream = new FileInputStream((String)hashtable.get(WALLET_LOCATION));
                keyStore.load(fileInputStream, string.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509");
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)"SunX509");
                keyManagerFactory.init(keyStore, string.toCharArray());
                KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, null);
                a = sSLContext.getSocketFactory();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while initialization:" + exception.toString());
        }
    }

    public static SocketFactory getDefault() {
        return new LdapSSLSocketFactory();
    }

    public Socket createSocket(String string, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)a.createSocket(string, n2);
        return this.a(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)a.createSocket(inetAddress, n2);
        return this.a(sSLSocket);
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)a.createSocket(string, n2, inetAddress, n3);
        return this.a(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)a.createSocket(inetAddress, n2, inetAddress2, n3);
        return this.a(sSLSocket);
    }

    protected SSLSocket a(SSLSocket sSLSocket) throws IOException {
        String[] stringArray = new String[]{"SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
        sSLSocket.setUseClientMode(true);
        sSLSocket.setEnabledCipherSuites(stringArray);
        sSLSocket.startHandshake();
        return sSLSocket;
    }
}

