/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.core.DSAPrivateKey;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RSA;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.e;
import oracle.security.pki.t;

class n
extends t {
    final PKCS12Bag a;
    Certificate[] b;
    private CertificateRequest d;
    int c = -1;

    n(PKCS12Bag pKCS12Bag, Vector vector) {
        byte[] byArray;
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.a = null;
        ASN1Object aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
        if (aSN1Object instanceof ASN1OctetString) {
            try {
                byArray = ((ASN1OctetString)aSN1Object).getValue();
                this.d = new CertificateRequest(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byArray = pKCS12Bag.getLocalKeyID();
        this.c = e.k(byArray);
        Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
        byte[] byArray2 = e.c(e.j(byArray), e.k(byArray));
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i2);
            if (!this.a(pKCS12CertBag.getLocalKeyID(), byArray2)) continue;
            vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
            vector.removeElementAt(i2);
            OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
            break;
        }
        if (vector2.size() == 0) {
            OraclePKIDebug.a("No certificate found for cert req " + byArray);
            this.b = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i3);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(pKCS12CertBag.getCert().getSubject())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("Cert chain incomplete for key " + this.a);
                break;
            }
            OraclePKIDebug.a("Cert chain determined");
            this.b = new Certificate[vector2.size()];
            this.b = vector2.toArray(this.b);
        }
    }

    n(PKCS12Bag pKCS12Bag, Vector vector, Vector vector2) {
        Object object;
        Object object2;
        RSAPublicKey rSAPublicKey;
        Cloneable cloneable;
        if (!(pKCS12Bag instanceof PKCS12KeyBag) && !(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.a = pKCS12Bag;
        byte[] byArray = this.a.getLocalKeyID();
        this.c = e.k(byArray);
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = BigInteger.TEN;
        RSA rSA = new RSA();
        if (pKCS12Bag instanceof PKCS12KeyBag) {
            cloneable = (RSAPrivateKey)((PKCS12KeyBag)pKCS12Bag).getPrivateKey();
            rSA.setKey((RSAKey)cloneable);
            bigInteger = rSA.performOp(bigInteger2);
        } else if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
            cloneable = (RSAPrivateKey)((PKCS12ShroudedKeyBag)pKCS12Bag).getPrivateKey();
            rSA.setKey((RSAKey)cloneable);
            bigInteger = rSA.performOp(bigInteger2);
        }
        cloneable = new Vector(vector.size());
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i2);
            rSAPublicKey = (RSAPublicKey)pKCS12CertBag.getCert().getPublicKey();
            rSA.setKey(rSAPublicKey);
            object2 = rSA.performOp(bigInteger);
            if (this.a(pKCS12CertBag.getLocalKeyID(), byArray) && ((BigInteger)object2).equals(bigInteger2)) {
                ((Vector)cloneable).addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                vector.removeElementAt(i2);
                OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
                break;
            }
            if (!e.i(byArray)) {
                if (!((BigInteger)object2).equals(bigInteger2)) continue;
                ((Vector)cloneable).addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                vector.removeElementAt(i2);
                OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
                break;
            }
            if (e.c(pKCS12CertBag.getLocalKeyID()) || !((BigInteger)object2).equals(bigInteger2)) continue;
            ((Vector)cloneable).addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
            vector.removeElementAt(i2);
            OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
            break;
        }
        byte[] byArray2 = e.d(e.j(byArray), e.k(byArray));
        for (int i3 = 0; i3 < vector2.size(); ++i3) {
            rSAPublicKey = (PKCS12SecretBag)vector2.elementAt(i3);
            if (!this.a(rSAPublicKey.getLocalKeyID(), byArray2) || !((object2 = rSAPublicKey.getSecretValue()) instanceof ASN1OctetString)) continue;
            try {
                object = ((ASN1OctetString)object2).getValue();
                this.d = new CertificateRequest(object);
                vector2.removeElementAt(i3);
                OraclePKIDebug.a("Found cert req " + this.d);
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (((Vector)cloneable).size() == 0) {
            OraclePKIDebug.a("No certificate found for key " + this.a.getLocalKeyID());
            this.b = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)((Vector)cloneable).lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i4 = 0; i4 < vector.size(); ++i4) {
                    object = (PKCS12CertBag)vector.elementAt(i4);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(object.getCert().getSubject())) continue;
                    bl = true;
                    ((Vector)cloneable).addElement(new OraclePKIX509CertImpl(object.getCert()));
                    x509Certificate = (X509Certificate)((Vector)cloneable).lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("Cert chain incomplete for key " + this.a);
                break;
            }
            OraclePKIDebug.a("Cert chain determined");
            this.b = new Certificate[((Vector)cloneable).size()];
            this.b = ((Vector)cloneable).toArray(this.b);
        }
    }

    String a(byte[] byArray) {
        return new String("personaNum:" + e.j(byArray) + "  componentNum:" + e.k(byArray));
    }

    Key d() {
        PrivateKey privateKey = null;
        if (this.a instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)this.a).getPrivateKey();
        } else if (this.a instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)this.a).getPrivateKey();
        }
        if (privateKey instanceof RSAPrivateKey) {
            return new OraclePKIRSAPrivateKey((RSAPrivateKey)privateKey, this.d);
        }
        if (privateKey instanceof DSAPrivateKey) {
            OraclePKIDebug.a("DSA Keys not supported");
            return null;
        }
        if (this.d != null && this.a == null) {
            return new OraclePKIRSAPrivateKey(null, this.d);
        }
        return null;
    }

    Certificate a() {
        if (this.b == null) {
            return null;
        }
        return this.b[0];
    }

    Certificate[] e() {
        if (this.b == null) {
            return null;
        }
        return (Certificate[])this.b.clone();
    }

    boolean f() {
        return true;
    }

    String c() {
        String string = null;
        Certificate certificate = this.a();
        if (certificate instanceof X509Certificate) {
            OraclePKIDebug.a("Certificate for private key is " + certificate);
            X500Name x500Name = new X500Name(((X509Certificate)certificate).getSubjectDN().getName());
            string = "CN=" + x500Name.getCommonName();
            if (x500Name.getCommonName() == null) {
                string = "OU=" + x500Name.getOrgUnitName();
            }
            return string;
        }
        return "";
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    byte[] h() {
        return this.a.getLocalKeyID();
    }

    int i() {
        return this.c;
    }
}

